/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class BlockStateEnum<T extends Enum<T>>
extends IBlockState<T> {
    private final ImmutableSet<T> values;
    private final Map<String, T> names = Maps.newHashMap();

    protected BlockStateEnum(String var0, Class<T> var1, Collection<T> var2) {
        super(var0, var1);
        this.values = ImmutableSet.copyOf(var2);
        for (Enum var4 : var2) {
            String var5 = ((INamable)((Object)var4)).getSerializedName();
            if (this.names.containsKey(var5)) {
                throw new IllegalArgumentException("Multiple values have the same name '" + var5 + "'");
            }
            this.names.put(var5, var4);
        }
    }

    @Override
    public Collection<T> getPossibleValues() {
        return this.values;
    }

    @Override
    public Optional<T> getValue(String var0) {
        return Optional.ofNullable((Enum)this.names.get(var0));
    }

    @Override
    public String getName(T var0) {
        return ((INamable)var0).getSerializedName();
    }

    @Override
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof BlockStateEnum && super.equals(var0)) {
            BlockStateEnum var1 = (BlockStateEnum)var0;
            return this.values.equals(var1.values) && this.names.equals(var1.names);
        }
        return false;
    }

    @Override
    public int generateHashCode() {
        int var0 = super.generateHashCode();
        var0 = 31 * var0 + this.values.hashCode();
        var0 = 31 * var0 + this.names.hashCode();
        return var0;
    }

    public static <T extends Enum<T>> BlockStateEnum<T> create(String var02, Class<T> var1) {
        return BlockStateEnum.create(var02, var1, (T var0) -> true);
    }

    public static <T extends Enum<T>> BlockStateEnum<T> create(String var0, Class<T> var1, Predicate<T> var2) {
        return BlockStateEnum.create(var0, var1, Arrays.stream((Enum[])var1.getEnumConstants()).filter(var2).collect(Collectors.toList()));
    }

    public static <T extends Enum<T>> BlockStateEnum<T> create(String var0, Class<T> var1, T ... var2) {
        return BlockStateEnum.create(var0, var1, Lists.newArrayList((Object[])var2));
    }

    public static <T extends Enum<T>> BlockStateEnum<T> create(String var0, Class<T> var1, Collection<T> var2) {
        return new BlockStateEnum<T>(var0, var1, var2);
    }
}

