/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.collect.ArrayTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.properties.IBlockState;

public abstract class IBlockDataHolder<O, S> {
    public static final String NAME_TAG = "Name";
    public static final String PROPERTIES_TAG = "Properties";
    public static final Function<Map.Entry<IBlockState<?>, Comparable<?>>, String> PROPERTY_ENTRY_TO_STRING_FUNCTION = new Function<Map.Entry<IBlockState<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<IBlockState<?>, Comparable<?>> var0) {
            if (var0 == null) {
                return "<NULL>";
            }
            IBlockState<?> var1 = var0.getKey();
            return var1.getName() + "=" + this.getName(var1, var0.getValue());
        }

        private <T extends Comparable<T>> String getName(IBlockState<T> var0, Comparable<?> var1) {
            return var0.getName(var1);
        }

        @Override
        public /* synthetic */ Object apply(@Nullable Object object) {
            return this.apply((Map.Entry)object);
        }
    };
    protected final O owner;
    private final ImmutableMap<IBlockState<?>, Comparable<?>> values;
    private Table<IBlockState<?>, Comparable<?>, S> neighbours;
    protected final MapCodec<S> propertiesCodec;

    protected IBlockDataHolder(O var0, ImmutableMap<IBlockState<?>, Comparable<?>> var1, MapCodec<S> var2) {
        this.owner = var0;
        this.values = var1;
        this.propertiesCodec = var2;
    }

    public <T extends Comparable<T>> S cycle(IBlockState<T> var0) {
        return this.setValue(var0, (Comparable)IBlockDataHolder.findNextInCollection(var0.getPossibleValues(), this.getValue(var0)));
    }

    protected static <T> T findNextInCollection(Collection<T> var0, T var1) {
        Iterator<T> var2 = var0.iterator();
        while (var2.hasNext()) {
            if (!var2.next().equals(var1)) continue;
            if (var2.hasNext()) {
                return var2.next();
            }
            return var0.iterator().next();
        }
        return var2.next();
    }

    public String toString() {
        StringBuilder var0 = new StringBuilder();
        var0.append(this.owner);
        if (!this.getValues().isEmpty()) {
            var0.append('[');
            var0.append(this.getValues().entrySet().stream().map(PROPERTY_ENTRY_TO_STRING_FUNCTION).collect(Collectors.joining(",")));
            var0.append(']');
        }
        return var0.toString();
    }

    public Collection<IBlockState<?>> getProperties() {
        return Collections.unmodifiableCollection(this.values.keySet());
    }

    public <T extends Comparable<T>> boolean hasProperty(IBlockState<T> var0) {
        return this.values.containsKey(var0);
    }

    public <T extends Comparable<T>> T getValue(IBlockState<T> var0) {
        Comparable var1 = (Comparable)this.values.get(var0);
        if (var1 == null) {
            throw new IllegalArgumentException("Cannot get property " + var0 + " as it does not exist in " + this.owner);
        }
        return (T)((Comparable)var0.getValueClass().cast(var1));
    }

    public <T extends Comparable<T>> Optional<T> getOptionalValue(IBlockState<T> var0) {
        Comparable var1 = (Comparable)this.values.get(var0);
        if (var1 == null) {
            return Optional.empty();
        }
        return Optional.of((Comparable)var0.getValueClass().cast(var1));
    }

    public <T extends Comparable<T>, V extends T> S setValue(IBlockState<T> var0, V var1) {
        Comparable var2 = (Comparable)this.values.get(var0);
        if (var2 == null) {
            throw new IllegalArgumentException("Cannot set property " + var0 + " as it does not exist in " + this.owner);
        }
        if (var2 == var1) {
            return (S)this;
        }
        Object var3 = this.neighbours.get(var0, var1);
        if (var3 == null) {
            throw new IllegalArgumentException("Cannot set property " + var0 + " to " + var1 + " on " + this.owner + ", it is not an allowed value");
        }
        return (S)var3;
    }

    public void populateNeighbours(Map<Map<IBlockState<?>, Comparable<?>>, S> var0) {
        if (this.neighbours != null) {
            throw new IllegalStateException();
        }
        HashBasedTable var1 = HashBasedTable.create();
        for (Map.Entry var3 : this.values.entrySet()) {
            IBlockState var4 = (IBlockState)var3.getKey();
            for (Comparable var6 : var4.getPossibleValues()) {
                if (var6 == var3.getValue()) continue;
                var1.put((Object)var4, (Object)var6, var0.get(this.makeNeighbourValues(var4, var6)));
            }
        }
        this.neighbours = var1.isEmpty() ? var1 : ArrayTable.create((Table)var1);
    }

    private Map<IBlockState<?>, Comparable<?>> makeNeighbourValues(IBlockState<?> var0, Comparable<?> var1) {
        HashMap var2 = Maps.newHashMap(this.values);
        var2.put(var0, var1);
        return var2;
    }

    public ImmutableMap<IBlockState<?>, Comparable<?>> getValues() {
        return this.values;
    }

    protected static <O, S extends IBlockDataHolder<O, S>> Codec<S> codec(Codec<O> var02, Function<O, S> var1) {
        return var02.dispatch(NAME_TAG, var0 -> var0.owner, var12 -> {
            IBlockDataHolder var2 = (IBlockDataHolder)var1.apply(var12);
            if (var2.getValues().isEmpty()) {
                return Codec.unit((Object)var2);
            }
            return var2.propertiesCodec.codec().optionalFieldOf(PROPERTIES_TAG).xmap(var1 -> var1.orElse(var2), Optional::of).codec();
        });
    }
}

