/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Lists;
import com.mojang.math.PointGroupO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.SystemUtils;
import net.minecraft.core.EnumDirection;

public final class EnumBlockRotation
extends Enum<EnumBlockRotation> {
    public static final /* enum */ EnumBlockRotation NONE = new EnumBlockRotation(PointGroupO.IDENTITY);
    public static final /* enum */ EnumBlockRotation CLOCKWISE_90 = new EnumBlockRotation(PointGroupO.ROT_90_Y_NEG);
    public static final /* enum */ EnumBlockRotation CLOCKWISE_180 = new EnumBlockRotation(PointGroupO.ROT_180_FACE_XZ);
    public static final /* enum */ EnumBlockRotation COUNTERCLOCKWISE_90 = new EnumBlockRotation(PointGroupO.ROT_90_Y_POS);
    private final PointGroupO rotation;
    private static final /* synthetic */ EnumBlockRotation[] f;

    public static EnumBlockRotation[] values() {
        return (EnumBlockRotation[])f.clone();
    }

    public static EnumBlockRotation valueOf(String var0) {
        return Enum.valueOf(EnumBlockRotation.class, var0);
    }

    private EnumBlockRotation(PointGroupO var2) {
        this.rotation = var2;
    }

    public EnumBlockRotation getRotated(EnumBlockRotation var0) {
        switch (var0) {
            case CLOCKWISE_180: {
                switch (this) {
                    case NONE: {
                        return CLOCKWISE_180;
                    }
                    case CLOCKWISE_90: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case CLOCKWISE_180: {
                        return NONE;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return CLOCKWISE_90;
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (this) {
                    case NONE: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case CLOCKWISE_90: {
                        return NONE;
                    }
                    case CLOCKWISE_180: {
                        return CLOCKWISE_90;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return CLOCKWISE_180;
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (this) {
                    case NONE: {
                        return CLOCKWISE_90;
                    }
                    case CLOCKWISE_90: {
                        return CLOCKWISE_180;
                    }
                    case CLOCKWISE_180: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return NONE;
                    }
                }
            }
        }
        return this;
    }

    public PointGroupO rotation() {
        return this.rotation;
    }

    public EnumDirection rotate(EnumDirection var0) {
        if (var0.getAxis() == EnumDirection.EnumAxis.Y) {
            return var0;
        }
        switch (this) {
            case CLOCKWISE_180: {
                return var0.getOpposite();
            }
            case COUNTERCLOCKWISE_90: {
                return var0.getCounterClockWise();
            }
            case CLOCKWISE_90: {
                return var0.getClockWise();
            }
        }
        return var0;
    }

    public int rotate(int var0, int var1) {
        switch (this) {
            case CLOCKWISE_180: {
                return (var0 + var1 / 2) % var1;
            }
            case COUNTERCLOCKWISE_90: {
                return (var0 + var1 * 3 / 4) % var1;
            }
            case CLOCKWISE_90: {
                return (var0 + var1 / 4) % var1;
            }
        }
        return var0;
    }

    public static EnumBlockRotation getRandom(Random var0) {
        return SystemUtils.getRandom(EnumBlockRotation.values(), var0);
    }

    public static List<EnumBlockRotation> getShuffled(Random var0) {
        ArrayList var1 = Lists.newArrayList((Object[])EnumBlockRotation.values());
        Collections.shuffle(var1, var0);
        return var1;
    }

    private static /* synthetic */ EnumBlockRotation[] b() {
        return new EnumBlockRotation[]{NONE, CLOCKWISE_90, CLOCKWISE_180, COUNTERCLOCKWISE_90};
    }

    static {
        f = EnumBlockRotation.b();
    }
}

