/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFlowers;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockWitherRose
extends BlockFlowers {
    public BlockWitherRose(MobEffectList var0, BlockBase.Info var1) {
        super(var0, 8, var1);
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return super.mayPlaceOn(var0, var1, var2) || var0.is(Blocks.NETHERRACK) || var0.is(Blocks.SOUL_SAND) || var0.is(Blocks.SOUL_SOIL);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, Random var3) {
        VoxelShape var4 = this.getShape(var0, var1, var2, VoxelShapeCollision.empty());
        Vec3D var5 = var4.bounds().getCenter();
        double var6 = (double)var2.getX() + var5.x;
        double var8 = (double)var2.getZ() + var5.z;
        for (int var10 = 0; var10 < 3; ++var10) {
            if (!var3.nextBoolean()) continue;
            var1.addParticle(Particles.SMOKE, var6 + var3.nextDouble() / 5.0, (double)var2.getY() + (0.5 - var3.nextDouble()), var8 + var3.nextDouble() / 5.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        EntityLiving var4;
        if (var1.isClientSide || var1.getDifficulty() == EnumDifficulty.PEACEFUL) {
            return;
        }
        if (var3 instanceof EntityLiving && !(var4 = (EntityLiving)var3).isInvulnerableTo(DamageSource.WITHER)) {
            var4.addEffect(new MobEffect(MobEffects.WITHER, 40));
        }
    }
}

