/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockStemmed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockStemAttached
extends BlockPlant {
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    protected static final float AABB_OFFSET = 2.0f;
    private static final Map<EnumDirection, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.SOUTH, (Object)Block.box(6.0, 0.0, 6.0, 10.0, 10.0, 16.0), (Object)EnumDirection.WEST, (Object)Block.box(0.0, 0.0, 6.0, 10.0, 10.0, 10.0), (Object)EnumDirection.NORTH, (Object)Block.box(6.0, 0.0, 0.0, 10.0, 10.0, 10.0), (Object)EnumDirection.EAST, (Object)Block.box(6.0, 0.0, 6.0, 16.0, 10.0, 10.0)));
    private final BlockStemmed fruit;
    private final Supplier<Item> seedSupplier;

    protected BlockStemAttached(BlockStemmed var0, Supplier<Item> var1, BlockBase.Info var2) {
        super(var2);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH));
        this.fruit = var0;
        this.seedSupplier = var1;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return AABBS.get(var0.getValue(FACING));
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (!var2.is(this.fruit) && var1 == var0.getValue(FACING)) {
            return (IBlockData)this.fruit.getStem().defaultBlockState().setValue(BlockStem.AGE, 7);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.is(Blocks.FARMLAND);
    }

    @Override
    public ItemStack getCloneItemStack(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        return new ItemStack(this.seedSupplier.get());
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING);
    }
}

