/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockNote
extends Block {
    public static final BlockStateEnum<BlockPropertyInstrument> INSTRUMENT = BlockProperties.NOTEBLOCK_INSTRUMENT;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateInteger NOTE = BlockProperties.NOTE;

    public BlockNote(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(INSTRUMENT, BlockPropertyInstrument.HARP)).setValue(NOTE, 0)).setValue(POWERED, false));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(INSTRUMENT, BlockPropertyInstrument.byState(var0.getLevel().getBlockState(var0.getClickedPos().below())));
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.DOWN) {
            return (IBlockData)var0.setValue(INSTRUMENT, BlockPropertyInstrument.byState(var2));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        boolean var6 = var1.hasNeighborSignal(var2);
        if (var6 != var0.getValue(POWERED)) {
            if (var6) {
                this.playNote(var1, var2);
            }
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, var6), 3);
        }
    }

    private void playNote(World var0, BlockPosition var1) {
        if (var0.getBlockState(var1.above()).isAir()) {
            var0.blockEvent(var1, this, 0, 0);
        }
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        if (var1.isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        var0 = (IBlockData)var0.cycle(NOTE);
        var1.setBlock(var2, var0, 3);
        this.playNote(var1, var2);
        var3.awardStat(StatisticList.TUNE_NOTEBLOCK);
        return EnumInteractionResult.CONSUME;
    }

    @Override
    public void attack(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
        if (var1.isClientSide) {
            return;
        }
        this.playNote(var1, var2);
        var3.awardStat(StatisticList.PLAY_NOTEBLOCK);
    }

    @Override
    public boolean triggerEvent(IBlockData var0, World var1, BlockPosition var2, int var3, int var4) {
        int var5 = var0.getValue(NOTE);
        float var6 = (float)Math.pow(2.0, (double)(var5 - 12) / 12.0);
        var1.playSound(null, var2, var0.getValue(INSTRUMENT).getSoundEvent(), SoundCategory.RECORDS, 3.0f, var6);
        var1.addParticle(Particles.NOTE, (double)var2.getX() + 0.5, (double)var2.getY() + 1.2, (double)var2.getZ() + 0.5, (double)var5 / 24.0, 0.0, 0.0);
        return true;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(INSTRUMENT, POWERED, NOTE);
    }
}

