/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.MinecartTrackLogic;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class BlockMinecartTrack
extends BlockMinecartTrackAbstract {
    public static final BlockStateEnum<BlockPropertyTrackPosition> SHAPE = BlockProperties.RAIL_SHAPE;

    protected BlockMinecartTrack(BlockBase.Info var0) {
        super(false, var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(SHAPE, BlockPropertyTrackPosition.NORTH_SOUTH)).setValue(WATERLOGGED, false));
    }

    @Override
    protected void updateState(IBlockData var0, World var1, BlockPosition var2, Block var3) {
        if (var3.defaultBlockState().isSignalSource() && new MinecartTrackLogic(var1, var2, var0).countPotentialConnections() == 3) {
            this.updateDir(var1, var2, var0, false);
        }
    }

    @Override
    public IBlockState<BlockPropertyTrackPosition> getShapeProperty() {
        return SHAPE;
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case CLOCKWISE_180: {
                switch (var0.getValue(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (var0.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (var0.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                }
            }
        }
        return var0;
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        BlockPropertyTrackPosition var2 = var0.getValue(SHAPE);
        switch (var1) {
            case LEFT_RIGHT: {
                switch (var2) {
                    case ASCENDING_NORTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                }
                break;
            }
            case FRONT_BACK: {
                switch (var2) {
                    case ASCENDING_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                }
                break;
            }
        }
        return super.mirror(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(SHAPE, WATERLOGGED);
    }
}

