/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockHalfTransparent;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Material;

public class BlockIce
extends BlockHalfTransparent {
    public BlockIce(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public void playerDestroy(World var0, EntityHuman var1, BlockPosition var2, IBlockData var3, @Nullable TileEntity var4, ItemStack var5) {
        super.playerDestroy(var0, var1, var2, var3, var4, var5);
        if (EnchantmentManager.getItemEnchantmentLevel(Enchantments.SILK_TOUCH, var5) == 0) {
            if (var0.dimensionType().ultraWarm()) {
                var0.removeBlock(var2, false);
                return;
            }
            Material var6 = var0.getBlockState(var2.below()).getMaterial();
            if (var6.blocksMotion() || var6.isLiquid()) {
                var0.setBlockAndUpdate(var2, Blocks.WATER.defaultBlockState());
            }
        }
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, Random var3) {
        if (var1.getBrightness(EnumSkyBlock.BLOCK, var2) > 11 - var0.getLightBlock(var1, var2)) {
            this.melt(var0, var1, var2);
        }
    }

    protected void melt(IBlockData var0, World var1, BlockPosition var2) {
        if (var1.dimensionType().ultraWarm()) {
            var1.removeBlock(var2, false);
            return;
        }
        var1.setBlockAndUpdate(var2, Blocks.WATER.defaultBlockState());
        var1.neighborChanged(var2, Blocks.WATER, var2);
    }

    @Override
    public EnumPistonReaction getPistonPushReaction(IBlockData var0) {
        return EnumPistonReaction.NORMAL;
    }
}

