/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGrowingAbstract;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BlockGrowingTop
extends BlockGrowingAbstract
implements IBlockFragilePlantElement {
    public static final BlockStateInteger AGE = BlockProperties.AGE_25;
    public static final int MAX_AGE = 25;
    private final double growPerTickProbability;

    protected BlockGrowingTop(BlockBase.Info var0, EnumDirection var1, VoxelShape var2, boolean var3, double var4) {
        super(var0, var1, var2, var3);
        this.growPerTickProbability = var4;
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    public IBlockData getStateForPlacement(GeneratorAccess var0) {
        return (IBlockData)this.defaultBlockState().setValue(AGE, var0.getRandom().nextInt(25));
    }

    @Override
    public boolean isRandomlyTicking(IBlockData var0) {
        return var0.getValue(AGE) < 25;
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, Random var3) {
        BlockPosition var4;
        if (var0.getValue(AGE) < 25 && var3.nextDouble() < this.growPerTickProbability && this.canGrowInto(var1.getBlockState(var4 = var2.relative(this.growthDirection)))) {
            var1.setBlockAndUpdate(var4, this.getGrowIntoState(var0, var1.random));
        }
    }

    protected IBlockData getGrowIntoState(IBlockData var0, Random var1) {
        return (IBlockData)var0.cycle(AGE);
    }

    public IBlockData getMaxAgeState(IBlockData var0) {
        return (IBlockData)var0.setValue(AGE, 25);
    }

    public boolean isMaxAge(IBlockData var0) {
        return var0.getValue(AGE) == 25;
    }

    protected IBlockData updateBodyAfterConvertedFromHead(IBlockData var0, IBlockData var1) {
        return var1;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == this.growthDirection.getOpposite() && !var0.canSurvive(var3, var4)) {
            var3.scheduleTick(var4, this, 1);
        }
        if (var1 == this.growthDirection && (var2.is(this) || var2.is(this.getBodyBlock()))) {
            return this.updateBodyAfterConvertedFromHead(var0, this.getBodyBlock().defaultBlockState());
        }
        if (this.scheduleFluidTicks) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE);
    }

    @Override
    public boolean isValidBonemealTarget(IBlockAccess var0, BlockPosition var1, IBlockData var2, boolean var3) {
        return this.canGrowInto(var0.getBlockState(var1.relative(this.growthDirection)));
    }

    @Override
    public boolean isBonemealSuccess(World var0, Random var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, Random var1, BlockPosition var2, IBlockData var3) {
        BlockPosition var4 = var2.relative(this.growthDirection);
        int var5 = Math.min(var3.getValue(AGE) + 1, 25);
        int var6 = this.getBlocksToGrowWhenBonemealed(var1);
        for (int var7 = 0; var7 < var6 && this.canGrowInto(var0.getBlockState(var4)); ++var7) {
            var0.setBlockAndUpdate(var4, (IBlockData)var3.setValue(AGE, var5));
            var4 = var4.relative(this.growthDirection);
            var5 = Math.min(var5 + 1, 25);
        }
    }

    protected abstract int getBlocksToGrowWhenBonemealed(Random var1);

    protected abstract boolean canGrowInto(IBlockData var1);

    @Override
    protected BlockGrowingTop getHeadBlock() {
        return this;
    }
}

