/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.TileInventory;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChestAbstract;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockEnderChest
extends BlockChestAbstract<TileEntityEnderChest>
implements IBlockWaterlogged {
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    private static final IChatBaseComponent CONTAINER_TITLE = new ChatMessage("container.enderchest");

    protected BlockEnderChest(BlockBase.Info var0) {
        super(var0, () -> TileEntityTypes.ENDER_CHEST);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(WATERLOGGED, false));
    }

    @Override
    public DoubleBlockFinder.Result<? extends TileEntityChest> combine(IBlockData var0, World var1, BlockPosition var2, boolean var3) {
        return DoubleBlockFinder.Combiner::acceptNone;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getOpposite())).setValue(WATERLOGGED, var1.getType() == FluidTypes.WATER);
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var12, BlockPosition var22, EntityHuman var32, EnumHand var4, MovingObjectPositionBlock var5) {
        InventoryEnderChest var6 = var32.getEnderChestInventory();
        TileEntity var7 = var12.getBlockEntity(var22);
        if (var6 == null || !(var7 instanceof TileEntityEnderChest)) {
            return EnumInteractionResult.sidedSuccess(var12.isClientSide);
        }
        BlockPosition var8 = var22.above();
        if (var12.getBlockState(var8).isRedstoneConductor(var12, var8)) {
            return EnumInteractionResult.sidedSuccess(var12.isClientSide);
        }
        if (var12.isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        TileEntityEnderChest var9 = (TileEntityEnderChest)var7;
        var6.setActiveChest(var9);
        var32.openMenu(new TileInventory((var1, var2, var3) -> ContainerChest.threeRows(var1, var2, var6), CONTAINER_TITLE));
        var32.awardStat(StatisticList.OPEN_ENDERCHEST);
        PiglinAI.angerNearbyPiglins(var32, true);
        return EnumInteractionResult.CONSUME;
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityEnderChest(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return var0.isClientSide ? BlockEnderChest.createTickerHelper(var2, TileEntityTypes.ENDER_CHEST, TileEntityEnderChest::lidAnimateTick) : null;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, Random var3) {
        for (int var4 = 0; var4 < 3; ++var4) {
            int var5 = var3.nextInt(2) * 2 - 1;
            int var6 = var3.nextInt(2) * 2 - 1;
            double var7 = (double)var2.getX() + 0.5 + 0.25 * (double)var5;
            double var9 = (float)var2.getY() + var3.nextFloat();
            double var11 = (double)var2.getZ() + 0.5 + 0.25 * (double)var6;
            double var13 = var3.nextFloat() * (float)var5;
            double var15 = ((double)var3.nextFloat() - 0.5) * 0.125;
            double var17 = var3.nextFloat() * (float)var6;
            var1.addParticle(Particles.PORTAL, var7, var9, var11, var13, var15, var17);
        }
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, WATERLOGGED);
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, Random var3) {
        TileEntity var4 = var1.getBlockEntity(var2);
        if (var4 instanceof TileEntityEnderChest) {
            ((TileEntityEnderChest)var4).recheckOpen();
        }
    }
}

