/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockCactus
extends Block {
    public static final BlockStateInteger AGE = BlockProperties.AGE_15;
    public static final int MAX_AGE = 15;
    protected static final int AABB_OFFSET = 1;
    protected static final VoxelShape COLLISION_SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 15.0, 15.0);
    protected static final VoxelShape OUTLINE_SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    protected BlockCactus(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, Random var3) {
        if (!var0.canSurvive(var1, var2)) {
            var1.destroyBlock(var2, true);
        }
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, Random var3) {
        BlockPosition var4 = var2.above();
        if (!var1.isEmptyBlock(var4)) {
            return;
        }
        int var5 = 1;
        while (var1.getBlockState(var2.below(var5)).is(this)) {
            ++var5;
        }
        if (var5 >= 3) {
            return;
        }
        int var6 = var0.getValue(AGE);
        if (var6 == 15) {
            var1.setBlockAndUpdate(var4, this.defaultBlockState());
            IBlockData var7 = (IBlockData)var0.setValue(AGE, 0);
            var1.setBlock(var2, var7, 4);
            var7.neighborChanged(var1, var4, this, var2, false);
        } else {
            var1.setBlock(var2, (IBlockData)var0.setValue(AGE, var6 + 1), 4);
        }
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return COLLISION_SHAPE;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return OUTLINE_SHAPE;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (!var0.canSurvive(var3, var4)) {
            var3.scheduleTick(var4, this, 1);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        for (EnumDirection var4 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            IBlockData var5 = var1.getBlockState(var2.relative(var4));
            Material var6 = var5.getMaterial();
            if (!var6.isSolid() && !var1.getFluidState(var2.relative(var4)).is(TagsFluid.LAVA)) continue;
            return false;
        }
        IBlockData var3 = var1.getBlockState(var2.below());
        return (var3.is(Blocks.CACTUS) || var3.is(Blocks.SAND) || var3.is(Blocks.RED_SAND)) && !var1.getBlockState(var2.above()).getMaterial().isLiquid();
    }

    @Override
    public void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        var3.hurt(DamageSource.CACTUS, 1.0f);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }
}

