/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBell;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBellAttach;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockBell
extends BlockTileEntity {
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateEnum<BlockPropertyBellAttach> ATTACHMENT = BlockProperties.BELL_ATTACHMENT;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    private static final VoxelShape NORTH_SOUTH_FLOOR_SHAPE = Block.box(0.0, 0.0, 4.0, 16.0, 16.0, 12.0);
    private static final VoxelShape EAST_WEST_FLOOR_SHAPE = Block.box(4.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    private static final VoxelShape BELL_TOP_SHAPE = Block.box(5.0, 6.0, 5.0, 11.0, 13.0, 11.0);
    private static final VoxelShape BELL_BOTTOM_SHAPE = Block.box(4.0, 4.0, 4.0, 12.0, 6.0, 12.0);
    private static final VoxelShape BELL_SHAPE = VoxelShapes.or(BELL_BOTTOM_SHAPE, BELL_TOP_SHAPE);
    private static final VoxelShape NORTH_SOUTH_BETWEEN = VoxelShapes.or(BELL_SHAPE, Block.box(7.0, 13.0, 0.0, 9.0, 15.0, 16.0));
    private static final VoxelShape EAST_WEST_BETWEEN = VoxelShapes.or(BELL_SHAPE, Block.box(0.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape TO_WEST = VoxelShapes.or(BELL_SHAPE, Block.box(0.0, 13.0, 7.0, 13.0, 15.0, 9.0));
    private static final VoxelShape TO_EAST = VoxelShapes.or(BELL_SHAPE, Block.box(3.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape TO_NORTH = VoxelShapes.or(BELL_SHAPE, Block.box(7.0, 13.0, 0.0, 9.0, 15.0, 13.0));
    private static final VoxelShape TO_SOUTH = VoxelShapes.or(BELL_SHAPE, Block.box(7.0, 13.0, 3.0, 9.0, 15.0, 16.0));
    private static final VoxelShape CEILING_SHAPE = VoxelShapes.or(BELL_SHAPE, Block.box(7.0, 13.0, 7.0, 9.0, 16.0, 9.0));
    public static final int EVENT_BELL_RING = 1;

    public BlockBell(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(ATTACHMENT, BlockPropertyBellAttach.FLOOR)).setValue(POWERED, false));
    }

    @Override
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        boolean var6 = var1.hasNeighborSignal(var2);
        if (var6 != var0.getValue(POWERED)) {
            if (var6) {
                this.attemptToRing(var1, var2, null);
            }
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, var6), 3);
        }
    }

    @Override
    public void onProjectileHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, IProjectile var3) {
        Entity var4 = var3.getOwner();
        EntityHuman var5 = var4 instanceof EntityHuman ? (EntityHuman)var4 : null;
        this.onHit(var0, var1, var2, var5, true);
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        return this.onHit(var1, var0, var5, var3, true) ? EnumInteractionResult.sidedSuccess(var1.isClientSide) : EnumInteractionResult.PASS;
    }

    public boolean onHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, @Nullable EntityHuman var3, boolean var4) {
        boolean var7;
        EnumDirection var5 = var2.getDirection();
        BlockPosition var6 = var2.getBlockPos();
        boolean bl = var7 = !var4 || this.isProperHit(var1, var5, var2.getLocation().y - (double)var6.getY());
        if (var7) {
            boolean var8 = this.attemptToRing(var3, var0, var6, var5);
            if (var8 && var3 != null) {
                var3.awardStat(StatisticList.BELL_RING);
            }
            return true;
        }
        return false;
    }

    private boolean isProperHit(IBlockData var0, EnumDirection var1, double var2) {
        if (var1.getAxis() == EnumDirection.EnumAxis.Y || var2 > (double)0.8124f) {
            return false;
        }
        EnumDirection var4 = var0.getValue(FACING);
        BlockPropertyBellAttach var5 = var0.getValue(ATTACHMENT);
        switch (var5) {
            case FLOOR: {
                return var4.getAxis() == var1.getAxis();
            }
            case SINGLE_WALL: 
            case DOUBLE_WALL: {
                return var4.getAxis() != var1.getAxis();
            }
            case CEILING: {
                return true;
            }
        }
        return false;
    }

    public boolean attemptToRing(World var0, BlockPosition var1, @Nullable EnumDirection var2) {
        return this.attemptToRing(null, var0, var1, var2);
    }

    public boolean attemptToRing(@Nullable Entity var0, World var1, BlockPosition var2, @Nullable EnumDirection var3) {
        TileEntity var4 = var1.getBlockEntity(var2);
        if (!var1.isClientSide && var4 instanceof TileEntityBell) {
            if (var3 == null) {
                var3 = var1.getBlockState(var2).getValue(FACING);
            }
            ((TileEntityBell)var4).onHit(var3);
            var1.playSound(null, var2, SoundEffects.BELL_BLOCK, SoundCategory.BLOCKS, 2.0f, 1.0f);
            var1.gameEvent(var0, GameEvent.RING_BELL, var2);
            return true;
        }
        return false;
    }

    private VoxelShape getVoxelShape(IBlockData var0) {
        EnumDirection var1 = var0.getValue(FACING);
        BlockPropertyBellAttach var2 = var0.getValue(ATTACHMENT);
        if (var2 == BlockPropertyBellAttach.FLOOR) {
            if (var1 == EnumDirection.NORTH || var1 == EnumDirection.SOUTH) {
                return NORTH_SOUTH_FLOOR_SHAPE;
            }
            return EAST_WEST_FLOOR_SHAPE;
        }
        if (var2 == BlockPropertyBellAttach.CEILING) {
            return CEILING_SHAPE;
        }
        if (var2 == BlockPropertyBellAttach.DOUBLE_WALL) {
            if (var1 == EnumDirection.NORTH || var1 == EnumDirection.SOUTH) {
                return NORTH_SOUTH_BETWEEN;
            }
            return EAST_WEST_BETWEEN;
        }
        if (var1 == EnumDirection.NORTH) {
            return TO_NORTH;
        }
        if (var1 == EnumDirection.SOUTH) {
            return TO_SOUTH;
        }
        if (var1 == EnumDirection.EAST) {
            return TO_EAST;
        }
        return TO_WEST;
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.getVoxelShape(var0);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.getVoxelShape(var0);
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection var2 = var0.getClickedFace();
        BlockPosition var3 = var0.getClickedPos();
        World var4 = var0.getLevel();
        EnumDirection.EnumAxis var5 = var2.getAxis();
        if (var5 == EnumDirection.EnumAxis.Y) {
            IBlockData var1 = (IBlockData)((IBlockData)this.defaultBlockState().setValue(ATTACHMENT, var2 == EnumDirection.DOWN ? BlockPropertyBellAttach.CEILING : BlockPropertyBellAttach.FLOOR)).setValue(FACING, var0.getHorizontalDirection());
            if (var1.canSurvive(var0.getLevel(), var3)) {
                return var1;
            }
        } else {
            boolean var6 = var5 == EnumDirection.EnumAxis.X && var4.getBlockState(var3.west()).isFaceSturdy(var4, var3.west(), EnumDirection.EAST) && var4.getBlockState(var3.east()).isFaceSturdy(var4, var3.east(), EnumDirection.WEST) || var5 == EnumDirection.EnumAxis.Z && var4.getBlockState(var3.north()).isFaceSturdy(var4, var3.north(), EnumDirection.SOUTH) && var4.getBlockState(var3.south()).isFaceSturdy(var4, var3.south(), EnumDirection.NORTH);
            IBlockData var1 = (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var2.getOpposite())).setValue(ATTACHMENT, var6 ? BlockPropertyBellAttach.DOUBLE_WALL : BlockPropertyBellAttach.SINGLE_WALL);
            if (var1.canSurvive(var0.getLevel(), var0.getClickedPos())) {
                return var1;
            }
            boolean var7 = var4.getBlockState(var3.below()).isFaceSturdy(var4, var3.below(), EnumDirection.UP);
            if ((var1 = (IBlockData)var1.setValue(ATTACHMENT, var7 ? BlockPropertyBellAttach.FLOOR : BlockPropertyBellAttach.CEILING)).canSurvive(var0.getLevel(), var0.getClickedPos())) {
                return var1;
            }
        }
        return null;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        BlockPropertyBellAttach var6 = var0.getValue(ATTACHMENT);
        EnumDirection var7 = BlockBell.getConnectedDirection(var0).getOpposite();
        if (var7 == var1 && !var0.canSurvive(var3, var4) && var6 != BlockPropertyBellAttach.DOUBLE_WALL) {
            return Blocks.AIR.defaultBlockState();
        }
        if (var1.getAxis() == var0.getValue(FACING).getAxis()) {
            if (var6 == BlockPropertyBellAttach.DOUBLE_WALL && !var2.isFaceSturdy(var3, var5, var1)) {
                return (IBlockData)((IBlockData)var0.setValue(ATTACHMENT, BlockPropertyBellAttach.SINGLE_WALL)).setValue(FACING, var1.getOpposite());
            }
            if (var6 == BlockPropertyBellAttach.SINGLE_WALL && var7.getOpposite() == var1 && var2.isFaceSturdy(var3, var5, var0.getValue(FACING))) {
                return (IBlockData)var0.setValue(ATTACHMENT, BlockPropertyBellAttach.DOUBLE_WALL);
            }
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        EnumDirection var3 = BlockBell.getConnectedDirection(var0).getOpposite();
        if (var3 == EnumDirection.UP) {
            return Block.canSupportCenter(var1, var2.above(), EnumDirection.DOWN);
        }
        return BlockAttachable.canAttach(var1, var2, var3);
    }

    private static EnumDirection getConnectedDirection(IBlockData var0) {
        switch (var0.getValue(ATTACHMENT)) {
            case CEILING: {
                return EnumDirection.DOWN;
            }
            case FLOOR: {
                return EnumDirection.UP;
            }
        }
        return var0.getValue(FACING).getOpposite();
    }

    @Override
    public EnumPistonReaction getPistonPushReaction(IBlockData var0) {
        return EnumPistonReaction.DESTROY;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, ATTACHMENT, POWERED);
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityBell(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return BlockBell.createTickerHelper(var2, TileEntityTypes.BELL, var0.isClientSide ? TileEntityBell::clientTick : TileEntityBell::serverTick);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }
}

