/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBed;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBedPart;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.ArrayUtils;

public class BlockBed
extends BlockFacingHorizontal
implements ITileEntity {
    public static final BlockStateEnum<BlockPropertyBedPart> PART = BlockProperties.BED_PART;
    public static final BlockStateBoolean OCCUPIED = BlockProperties.OCCUPIED;
    protected static final int HEIGHT = 9;
    protected static final VoxelShape BASE = Block.box(0.0, 3.0, 0.0, 16.0, 9.0, 16.0);
    private static final int LEG_WIDTH = 3;
    protected static final VoxelShape LEG_NORTH_WEST = Block.box(0.0, 0.0, 0.0, 3.0, 3.0, 3.0);
    protected static final VoxelShape LEG_SOUTH_WEST = Block.box(0.0, 0.0, 13.0, 3.0, 3.0, 16.0);
    protected static final VoxelShape LEG_NORTH_EAST = Block.box(13.0, 0.0, 0.0, 16.0, 3.0, 3.0);
    protected static final VoxelShape LEG_SOUTH_EAST = Block.box(13.0, 0.0, 13.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape NORTH_SHAPE = VoxelShapes.or(BASE, LEG_NORTH_WEST, LEG_NORTH_EAST);
    protected static final VoxelShape SOUTH_SHAPE = VoxelShapes.or(BASE, LEG_SOUTH_WEST, LEG_SOUTH_EAST);
    protected static final VoxelShape WEST_SHAPE = VoxelShapes.or(BASE, LEG_NORTH_WEST, LEG_SOUTH_WEST);
    protected static final VoxelShape EAST_SHAPE = VoxelShapes.or(BASE, LEG_NORTH_EAST, LEG_SOUTH_EAST);
    private final EnumColor color;

    public BlockBed(EnumColor var0, BlockBase.Info var1) {
        super(var1);
        this.color = var0;
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(PART, BlockPropertyBedPart.FOOT)).setValue(OCCUPIED, false));
    }

    @Nullable
    public static EnumDirection getBedOrientation(IBlockAccess var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        return var2.getBlock() instanceof BlockBed ? var2.getValue(FACING) : null;
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var12, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        if (var12.isClientSide) {
            return EnumInteractionResult.CONSUME;
        }
        if (var0.getValue(PART) != BlockPropertyBedPart.HEAD && !(var0 = var12.getBlockState(var2 = var2.relative(var0.getValue(FACING)))).is(this)) {
            return EnumInteractionResult.CONSUME;
        }
        if (!BlockBed.canSetSpawn(var12)) {
            var12.removeBlock(var2, false);
            BlockPosition var6 = var2.relative(var0.getValue(FACING).getOpposite());
            if (var12.getBlockState(var6).is(this)) {
                var12.removeBlock(var6, false);
            }
            var12.explode(null, DamageSource.badRespawnPointExplosion(), null, (double)var2.getX() + 0.5, (double)var2.getY() + 0.5, (double)var2.getZ() + 0.5, 5.0f, true, Explosion.Effect.DESTROY);
            return EnumInteractionResult.SUCCESS;
        }
        if (var0.getValue(OCCUPIED).booleanValue()) {
            if (!this.kickVillagerOutOfBed(var12, var2)) {
                var3.displayClientMessage(new ChatMessage("block.minecraft.bed.occupied"), true);
            }
            return EnumInteractionResult.SUCCESS;
        }
        var3.startSleepInBed(var2).ifLeft(var1 -> {
            if (var1 != null) {
                var3.displayClientMessage(var1.getMessage(), true);
            }
        });
        return EnumInteractionResult.SUCCESS;
    }

    public static boolean canSetSpawn(World var0) {
        return var0.dimensionType().bedWorks();
    }

    private boolean kickVillagerOutOfBed(World var0, BlockPosition var1) {
        List<EntityVillager> var2 = var0.getEntitiesOfClass(EntityVillager.class, new AxisAlignedBB(var1), EntityLiving::isSleeping);
        if (var2.isEmpty()) {
            return false;
        }
        var2.get(0).stopSleeping();
        return true;
    }

    @Override
    public void fallOn(World var0, IBlockData var1, BlockPosition var2, Entity var3, float var4) {
        super.fallOn(var0, var1, var2, var3, var4 * 0.5f);
    }

    @Override
    public void updateEntityAfterFallOn(IBlockAccess var0, Entity var1) {
        if (var1.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(var0, var1);
        } else {
            this.bounceUp(var1);
        }
    }

    private void bounceUp(Entity var0) {
        Vec3D var1 = var0.getDeltaMovement();
        if (var1.y < 0.0) {
            double var2 = var0 instanceof EntityLiving ? 1.0 : 0.8;
            var0.setDeltaMovement(var1.x, -var1.y * (double)0.66f * var2, var1.z);
        }
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == BlockBed.getNeighbourDirection(var0.getValue(PART), var0.getValue(FACING))) {
            if (var2.is(this) && var2.getValue(PART) != var0.getValue(PART)) {
                return (IBlockData)var0.setValue(OCCUPIED, var2.getValue(OCCUPIED));
            }
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    private static EnumDirection getNeighbourDirection(BlockPropertyBedPart var0, EnumDirection var1) {
        return var0 == BlockPropertyBedPart.FOOT ? var1 : var1.getOpposite();
    }

    @Override
    public void playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        BlockPosition var5;
        IBlockData var6;
        BlockPropertyBedPart var4;
        if (!var0.isClientSide && var3.isCreative() && (var4 = var2.getValue(PART)) == BlockPropertyBedPart.FOOT && (var6 = var0.getBlockState(var5 = var1.relative(BlockBed.getNeighbourDirection(var4, var2.getValue(FACING))))).is(this) && var6.getValue(PART) == BlockPropertyBedPart.HEAD) {
            var0.setBlock(var5, Blocks.AIR.defaultBlockState(), 35);
            var0.levelEvent(var3, 2001, var5, Block.getId(var6));
        }
        super.playerWillDestroy(var0, var1, var2, var3);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection var1 = var0.getHorizontalDirection();
        BlockPosition var2 = var0.getClickedPos();
        BlockPosition var3 = var2.relative(var1);
        World var4 = var0.getLevel();
        if (var4.getBlockState(var3).canBeReplaced(var0) && var4.getWorldBorder().isWithinBounds(var3)) {
            return (IBlockData)this.defaultBlockState().setValue(FACING, var1);
        }
        return null;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        EnumDirection var4 = BlockBed.getConnectedDirection(var0).getOpposite();
        switch (var4) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    public static EnumDirection getConnectedDirection(IBlockData var0) {
        EnumDirection var1 = var0.getValue(FACING);
        return var0.getValue(PART) == BlockPropertyBedPart.HEAD ? var1.getOpposite() : var1;
    }

    public static DoubleBlockFinder.BlockType getBlockType(IBlockData var0) {
        BlockPropertyBedPart var1 = var0.getValue(PART);
        if (var1 == BlockPropertyBedPart.HEAD) {
            return DoubleBlockFinder.BlockType.FIRST;
        }
        return DoubleBlockFinder.BlockType.SECOND;
    }

    private static boolean isBunkBed(IBlockAccess var0, BlockPosition var1) {
        return var0.getBlockState(var1.below()).getBlock() instanceof BlockBed;
    }

    public static Optional<Vec3D> findStandUpPosition(EntityTypes<?> var0, ICollisionAccess var1, BlockPosition var2, float var3) {
        EnumDirection var6;
        EnumDirection var4 = var1.getBlockState(var2).getValue(FACING);
        EnumDirection var5 = var4.getClockWise();
        EnumDirection enumDirection = var6 = var5.isFacingAngle(var3) ? var5.getOpposite() : var5;
        if (BlockBed.isBunkBed(var1, var2)) {
            return BlockBed.findBunkBedStandUpPosition(var0, var1, var2, var4, var6);
        }
        int[][] var7 = BlockBed.bedStandUpOffsets(var4, var6);
        Optional<Vec3D> var8 = BlockBed.findStandUpPositionAtOffset(var0, var1, var2, var7, true);
        if (var8.isPresent()) {
            return var8;
        }
        return BlockBed.findStandUpPositionAtOffset(var0, var1, var2, var7, false);
    }

    private static Optional<Vec3D> findBunkBedStandUpPosition(EntityTypes<?> var0, ICollisionAccess var1, BlockPosition var2, EnumDirection var3, EnumDirection var4) {
        int[][] var5 = BlockBed.bedSurroundStandUpOffsets(var3, var4);
        Optional<Vec3D> var6 = BlockBed.findStandUpPositionAtOffset(var0, var1, var2, var5, true);
        if (var6.isPresent()) {
            return var6;
        }
        BlockPosition var7 = var2.below();
        Optional<Vec3D> var8 = BlockBed.findStandUpPositionAtOffset(var0, var1, var7, var5, true);
        if (var8.isPresent()) {
            return var8;
        }
        int[][] var9 = BlockBed.bedAboveStandUpOffsets(var3);
        Optional<Vec3D> var10 = BlockBed.findStandUpPositionAtOffset(var0, var1, var2, var9, true);
        if (var10.isPresent()) {
            return var10;
        }
        Optional<Vec3D> var11 = BlockBed.findStandUpPositionAtOffset(var0, var1, var2, var5, false);
        if (var11.isPresent()) {
            return var11;
        }
        Optional<Vec3D> var12 = BlockBed.findStandUpPositionAtOffset(var0, var1, var7, var5, false);
        if (var12.isPresent()) {
            return var12;
        }
        return BlockBed.findStandUpPositionAtOffset(var0, var1, var2, var9, false);
    }

    private static Optional<Vec3D> findStandUpPositionAtOffset(EntityTypes<?> var0, ICollisionAccess var1, BlockPosition var2, int[][] var3, boolean var4) {
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
        for (int[] var9 : var3) {
            var5.set(var2.getX() + var9[0], var2.getY(), var2.getZ() + var9[1]);
            Vec3D var10 = DismountUtil.findSafeDismountLocation(var0, var1, var5, var4);
            if (var10 == null) continue;
            return Optional.of(var10);
        }
        return Optional.empty();
    }

    @Override
    public EnumPistonReaction getPistonPushReaction(IBlockData var0) {
        return EnumPistonReaction.DESTROY;
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, PART, OCCUPIED);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityBed(var0, var1, this.color);
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        super.setPlacedBy(var0, var1, var2, var3, var4);
        if (!var0.isClientSide) {
            BlockPosition var5 = var1.relative(var2.getValue(FACING));
            var0.setBlock(var5, (IBlockData)var2.setValue(PART, BlockPropertyBedPart.HEAD), 3);
            var0.blockUpdated(var1, Blocks.AIR);
            var2.updateNeighbourShapes(var0, var1, 3);
        }
    }

    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public long getSeed(IBlockData var0, BlockPosition var1) {
        BlockPosition var2 = var1.relative(var0.getValue(FACING), var0.getValue(PART) == BlockPropertyBedPart.HEAD ? 0 : 1);
        return MathHelper.getSeed(var2.getX(), var1.getY(), var2.getZ());
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }

    private static int[][] bedStandUpOffsets(EnumDirection var0, EnumDirection var1) {
        return (int[][])ArrayUtils.addAll((Object[])BlockBed.bedSurroundStandUpOffsets(var0, var1), (Object[])BlockBed.bedAboveStandUpOffsets(var0));
    }

    private static int[][] bedSurroundStandUpOffsets(EnumDirection var0, EnumDirection var1) {
        return new int[][]{{var1.getStepX(), var1.getStepZ()}, {var1.getStepX() - var0.getStepX(), var1.getStepZ() - var0.getStepZ()}, {var1.getStepX() - var0.getStepX() * 2, var1.getStepZ() - var0.getStepZ() * 2}, {-var0.getStepX() * 2, -var0.getStepZ() * 2}, {-var1.getStepX() - var0.getStepX() * 2, -var1.getStepZ() - var0.getStepZ() * 2}, {-var1.getStepX() - var0.getStepX(), -var1.getStepZ() - var0.getStepZ()}, {-var1.getStepX(), -var1.getStepZ()}, {-var1.getStepX() + var0.getStepX(), -var1.getStepZ() + var0.getStepZ()}, {var0.getStepX(), var0.getStepZ()}, {var1.getStepX() + var0.getStepX(), var1.getStepZ() + var0.getStepZ()}};
    }

    private static int[][] bedAboveStandUpOffsets(EnumDirection var0) {
        return new int[][]{{0, 0}, {-var0.getStepX(), -var0.getStepZ()}};
    }
}

