/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.Tilt;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BigDripleafBlock
extends BlockFacingHorizontal
implements IBlockFragilePlantElement,
IBlockWaterlogged {
    private static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private static final BlockStateEnum<Tilt> TILT = BlockProperties.TILT;
    private static final int NO_TICK = -1;
    private static final Object2IntMap<Tilt> DELAY_UNTIL_NEXT_TILT_STATE = (Object2IntMap)SystemUtils.make(new Object2IntArrayMap(), var0 -> {
        var0.defaultReturnValue(-1);
        var0.put((Object)Tilt.UNSTABLE, 10);
        var0.put((Object)Tilt.PARTIAL, 10);
        var0.put((Object)Tilt.FULL, 100);
    });
    private static final int MAX_GEN_HEIGHT = 5;
    private static final int STEM_WIDTH = 6;
    private static final int ENTITY_DETECTION_MIN_Y = 11;
    private static final int LOWEST_LEAF_TOP = 13;
    private static final Map<Tilt, VoxelShape> LEAF_SHAPES = ImmutableMap.of((Object)Tilt.NONE, (Object)Block.box(0.0, 11.0, 0.0, 16.0, 15.0, 16.0), (Object)Tilt.UNSTABLE, (Object)Block.box(0.0, 11.0, 0.0, 16.0, 15.0, 16.0), (Object)Tilt.PARTIAL, (Object)Block.box(0.0, 11.0, 0.0, 16.0, 13.0, 16.0), (Object)Tilt.FULL, (Object)VoxelShapes.empty());
    private static final VoxelShape STEM_SLICER = Block.box(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);
    private static final Map<EnumDirection, VoxelShape> STEM_SHAPES = ImmutableMap.of((Object)EnumDirection.NORTH, (Object)VoxelShapes.joinUnoptimized(BigDripleafStemBlock.NORTH_SHAPE, STEM_SLICER, OperatorBoolean.ONLY_FIRST), (Object)EnumDirection.SOUTH, (Object)VoxelShapes.joinUnoptimized(BigDripleafStemBlock.SOUTH_SHAPE, STEM_SLICER, OperatorBoolean.ONLY_FIRST), (Object)EnumDirection.EAST, (Object)VoxelShapes.joinUnoptimized(BigDripleafStemBlock.EAST_SHAPE, STEM_SLICER, OperatorBoolean.ONLY_FIRST), (Object)EnumDirection.WEST, (Object)VoxelShapes.joinUnoptimized(BigDripleafStemBlock.WEST_SHAPE, STEM_SLICER, OperatorBoolean.ONLY_FIRST));
    private final Map<IBlockData, VoxelShape> shapesCache;

    protected BigDripleafBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(WATERLOGGED, false)).setValue(FACING, EnumDirection.NORTH)).setValue(TILT, Tilt.NONE));
        this.shapesCache = this.getShapeForEachState(BigDripleafBlock::calculateShape);
    }

    private static VoxelShape calculateShape(IBlockData var0) {
        return VoxelShapes.or(LEAF_SHAPES.get(var0.getValue(TILT)), STEM_SHAPES.get(var0.getValue(FACING)));
    }

    public static void placeWithRandomHeight(GeneratorAccess var0, Random var1, BlockPosition var2, EnumDirection var3) {
        int var6;
        int var4 = MathHelper.nextInt(var1, 2, 5);
        BlockPosition.MutableBlockPosition var5 = var2.mutable();
        for (var6 = 0; var6 < var4 && BigDripleafBlock.canPlaceAt(var0, var5, var0.getBlockState(var5)); ++var6) {
            var5.move(EnumDirection.UP);
        }
        int var7 = var2.getY() + var6 - 1;
        var5.setY(var2.getY());
        while (var5.getY() < var7) {
            BigDripleafStemBlock.place(var0, var5, var0.getFluidState(var5), var3);
            var5.move(EnumDirection.UP);
        }
        BigDripleafBlock.place(var0, var5, var0.getFluidState(var5), var3);
    }

    private static boolean canReplace(IBlockData var0) {
        return var0.isAir() || var0.is(Blocks.WATER) || var0.is(Blocks.SMALL_DRIPLEAF);
    }

    protected static boolean canPlaceAt(LevelHeightAccessor var0, BlockPosition var1, IBlockData var2) {
        return !var0.isOutsideBuildHeight(var1) && BigDripleafBlock.canReplace(var2);
    }

    protected static boolean place(GeneratorAccess var0, BlockPosition var1, Fluid var2, EnumDirection var3) {
        IBlockData var4 = (IBlockData)((IBlockData)Blocks.BIG_DRIPLEAF.defaultBlockState().setValue(WATERLOGGED, var2.isSourceOfType(FluidTypes.WATER))).setValue(FACING, var3);
        return var0.setBlock(var1, var4, 3);
    }

    @Override
    public void onProjectileHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, IProjectile var3) {
        this.setTiltAndScheduleTick(var1, var0, var2.getBlockPos(), Tilt.FULL, SoundEffects.BIG_DRIPLEAF_TILT_DOWN);
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.below();
        IBlockData var4 = var1.getBlockState(var3);
        return var4.is(this) || var4.is(Blocks.BIG_DRIPLEAF_STEM) || var4.is(TagsBlock.BIG_DRIPLEAF_PLACEABLE);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.DOWN && !var0.canSurvive(var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        if (var1 == EnumDirection.UP && var2.is(this)) {
            return Blocks.BIG_DRIPLEAF_STEM.withPropertiesOf(var0);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean isValidBonemealTarget(IBlockAccess var0, BlockPosition var1, IBlockData var2, boolean var3) {
        IBlockData var4 = var0.getBlockState(var1.above());
        return BigDripleafBlock.canReplace(var4);
    }

    @Override
    public boolean isBonemealSuccess(World var0, Random var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, Random var1, BlockPosition var2, IBlockData var3) {
        IBlockData var5;
        BlockPosition var4 = var2.above();
        if (BigDripleafBlock.canPlaceAt(var0, var4, var5 = var0.getBlockState(var4))) {
            EnumDirection var6 = var3.getValue(FACING);
            BigDripleafStemBlock.place(var0, var2, var3.getFluidState(), var6);
            BigDripleafBlock.place(var0, var4, var5.getFluidState(), var6);
        }
    }

    @Override
    public void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (var1.isClientSide) {
            return;
        }
        if (var0.getValue(TILT) == Tilt.NONE && BigDripleafBlock.canEntityTilt(var2, var3) && !var1.hasNeighborSignal(var2)) {
            this.setTiltAndScheduleTick(var0, var1, var2, Tilt.UNSTABLE, null);
        }
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, Random var3) {
        if (var1.hasNeighborSignal(var2)) {
            BigDripleafBlock.resetTilt(var0, var1, var2);
            return;
        }
        Tilt var4 = var0.getValue(TILT);
        if (var4 == Tilt.UNSTABLE) {
            this.setTiltAndScheduleTick(var0, var1, var2, Tilt.PARTIAL, SoundEffects.BIG_DRIPLEAF_TILT_DOWN);
        } else if (var4 == Tilt.PARTIAL) {
            this.setTiltAndScheduleTick(var0, var1, var2, Tilt.FULL, SoundEffects.BIG_DRIPLEAF_TILT_DOWN);
        } else if (var4 == Tilt.FULL) {
            BigDripleafBlock.resetTilt(var0, var1, var2);
        }
    }

    @Override
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        if (var1.hasNeighborSignal(var2)) {
            BigDripleafBlock.resetTilt(var0, var1, var2);
        }
    }

    private static void playTiltSound(World var0, BlockPosition var1, SoundEffect var2) {
        float var3 = MathHelper.randomBetween(var0.random, 0.8f, 1.2f);
        var0.playSound(null, var1, var2, SoundCategory.BLOCKS, 1.0f, var3);
    }

    private static boolean canEntityTilt(BlockPosition var0, Entity var1) {
        return var1.isOnGround() && var1.position().y > (double)((float)var0.getY() + 0.6875f);
    }

    private void setTiltAndScheduleTick(IBlockData var0, World var1, BlockPosition var2, Tilt var3, @Nullable SoundEffect var4) {
        int var5;
        BigDripleafBlock.setTilt(var0, var1, var2, var3);
        if (var4 != null) {
            BigDripleafBlock.playTiltSound(var1, var2, var4);
        }
        if ((var5 = DELAY_UNTIL_NEXT_TILT_STATE.getInt((Object)var3)) != -1) {
            var1.scheduleTick(var2, this, var5);
        }
    }

    private static void resetTilt(IBlockData var0, World var1, BlockPosition var2) {
        BigDripleafBlock.setTilt(var0, var1, var2, Tilt.NONE);
        if (var0.getValue(TILT) != Tilt.NONE) {
            BigDripleafBlock.playTiltSound(var1, var2, SoundEffects.BIG_DRIPLEAF_TILT_UP);
        }
    }

    private static void setTilt(IBlockData var0, World var1, BlockPosition var2, Tilt var3) {
        var1.setBlock(var2, (IBlockData)var0.setValue(TILT, var3), 2);
        if (var3.causesVibration()) {
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2);
        }
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return LEAF_SHAPES.get(var0.getValue(TILT));
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapesCache.get(var0);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = var0.getLevel().getBlockState(var0.getClickedPos().below());
        Fluid var2 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var3 = var1.is(Blocks.BIG_DRIPLEAF) || var1.is(Blocks.BIG_DRIPLEAF_STEM);
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(WATERLOGGED, var2.isSourceOfType(FluidTypes.WATER))).setValue(FACING, var3 ? var1.getValue(FACING) : var0.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(WATERLOGGED, FACING, TILT);
    }
}

