/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeSettingsGeneration {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final BiomeSettingsGeneration EMPTY = new BiomeSettingsGeneration((Map<WorldGenStage.Features, List<Supplier<WorldGenCarverWrapper<?>>>>)ImmutableMap.of(), (List<List<Supplier<PlacedFeature>>>)ImmutableList.of());
    public static final MapCodec<BiomeSettingsGeneration> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.simpleMap(WorldGenStage.Features.CODEC, (Codec)WorldGenCarverWrapper.LIST_CODEC.promotePartial(SystemUtils.prefix("Carver: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).flatXmap(ExtraCodecs.nonNullSupplierListCheck(), ExtraCodecs.nonNullSupplierListCheck()), (Keyable)INamable.keys(WorldGenStage.Features.values())).fieldOf("carvers").forGetter(var0 -> var0.carvers), (App)PlacedFeature.LIST_CODEC.promotePartial(SystemUtils.prefix("Feature: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).flatXmap(ExtraCodecs.nonNullSupplierListCheck(), ExtraCodecs.nonNullSupplierListCheck()).listOf().fieldOf("features").forGetter(var0 -> var0.features)).apply((Applicative)var02, BiomeSettingsGeneration::new));
    private final Map<WorldGenStage.Features, List<Supplier<WorldGenCarverWrapper<?>>>> carvers;
    private final List<List<Supplier<PlacedFeature>>> features;
    private final List<WorldGenFeatureConfigured<?, ?>> flowerFeatures;
    private final Set<PlacedFeature> featureSet;

    BiomeSettingsGeneration(Map<WorldGenStage.Features, List<Supplier<WorldGenCarverWrapper<?>>>> var02, List<List<Supplier<PlacedFeature>>> var1) {
        this.carvers = var02;
        this.features = var1;
        this.flowerFeatures = (List)var1.stream().flatMap(Collection::stream).map(Supplier::get).flatMap(PlacedFeature::getFeatures).filter(var0 -> var0.feature == WorldGenerator.FLOWER).collect(ImmutableList.toImmutableList());
        this.featureSet = var1.stream().flatMap(Collection::stream).map(Supplier::get).collect(Collectors.toSet());
    }

    public List<Supplier<WorldGenCarverWrapper<?>>> getCarvers(WorldGenStage.Features var0) {
        return (List)this.carvers.getOrDefault(var0, (List<Supplier<WorldGenCarverWrapper<?>>>)ImmutableList.of());
    }

    public List<WorldGenFeatureConfigured<?, ?>> getFlowerFeatures() {
        return this.flowerFeatures;
    }

    public List<List<Supplier<PlacedFeature>>> features() {
        return this.features;
    }

    public boolean hasFeature(PlacedFeature var0) {
        return this.featureSet.contains(var0);
    }

    public static class a {
        private final Map<WorldGenStage.Features, List<Supplier<WorldGenCarverWrapper<?>>>> carvers = Maps.newLinkedHashMap();
        private final List<List<Supplier<PlacedFeature>>> features = Lists.newArrayList();

        public a addFeature(WorldGenStage.Decoration var0, PlacedFeature var1) {
            return this.addFeature(var0.ordinal(), () -> var1);
        }

        public a addFeature(int var0, Supplier<PlacedFeature> var1) {
            this.addFeatureStepsUpTo(var0);
            this.features.get(var0).add(var1);
            return this;
        }

        public <C extends WorldGenCarverConfiguration> a addCarver(WorldGenStage.Features var02, WorldGenCarverWrapper<C> var1) {
            this.carvers.computeIfAbsent(var02, var0 -> Lists.newArrayList()).add(() -> var1);
            return this;
        }

        private void addFeatureStepsUpTo(int var0) {
            while (this.features.size() <= var0) {
                this.features.add(Lists.newArrayList());
            }
        }

        public BiomeSettingsGeneration build() {
            return new BiomeSettingsGeneration((Map)this.carvers.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, var0 -> ImmutableList.copyOf((Collection)((Collection)var0.getValue())))), (List)this.features.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList()));
        }
    }
}

