/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IStructureAccess;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureManager {
    private final GeneratorAccess level;
    private final GeneratorSettings worldGenSettings;
    private final StructureCheck structureCheck;

    public StructureManager(GeneratorAccess var0, GeneratorSettings var1, StructureCheck var2) {
        this.level = var0;
        this.worldGenSettings = var1;
        this.structureCheck = var2;
    }

    public StructureManager forWorldGenRegion(RegionLimitedWorldAccess var0) {
        if (var0.getLevel() != this.level) {
            throw new IllegalStateException("Using invalid feature manager (source level: " + var0.getLevel() + ", region: " + var0);
        }
        return new StructureManager(var0, this.worldGenSettings, this.structureCheck);
    }

    public List<? extends StructureStart<?>> startsForFeature(SectionPosition var0, StructureGenerator<?> var1) {
        LongSet var2 = this.level.getChunk(var0.x(), var0.z(), ChunkStatus.STRUCTURE_REFERENCES).getReferencesForFeature(var1);
        ImmutableList.Builder var3 = ImmutableList.builder();
        LongIterator longIterator = var2.iterator();
        while (longIterator.hasNext()) {
            long var5 = (Long)longIterator.next();
            SectionPosition var7 = SectionPosition.of(new ChunkCoordIntPair(var5), this.level.getMinSection());
            StructureStart<?> var8 = this.getStartForFeature(var7, var1, this.level.getChunk(var7.x(), var7.z(), ChunkStatus.STRUCTURE_STARTS));
            if (var8 == null || !var8.isValid()) continue;
            var3.add(var8);
        }
        return var3.build();
    }

    @Nullable
    public StructureStart<?> getStartForFeature(SectionPosition var0, StructureGenerator<?> var1, IStructureAccess var2) {
        return var2.getStartForFeature(var1);
    }

    public void setStartForFeature(SectionPosition var0, StructureGenerator<?> var1, StructureStart<?> var2, IStructureAccess var3) {
        var3.setStartForFeature(var1, var2);
    }

    public void addReferenceForFeature(SectionPosition var0, StructureGenerator<?> var1, long var2, IStructureAccess var4) {
        var4.addReferenceForFeature(var1, var2);
    }

    public boolean shouldGenerateFeatures() {
        return this.worldGenSettings.generateFeatures();
    }

    public StructureStart<?> getStructureAt(BlockPosition var0, StructureGenerator<?> var1) {
        for (StructureStart<?> var3 : this.startsForFeature(SectionPosition.of(var0), var1)) {
            if (!var3.getBoundingBox().isInside(var0)) continue;
            return var3;
        }
        return StructureStart.INVALID_START;
    }

    public StructureStart<?> getStructureWithPieceAt(BlockPosition var0, StructureGenerator<?> var1) {
        for (StructureStart<?> var3 : this.startsForFeature(SectionPosition.of(var0), var1)) {
            for (StructurePiece var5 : var3.getPieces()) {
                if (!var5.getBoundingBox().isInside(var0)) continue;
                return var3;
            }
        }
        return StructureStart.INVALID_START;
    }

    public boolean hasAnyStructureAt(BlockPosition var0) {
        SectionPosition var1 = SectionPosition.of(var0);
        return this.level.getChunk(var1.x(), var1.z(), ChunkStatus.STRUCTURE_REFERENCES).hasAnyStructureReferences();
    }

    public StructureCheckResult checkStructurePresence(ChunkCoordIntPair var0, StructureGenerator<?> var1, boolean var2) {
        return this.structureCheck.checkStart(var0, var1, var2);
    }

    public void addReference(StructureStart<?> var0) {
        var0.addReference();
        this.structureCheck.incrementReference(var0.getChunkPos(), var0.getFeature());
    }
}

