/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.IEntityAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.VirtualLevelWritable;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface ICombinedAccess
extends IEntityAccess,
IWorldReader,
VirtualLevelWritable {
    @Override
    default public <T extends TileEntity> Optional<T> getBlockEntity(BlockPosition var0, TileEntityTypes<T> var1) {
        return IWorldReader.super.getBlockEntity(var0, var1);
    }

    @Override
    default public List<VoxelShape> getEntityCollisions(@Nullable Entity var0, AxisAlignedBB var1) {
        return IEntityAccess.super.getEntityCollisions(var0, var1);
    }

    @Override
    default public boolean isUnobstructed(@Nullable Entity var0, VoxelShape var1) {
        return IEntityAccess.super.isUnobstructed(var0, var1);
    }

    @Override
    default public BlockPosition getHeightmapPos(HeightMap.Type var0, BlockPosition var1) {
        return IWorldReader.super.getHeightmapPos(var0, var1);
    }

    public IRegistryCustom registryAccess();

    default public Optional<ResourceKey<BiomeBase>> getBiomeName(BlockPosition var0) {
        return this.registryAccess().registryOrThrow(IRegistry.BIOME_REGISTRY).getResourceKey(this.getBiome(var0));
    }
}

