/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import javax.annotation.Nullable;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.player.PlayerAbilities;

public final class EnumGamemode
extends Enum<EnumGamemode> {
    public static final /* enum */ EnumGamemode SURVIVAL = new EnumGamemode(0, "survival");
    public static final /* enum */ EnumGamemode CREATIVE = new EnumGamemode(1, "creative");
    public static final /* enum */ EnumGamemode ADVENTURE = new EnumGamemode(2, "adventure");
    public static final /* enum */ EnumGamemode SPECTATOR = new EnumGamemode(3, "spectator");
    public static final EnumGamemode DEFAULT_MODE;
    private static final int NOT_SET = -1;
    private final int id;
    private final String name;
    private final IChatBaseComponent shortName;
    private final IChatBaseComponent longName;
    private static final /* synthetic */ EnumGamemode[] k;

    public static EnumGamemode[] values() {
        return (EnumGamemode[])k.clone();
    }

    public static EnumGamemode valueOf(String var0) {
        return Enum.valueOf(EnumGamemode.class, var0);
    }

    private EnumGamemode(int var2, String var3) {
        this.id = var2;
        this.name = var3;
        this.shortName = new ChatMessage("selectWorld.gameMode." + var3);
        this.longName = new ChatMessage("gameMode." + var3);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public IChatBaseComponent getLongDisplayName() {
        return this.longName;
    }

    public IChatBaseComponent getShortDisplayName() {
        return this.shortName;
    }

    public void updatePlayerAbilities(PlayerAbilities var0) {
        if (this == CREATIVE) {
            var0.mayfly = true;
            var0.instabuild = true;
            var0.invulnerable = true;
        } else if (this == SPECTATOR) {
            var0.mayfly = true;
            var0.instabuild = false;
            var0.invulnerable = true;
            var0.flying = true;
        } else {
            var0.mayfly = false;
            var0.instabuild = false;
            var0.invulnerable = false;
            var0.flying = false;
        }
        var0.mayBuild = !this.isBlockPlacingRestricted();
    }

    public boolean isBlockPlacingRestricted() {
        return this == ADVENTURE || this == SPECTATOR;
    }

    public boolean isCreative() {
        return this == CREATIVE;
    }

    public boolean isSurvival() {
        return this == SURVIVAL || this == ADVENTURE;
    }

    public static EnumGamemode byId(int var0) {
        return EnumGamemode.byId(var0, DEFAULT_MODE);
    }

    public static EnumGamemode byId(int var0, EnumGamemode var1) {
        for (EnumGamemode var5 : EnumGamemode.values()) {
            if (var5.id != var0) continue;
            return var5;
        }
        return var1;
    }

    public static EnumGamemode byName(String var0) {
        return EnumGamemode.byName(var0, SURVIVAL);
    }

    public static EnumGamemode byName(String var0, EnumGamemode var1) {
        for (EnumGamemode var5 : EnumGamemode.values()) {
            if (!var5.name.equals(var0)) continue;
            return var5;
        }
        return var1;
    }

    public static int getNullableId(@Nullable EnumGamemode var0) {
        return var0 != null ? var0.id : -1;
    }

    @Nullable
    public static EnumGamemode byNullableId(int var0) {
        if (var0 == -1) {
            return null;
        }
        return EnumGamemode.byId(var0);
    }

    private static /* synthetic */ EnumGamemode[] h() {
        return new EnumGamemode[]{SURVIVAL, CREATIVE, ADVENTURE, SPECTATOR};
    }

    static {
        k = EnumGamemode.h();
        DEFAULT_MODE = SURVIVAL;
    }
}

