/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentSlotType;

public abstract class Enchantment {
    private final EnumItemSlot[] slots;
    private final Rarity rarity;
    public final EnchantmentSlotType category;
    @Nullable
    protected String descriptionId;

    @Nullable
    public static Enchantment byId(int var0) {
        return (Enchantment)IRegistry.ENCHANTMENT.byId(var0);
    }

    protected Enchantment(Rarity var0, EnchantmentSlotType var1, EnumItemSlot[] var2) {
        this.rarity = var0;
        this.category = var1;
        this.slots = var2;
    }

    public Map<EnumItemSlot, ItemStack> getSlotItems(EntityLiving var0) {
        EnumMap var1 = Maps.newEnumMap(EnumItemSlot.class);
        for (EnumItemSlot var5 : this.slots) {
            ItemStack var6 = var0.getItemBySlot(var5);
            if (var6.isEmpty()) continue;
            var1.put(var5, var6);
        }
        return var1;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public int getMinLevel() {
        return 1;
    }

    public int getMaxLevel() {
        return 1;
    }

    public int getMinCost(int var0) {
        return 1 + var0 * 10;
    }

    public int getMaxCost(int var0) {
        return this.getMinCost(var0) + 5;
    }

    public int getDamageProtection(int var0, DamageSource var1) {
        return 0;
    }

    public float getDamageBonus(int var0, EnumMonsterType var1) {
        return 0.0f;
    }

    public final boolean isCompatibleWith(Enchantment var0) {
        return this.checkCompatibility(var0) && var0.checkCompatibility(this);
    }

    protected boolean checkCompatibility(Enchantment var0) {
        return this != var0;
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = SystemUtils.makeDescriptionId("enchantment", IRegistry.ENCHANTMENT.getKey(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public IChatBaseComponent getFullname(int var0) {
        ChatMessage var1 = new ChatMessage(this.getDescriptionId());
        if (this.isCurse()) {
            var1.withStyle(EnumChatFormat.RED);
        } else {
            var1.withStyle(EnumChatFormat.GRAY);
        }
        if (var0 != 1 || this.getMaxLevel() != 1) {
            var1.append(" ").append(new ChatMessage("enchantment.level." + var0));
        }
        return var1;
    }

    public boolean canEnchant(ItemStack var0) {
        return this.category.canEnchant(var0.getItem());
    }

    public void doPostAttack(EntityLiving var0, Entity var1, int var2) {
    }

    public void doPostHurt(EntityLiving var0, Entity var1, int var2) {
    }

    public boolean isTreasureOnly() {
        return false;
    }

    public boolean isCurse() {
        return false;
    }

    public boolean isTradeable() {
        return true;
    }

    public boolean isDiscoverable() {
        return true;
    }

    public static final class Rarity
    extends Enum<Rarity> {
        public static final /* enum */ Rarity COMMON = new Rarity(10);
        public static final /* enum */ Rarity UNCOMMON = new Rarity(5);
        public static final /* enum */ Rarity RARE = new Rarity(2);
        public static final /* enum */ Rarity VERY_RARE = new Rarity(1);
        private final int weight;
        private static final /* synthetic */ Rarity[] f;

        public static Rarity[] values() {
            return (Rarity[])f.clone();
        }

        public static Rarity valueOf(String var0) {
            return Enum.valueOf(Rarity.class, var0);
        }

        private Rarity(int var2) {
            this.weight = var2;
        }

        public int getWeight() {
            return this.weight;
        }

        private static /* synthetic */ Rarity[] b() {
            return new Rarity[]{COMMON, UNCOMMON, RARE, VERY_RARE};
        }

        static {
            f = Rarity.b();
        }
    }
}

