/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;

public class RecipiesShield
extends IRecipeComplex {
    public RecipiesShield(MinecraftKey var0) {
        super(var0);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        ItemStack var2 = ItemStack.EMPTY;
        ItemStack var3 = ItemStack.EMPTY;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (var5.getItem() instanceof ItemBanner) {
                if (!var3.isEmpty()) {
                    return false;
                }
                var3 = var5;
                continue;
            }
            if (var5.is(Items.SHIELD)) {
                if (!var2.isEmpty()) {
                    return false;
                }
                if (ItemBlock.getBlockEntityData(var5) != null) {
                    return false;
                }
                var2 = var5;
                continue;
            }
            return false;
        }
        return !var2.isEmpty() && !var3.isEmpty();
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0) {
        Object var4;
        Object var1 = ItemStack.EMPTY;
        ItemStack var2 = ItemStack.EMPTY;
        for (int var3 = 0; var3 < var0.getContainerSize(); ++var3) {
            var4 = var0.getItem(var3);
            if (((ItemStack)var4).isEmpty()) continue;
            if (((ItemStack)var4).getItem() instanceof ItemBanner) {
                var1 = var4;
                continue;
            }
            if (!((ItemStack)var4).is(Items.SHIELD)) continue;
            var2 = ((ItemStack)var4).copy();
        }
        if (var2.isEmpty()) {
            return var2;
        }
        NBTTagCompound var3 = ItemBlock.getBlockEntityData((ItemStack)var1);
        var4 = var3 == null ? new NBTTagCompound() : var3.copy();
        ((NBTTagCompound)var4).putInt("Base", ((ItemBanner)((ItemStack)var1).getItem()).getColor().getId());
        ItemBlock.setBlockEntityData(var2, TileEntityTypes.BANNER, (NBTTagCompound)var4);
        return var2;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHIELD_DECORATION;
    }
}

