/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;

public class RecipeSmithing
implements IRecipe<IInventory> {
    final RecipeItemStack base;
    final RecipeItemStack addition;
    final ItemStack result;
    private final MinecraftKey id;

    public RecipeSmithing(MinecraftKey var0, RecipeItemStack var1, RecipeItemStack var2, ItemStack var3) {
        this.id = var0;
        this.base = var1;
        this.addition = var2;
        this.result = var3;
    }

    @Override
    public boolean matches(IInventory var0, World var1) {
        return this.base.test(var0.getItem(0)) && this.addition.test(var0.getItem(1));
    }

    @Override
    public ItemStack assemble(IInventory var0) {
        ItemStack var1 = this.result.copy();
        NBTTagCompound var2 = var0.getItem(0).getTag();
        if (var2 != null) {
            var1.setTag(var2.copy());
        }
        return var1;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public ItemStack getResultItem() {
        return this.result;
    }

    public boolean isAdditionIngredient(ItemStack var0) {
        return this.addition.test(var0);
    }

    @Override
    public ItemStack getToastSymbol() {
        return new ItemStack(Blocks.SMITHING_TABLE);
    }

    @Override
    public MinecraftKey getId() {
        return this.id;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SMITHING;
    }

    @Override
    public Recipes<?> getType() {
        return Recipes.SMITHING;
    }

    @Override
    public boolean isIncomplete() {
        return Stream.of(this.base, this.addition).anyMatch(var0 -> var0.getItems().length == 0);
    }

    public static class a
    implements RecipeSerializer<RecipeSmithing> {
        @Override
        public RecipeSmithing fromJson(MinecraftKey var0, JsonObject var1) {
            RecipeItemStack var2 = RecipeItemStack.fromJson((JsonElement)ChatDeserializer.getAsJsonObject(var1, "base"));
            RecipeItemStack var3 = RecipeItemStack.fromJson((JsonElement)ChatDeserializer.getAsJsonObject(var1, "addition"));
            ItemStack var4 = ShapedRecipes.itemStackFromJson(ChatDeserializer.getAsJsonObject(var1, "result"));
            return new RecipeSmithing(var0, var2, var3, var4);
        }

        @Override
        public RecipeSmithing fromNetwork(MinecraftKey var0, PacketDataSerializer var1) {
            RecipeItemStack var2 = RecipeItemStack.fromNetwork(var1);
            RecipeItemStack var3 = RecipeItemStack.fromNetwork(var1);
            ItemStack var4 = var1.readItem();
            return new RecipeSmithing(var0, var2, var3, var4);
        }

        @Override
        public void toNetwork(PacketDataSerializer var0, RecipeSmithing var1) {
            var1.base.toNetwork(var0);
            var1.addition.toNetwork(var0);
            var0.writeItem(var1.result);
        }

        @Override
        public /* synthetic */ IRecipe fromNetwork(MinecraftKey minecraftKey, PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(minecraftKey, packetDataSerializer);
        }

        @Override
        public /* synthetic */ IRecipe fromJson(MinecraftKey minecraftKey, JsonObject jsonObject) {
            return this.fromJson(minecraftKey, jsonObject);
        }
    }
}

