/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsInstance;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.IMaterial;

public final class RecipeItemStack
implements Predicate<ItemStack> {
    public static final RecipeItemStack EMPTY = new RecipeItemStack(Stream.empty());
    private final Provider[] values;
    @Nullable
    public ItemStack[] itemStacks;
    @Nullable
    private IntList stackingIds;

    public RecipeItemStack(Stream<? extends Provider> var0) {
        this.values = (Provider[])var0.toArray(Provider[]::new);
    }

    public ItemStack[] getItems() {
        this.dissolve();
        return this.itemStacks;
    }

    public void dissolve() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.values).flatMap(var0 -> var0.getItems().stream()).distinct().toArray(ItemStack[]::new);
        }
    }

    @Override
    public boolean test(@Nullable ItemStack var0) {
        if (var0 == null) {
            return false;
        }
        this.dissolve();
        if (this.itemStacks.length == 0) {
            return var0.isEmpty();
        }
        for (ItemStack var4 : this.itemStacks) {
            if (!var4.is(var0.getItem())) continue;
            return true;
        }
        return false;
    }

    public IntList getStackingIds() {
        if (this.stackingIds == null) {
            this.dissolve();
            this.stackingIds = new IntArrayList(this.itemStacks.length);
            for (ItemStack var3 : this.itemStacks) {
                this.stackingIds.add(AutoRecipeStackManager.getStackingIndex(var3));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public void toNetwork(PacketDataSerializer var0) {
        this.dissolve();
        var0.writeCollection(Arrays.asList(this.itemStacks), PacketDataSerializer::writeItem);
    }

    public JsonElement toJson() {
        if (this.values.length == 1) {
            return this.values[0].serialize();
        }
        JsonArray var0 = new JsonArray();
        for (Provider var4 : this.values) {
            var0.add((JsonElement)var4.serialize());
        }
        return var0;
    }

    public boolean isEmpty() {
        return !(this.values.length != 0 || this.itemStacks != null && this.itemStacks.length != 0 || this.stackingIds != null && !this.stackingIds.isEmpty());
    }

    private static RecipeItemStack fromValues(Stream<? extends Provider> var0) {
        RecipeItemStack var1 = new RecipeItemStack(var0);
        return var1.values.length == 0 ? EMPTY : var1;
    }

    public static RecipeItemStack of() {
        return EMPTY;
    }

    public static RecipeItemStack of(IMaterial ... var0) {
        return RecipeItemStack.of(Arrays.stream(var0).map(ItemStack::new));
    }

    public static RecipeItemStack of(ItemStack ... var0) {
        return RecipeItemStack.of(Arrays.stream(var0));
    }

    public static RecipeItemStack of(Stream<ItemStack> var02) {
        return RecipeItemStack.fromValues(var02.filter(var0 -> !var0.isEmpty()).map(StackProvider::new));
    }

    public static RecipeItemStack of(Tag<Item> var0) {
        return RecipeItemStack.fromValues(Stream.of(new b(var0)));
    }

    public static RecipeItemStack fromNetwork(PacketDataSerializer var0) {
        return RecipeItemStack.fromValues(var0.readList(PacketDataSerializer::readItem).stream().map(StackProvider::new));
    }

    public static RecipeItemStack fromJson(@Nullable JsonElement var02) {
        if (var02 == null || var02.isJsonNull()) {
            throw new JsonSyntaxException("Item cannot be null");
        }
        if (var02.isJsonObject()) {
            return RecipeItemStack.fromValues(Stream.of(RecipeItemStack.valueFromJson(var02.getAsJsonObject())));
        }
        if (var02.isJsonArray()) {
            JsonArray var1 = var02.getAsJsonArray();
            if (var1.size() == 0) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            return RecipeItemStack.fromValues(StreamSupport.stream(var1.spliterator(), false).map(var0 -> RecipeItemStack.valueFromJson(ChatDeserializer.convertToJsonObject(var0, "item"))));
        }
        throw new JsonSyntaxException("Expected item to be object or array of objects");
    }

    private static Provider valueFromJson(JsonObject var02) {
        if (var02.has("item") && var02.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (var02.has("item")) {
            Item var1 = ShapedRecipes.itemFromJson(var02);
            return new StackProvider(new ItemStack(var1));
        }
        if (var02.has("tag")) {
            MinecraftKey var1 = new MinecraftKey(ChatDeserializer.getAsString(var02, "tag"));
            Tag<Item> var2 = TagsInstance.getInstance().getTagOrThrow(IRegistry.ITEM_REGISTRY, var1, var0 -> new JsonSyntaxException("Unknown item tag '" + var0 + "'"));
            return new b(var2);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    @Override
    public /* synthetic */ boolean test(@Nullable Object object) {
        return this.test((ItemStack)object);
    }

    public static interface Provider {
        public Collection<ItemStack> getItems();

        public JsonObject serialize();
    }

    static class b
    implements Provider {
        private final Tag<Item> tag;

        b(Tag<Item> var0) {
            this.tag = var0;
        }

        @Override
        public Collection<ItemStack> getItems() {
            ArrayList var0 = Lists.newArrayList();
            for (Item var2 : this.tag.getValues()) {
                var0.add(new ItemStack(var2));
            }
            return var0;
        }

        @Override
        public JsonObject serialize() {
            JsonObject var0 = new JsonObject();
            var0.addProperty("tag", TagsInstance.getInstance().getIdOrThrow(IRegistry.ITEM_REGISTRY, this.tag, () -> new IllegalStateException("Unknown item tag")).toString());
            return var0;
        }
    }

    public static class StackProvider
    implements Provider {
        private final ItemStack item;

        public StackProvider(ItemStack var0) {
            this.item = var0;
        }

        @Override
        public Collection<ItemStack> getItems() {
            return Collections.singleton(this.item);
        }

        @Override
        public JsonObject serialize() {
            JsonObject var0 = new JsonObject();
            var0.addProperty("item", IRegistry.ITEM.getKey(this.item.getItem()).toString());
            return var0;
        }
    }
}

