/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.IRegistry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IMaterial;

public class PotionBrewer {
    public static final int BREWING_TIME_SECONDS = 20;
    private static final List<PredicatedCombination<PotionRegistry>> POTION_MIXES = Lists.newArrayList();
    private static final List<PredicatedCombination<Item>> CONTAINER_MIXES = Lists.newArrayList();
    private static final List<RecipeItemStack> ALLOWED_CONTAINERS = Lists.newArrayList();
    private static final Predicate<ItemStack> ALLOWED_CONTAINER = var0 -> {
        for (RecipeItemStack var2 : ALLOWED_CONTAINERS) {
            if (!var2.test((ItemStack)var0)) continue;
            return true;
        }
        return false;
    };

    public static boolean isIngredient(ItemStack var0) {
        return PotionBrewer.isContainerIngredient(var0) || PotionBrewer.isPotionIngredient(var0);
    }

    protected static boolean isContainerIngredient(ItemStack var0) {
        int var2 = CONTAINER_MIXES.size();
        for (int var1 = 0; var1 < var2; ++var1) {
            if (!PotionBrewer.CONTAINER_MIXES.get((int)var1).ingredient.test(var0)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isPotionIngredient(ItemStack var0) {
        int var2 = POTION_MIXES.size();
        for (int var1 = 0; var1 < var2; ++var1) {
            if (!PotionBrewer.POTION_MIXES.get((int)var1).ingredient.test(var0)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBrewablePotion(PotionRegistry var0) {
        int var2 = POTION_MIXES.size();
        for (int var1 = 0; var1 < var2; ++var1) {
            if (PotionBrewer.POTION_MIXES.get((int)var1).to != var0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMix(ItemStack var0, ItemStack var1) {
        if (!ALLOWED_CONTAINER.test(var0)) {
            return false;
        }
        return PotionBrewer.hasContainerMix(var0, var1) || PotionBrewer.hasPotionMix(var0, var1);
    }

    protected static boolean hasContainerMix(ItemStack var0, ItemStack var1) {
        Item var2 = var0.getItem();
        int var4 = CONTAINER_MIXES.size();
        for (int var3 = 0; var3 < var4; ++var3) {
            PredicatedCombination<Item> var5 = CONTAINER_MIXES.get(var3);
            if (var5.from != var2 || !var5.ingredient.test(var1)) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasPotionMix(ItemStack var0, ItemStack var1) {
        PotionRegistry var2 = PotionUtil.getPotion(var0);
        int var4 = POTION_MIXES.size();
        for (int var3 = 0; var3 < var4; ++var3) {
            PredicatedCombination<PotionRegistry> var5 = POTION_MIXES.get(var3);
            if (var5.from != var2 || !var5.ingredient.test(var1)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack mix(ItemStack var0, ItemStack var1) {
        if (!var1.isEmpty()) {
            PredicatedCombination<Object> var6;
            int var4;
            PotionRegistry var2 = PotionUtil.getPotion(var1);
            Item var3 = var1.getItem();
            int var5 = CONTAINER_MIXES.size();
            for (var4 = 0; var4 < var5; ++var4) {
                var6 = CONTAINER_MIXES.get(var4);
                if (var6.from != var3 || !var6.ingredient.test(var0)) continue;
                return PotionUtil.setPotion(new ItemStack((IMaterial)var6.to), var2);
            }
            var5 = POTION_MIXES.size();
            for (var4 = 0; var4 < var5; ++var4) {
                var6 = POTION_MIXES.get(var4);
                if (var6.from != var2 || !var6.ingredient.test(var0)) continue;
                return PotionUtil.setPotion(new ItemStack(var3), (PotionRegistry)var6.to);
            }
        }
        return var1;
    }

    public static void bootStrap() {
        PotionBrewer.addContainer(Items.POTION);
        PotionBrewer.addContainer(Items.SPLASH_POTION);
        PotionBrewer.addContainer(Items.LINGERING_POTION);
        PotionBrewer.addContainerRecipe(Items.POTION, Items.GUNPOWDER, Items.SPLASH_POTION);
        PotionBrewer.addContainerRecipe(Items.SPLASH_POTION, Items.DRAGON_BREATH, Items.LINGERING_POTION);
        PotionBrewer.addMix(Potions.WATER, Items.GLISTERING_MELON_SLICE, Potions.MUNDANE);
        PotionBrewer.addMix(Potions.WATER, Items.GHAST_TEAR, Potions.MUNDANE);
        PotionBrewer.addMix(Potions.WATER, Items.RABBIT_FOOT, Potions.MUNDANE);
        PotionBrewer.addMix(Potions.WATER, Items.BLAZE_POWDER, Potions.MUNDANE);
        PotionBrewer.addMix(Potions.WATER, Items.SPIDER_EYE, Potions.MUNDANE);
        PotionBrewer.addMix(Potions.WATER, Items.SUGAR, Potions.MUNDANE);
        PotionBrewer.addMix(Potions.WATER, Items.MAGMA_CREAM, Potions.MUNDANE);
        PotionBrewer.addMix(Potions.WATER, Items.GLOWSTONE_DUST, Potions.THICK);
        PotionBrewer.addMix(Potions.WATER, Items.REDSTONE, Potions.MUNDANE);
        PotionBrewer.addMix(Potions.WATER, Items.NETHER_WART, Potions.AWKWARD);
        PotionBrewer.addMix(Potions.AWKWARD, Items.GOLDEN_CARROT, Potions.NIGHT_VISION);
        PotionBrewer.addMix(Potions.NIGHT_VISION, Items.REDSTONE, Potions.LONG_NIGHT_VISION);
        PotionBrewer.addMix(Potions.NIGHT_VISION, Items.FERMENTED_SPIDER_EYE, Potions.INVISIBILITY);
        PotionBrewer.addMix(Potions.LONG_NIGHT_VISION, Items.FERMENTED_SPIDER_EYE, Potions.LONG_INVISIBILITY);
        PotionBrewer.addMix(Potions.INVISIBILITY, Items.REDSTONE, Potions.LONG_INVISIBILITY);
        PotionBrewer.addMix(Potions.AWKWARD, Items.MAGMA_CREAM, Potions.FIRE_RESISTANCE);
        PotionBrewer.addMix(Potions.FIRE_RESISTANCE, Items.REDSTONE, Potions.LONG_FIRE_RESISTANCE);
        PotionBrewer.addMix(Potions.AWKWARD, Items.RABBIT_FOOT, Potions.LEAPING);
        PotionBrewer.addMix(Potions.LEAPING, Items.REDSTONE, Potions.LONG_LEAPING);
        PotionBrewer.addMix(Potions.LEAPING, Items.GLOWSTONE_DUST, Potions.STRONG_LEAPING);
        PotionBrewer.addMix(Potions.LEAPING, Items.FERMENTED_SPIDER_EYE, Potions.SLOWNESS);
        PotionBrewer.addMix(Potions.LONG_LEAPING, Items.FERMENTED_SPIDER_EYE, Potions.LONG_SLOWNESS);
        PotionBrewer.addMix(Potions.SLOWNESS, Items.REDSTONE, Potions.LONG_SLOWNESS);
        PotionBrewer.addMix(Potions.SLOWNESS, Items.GLOWSTONE_DUST, Potions.STRONG_SLOWNESS);
        PotionBrewer.addMix(Potions.AWKWARD, Items.TURTLE_HELMET, Potions.TURTLE_MASTER);
        PotionBrewer.addMix(Potions.TURTLE_MASTER, Items.REDSTONE, Potions.LONG_TURTLE_MASTER);
        PotionBrewer.addMix(Potions.TURTLE_MASTER, Items.GLOWSTONE_DUST, Potions.STRONG_TURTLE_MASTER);
        PotionBrewer.addMix(Potions.SWIFTNESS, Items.FERMENTED_SPIDER_EYE, Potions.SLOWNESS);
        PotionBrewer.addMix(Potions.LONG_SWIFTNESS, Items.FERMENTED_SPIDER_EYE, Potions.LONG_SLOWNESS);
        PotionBrewer.addMix(Potions.AWKWARD, Items.SUGAR, Potions.SWIFTNESS);
        PotionBrewer.addMix(Potions.SWIFTNESS, Items.REDSTONE, Potions.LONG_SWIFTNESS);
        PotionBrewer.addMix(Potions.SWIFTNESS, Items.GLOWSTONE_DUST, Potions.STRONG_SWIFTNESS);
        PotionBrewer.addMix(Potions.AWKWARD, Items.PUFFERFISH, Potions.WATER_BREATHING);
        PotionBrewer.addMix(Potions.WATER_BREATHING, Items.REDSTONE, Potions.LONG_WATER_BREATHING);
        PotionBrewer.addMix(Potions.AWKWARD, Items.GLISTERING_MELON_SLICE, Potions.HEALING);
        PotionBrewer.addMix(Potions.HEALING, Items.GLOWSTONE_DUST, Potions.STRONG_HEALING);
        PotionBrewer.addMix(Potions.HEALING, Items.FERMENTED_SPIDER_EYE, Potions.HARMING);
        PotionBrewer.addMix(Potions.STRONG_HEALING, Items.FERMENTED_SPIDER_EYE, Potions.STRONG_HARMING);
        PotionBrewer.addMix(Potions.HARMING, Items.GLOWSTONE_DUST, Potions.STRONG_HARMING);
        PotionBrewer.addMix(Potions.POISON, Items.FERMENTED_SPIDER_EYE, Potions.HARMING);
        PotionBrewer.addMix(Potions.LONG_POISON, Items.FERMENTED_SPIDER_EYE, Potions.HARMING);
        PotionBrewer.addMix(Potions.STRONG_POISON, Items.FERMENTED_SPIDER_EYE, Potions.STRONG_HARMING);
        PotionBrewer.addMix(Potions.AWKWARD, Items.SPIDER_EYE, Potions.POISON);
        PotionBrewer.addMix(Potions.POISON, Items.REDSTONE, Potions.LONG_POISON);
        PotionBrewer.addMix(Potions.POISON, Items.GLOWSTONE_DUST, Potions.STRONG_POISON);
        PotionBrewer.addMix(Potions.AWKWARD, Items.GHAST_TEAR, Potions.REGENERATION);
        PotionBrewer.addMix(Potions.REGENERATION, Items.REDSTONE, Potions.LONG_REGENERATION);
        PotionBrewer.addMix(Potions.REGENERATION, Items.GLOWSTONE_DUST, Potions.STRONG_REGENERATION);
        PotionBrewer.addMix(Potions.AWKWARD, Items.BLAZE_POWDER, Potions.STRENGTH);
        PotionBrewer.addMix(Potions.STRENGTH, Items.REDSTONE, Potions.LONG_STRENGTH);
        PotionBrewer.addMix(Potions.STRENGTH, Items.GLOWSTONE_DUST, Potions.STRONG_STRENGTH);
        PotionBrewer.addMix(Potions.WATER, Items.FERMENTED_SPIDER_EYE, Potions.WEAKNESS);
        PotionBrewer.addMix(Potions.WEAKNESS, Items.REDSTONE, Potions.LONG_WEAKNESS);
        PotionBrewer.addMix(Potions.AWKWARD, Items.PHANTOM_MEMBRANE, Potions.SLOW_FALLING);
        PotionBrewer.addMix(Potions.SLOW_FALLING, Items.REDSTONE, Potions.LONG_SLOW_FALLING);
    }

    private static void addContainerRecipe(Item var0, Item var1, Item var2) {
        if (!(var0 instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + IRegistry.ITEM.getKey(var0));
        }
        if (!(var2 instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + IRegistry.ITEM.getKey(var2));
        }
        CONTAINER_MIXES.add(new PredicatedCombination<Item>(var0, RecipeItemStack.of(var1), var2));
    }

    private static void addContainer(Item var0) {
        if (!(var0 instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + IRegistry.ITEM.getKey(var0));
        }
        ALLOWED_CONTAINERS.add(RecipeItemStack.of(var0));
    }

    private static void addMix(PotionRegistry var0, Item var1, PotionRegistry var2) {
        POTION_MIXES.add(new PredicatedCombination<PotionRegistry>(var0, RecipeItemStack.of(var1), var2));
    }

    static class PredicatedCombination<T> {
        final T from;
        final RecipeItemStack ingredient;
        final T to;

        public PredicatedCombination(T var0, RecipeItemStack var1, T var2) {
            this.from = var0;
            this.ingredient = var1;
            this.to = var2;
        }
    }
}

