/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMapBase;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.saveddata.maps.WorldMap;

public class ItemWorldMap
extends ItemWorldMapBase {
    public static final int IMAGE_WIDTH = 128;
    public static final int IMAGE_HEIGHT = 128;
    private static final int DEFAULT_MAP_COLOR = -12173266;
    private static final String TAG_MAP = "map";

    public ItemWorldMap(Item.Info var0) {
        super(var0);
    }

    public static ItemStack create(World var0, int var1, int var2, byte var3, boolean var4, boolean var5) {
        ItemStack var6 = new ItemStack(Items.FILLED_MAP);
        ItemWorldMap.createAndStoreSavedData(var6, var0, var1, var2, var3, var4, var5, var0.dimension());
        return var6;
    }

    @Nullable
    public static WorldMap getSavedData(@Nullable Integer var0, World var1) {
        return var0 == null ? null : var1.getMapData(ItemWorldMap.makeKey(var0));
    }

    @Nullable
    public static WorldMap getSavedData(ItemStack var0, World var1) {
        Integer var2 = ItemWorldMap.getMapId(var0);
        return ItemWorldMap.getSavedData(var2, var1);
    }

    @Nullable
    public static Integer getMapId(ItemStack var0) {
        NBTTagCompound var1 = var0.getTag();
        return var1 != null && var1.contains(TAG_MAP, 99) ? Integer.valueOf(var1.getInt(TAG_MAP)) : null;
    }

    public static int createNewSavedData(World var0, int var1, int var2, int var3, boolean var4, boolean var5, ResourceKey<World> var6) {
        WorldMap var7 = WorldMap.createFresh(var1, var2, (byte)var3, var4, var5, var6);
        int var8 = var0.getFreeMapId();
        var0.setMapData(ItemWorldMap.makeKey(var8), var7);
        return var8;
    }

    private static void storeMapData(ItemStack var0, int var1) {
        var0.getOrCreateTag().putInt(TAG_MAP, var1);
    }

    private static void createAndStoreSavedData(ItemStack var0, World var1, int var2, int var3, int var4, boolean var5, boolean var6, ResourceKey<World> var7) {
        int var8 = ItemWorldMap.createNewSavedData(var1, var2, var3, var4, var5, var6, var7);
        ItemWorldMap.storeMapData(var0, var8);
    }

    public static String makeKey(int var0) {
        return "map_" + var0;
    }

    public void update(World var0, Entity var1, WorldMap var2) {
        if (var0.dimension() != var2.dimension || !(var1 instanceof EntityHuman)) {
            return;
        }
        int var3 = 1 << var2.scale;
        int var4 = var2.x;
        int var5 = var2.z;
        int var6 = MathHelper.floor(var1.getX() - (double)var4) / var3 + 64;
        int var7 = MathHelper.floor(var1.getZ() - (double)var5) / var3 + 64;
        int var8 = 128 / var3;
        if (var0.dimensionType().hasCeiling()) {
            var8 /= 2;
        }
        WorldMap.WorldMapHumanTracker var9 = var2.getHoldingPlayer((EntityHuman)var1);
        ++var9.step;
        boolean var10 = false;
        for (int var11 = var6 - var8 + 1; var11 < var6 + var8; ++var11) {
            if ((var11 & 0xF) != (var9.step & 0xF) && !var10) continue;
            var10 = false;
            double var12 = 0.0;
            for (int var14 = var7 - var8 - 1; var14 < var7 + var8; ++var14) {
                double var30;
                Object var29;
                Object var28;
                if (var11 < 0 || var14 < -1 || var11 >= 128 || var14 >= 128) continue;
                int var15 = var11 - var6;
                int var16 = var14 - var7;
                boolean var17 = var15 * var15 + var16 * var16 > (var8 - 2) * (var8 - 2);
                int var18 = (var4 / var3 + var11 - 64) * var3;
                int var19 = (var5 / var3 + var14 - 64) * var3;
                LinkedHashMultiset var20 = LinkedHashMultiset.create();
                Chunk var21 = var0.getChunkAt(new BlockPosition(var18, 0, var19));
                if (var21.isEmpty()) continue;
                ChunkCoordIntPair var22 = var21.getPos();
                int var23 = var18 & 0xF;
                int var24 = var19 & 0xF;
                int var25 = 0;
                double var26 = 0.0;
                if (var0.dimensionType().hasCeiling()) {
                    int var282 = var18 + var19 * 231871;
                    if (((var282 = var282 * var282 * 31287121 + var282 * 11) >> 20 & 1) == 0) {
                        var20.add((Object)Blocks.DIRT.defaultBlockState().getMapColor(var0, BlockPosition.ZERO), 10);
                    } else {
                        var20.add((Object)Blocks.STONE.defaultBlockState().getMapColor(var0, BlockPosition.ZERO), 100);
                    }
                    var26 = 100.0;
                } else {
                    var28 = new BlockPosition.MutableBlockPosition();
                    var29 = new BlockPosition.MutableBlockPosition();
                    for (int var302 = 0; var302 < var3; ++var302) {
                        for (int var31 = 0; var31 < var3; ++var31) {
                            IBlockData var33;
                            int var32 = var21.getHeight(HeightMap.Type.WORLD_SURFACE, var302 + var23, var31 + var24) + 1;
                            if (var32 > var0.getMinBuildHeight() + 1) {
                                do {
                                    ((BlockPosition.MutableBlockPosition)var28).set(var22.getMinBlockX() + var302 + var23, --var32, var22.getMinBlockZ() + var31 + var24);
                                } while ((var33 = var21.getBlockState((BlockPosition)var28)).getMapColor(var0, (BlockPosition)var28) == MaterialMapColor.NONE && var32 > var0.getMinBuildHeight());
                                if (var32 > var0.getMinBuildHeight() && !var33.getFluidState().isEmpty()) {
                                    IBlockData var35;
                                    int var34 = var32 - 1;
                                    var29.set((BaseBlockPosition)var28);
                                    do {
                                        var29.setY(var34--);
                                        var35 = var21.getBlockState((BlockPosition)var29);
                                        ++var25;
                                    } while (var34 > var0.getMinBuildHeight() && !var35.getFluidState().isEmpty());
                                    var33 = this.getCorrectStateForFluidBlock(var0, var33, (BlockPosition)var28);
                                }
                            } else {
                                var33 = Blocks.BEDROCK.defaultBlockState();
                            }
                            var2.checkBanners(var0, var22.getMinBlockX() + var302 + var23, var22.getMinBlockZ() + var31 + var24);
                            var26 += (double)var32 / (double)(var3 * var3);
                            var20.add((Object)var33.getMapColor(var0, (BlockPosition)var28));
                        }
                    }
                }
                var28 = (MaterialMapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)var20), (Object)MaterialMapColor.NONE);
                var29 = var28 == MaterialMapColor.WATER ? ((var30 = (double)(var25 /= var3 * var3) * 0.1 + (double)(var11 + var14 & 1) * 0.2) < 0.5 ? MaterialMapColor.a.HIGH : (var30 > 0.9 ? MaterialMapColor.a.LOW : MaterialMapColor.a.NORMAL)) : ((var30 = (var26 - var12) * 4.0 / (double)(var3 + 4) + ((double)(var11 + var14 & 1) - 0.5) * 0.4) > 0.6 ? MaterialMapColor.a.HIGH : (var30 < -0.6 ? MaterialMapColor.a.LOW : MaterialMapColor.a.NORMAL));
                var12 = var26;
                if (var14 < 0 || var15 * var15 + var16 * var16 >= var8 * var8 || var17 && (var11 + var14 & 1) == 0) continue;
                var10 |= var2.updateColor(var11, var14, ((MaterialMapColor)var28).getPackedId((MaterialMapColor.a)((Object)var29)));
            }
        }
    }

    private IBlockData getCorrectStateForFluidBlock(World var0, IBlockData var1, BlockPosition var2) {
        Fluid var3 = var1.getFluidState();
        if (!var3.isEmpty() && !var1.isFaceSturdy(var0, var2, EnumDirection.UP)) {
            return var3.createLegacyBlock();
        }
        return var1;
    }

    private static boolean isBiomeWatery(boolean[] var0, int var1, int var2, int var3) {
        return var0[var2 * var1 + var3 * var1 * 128 * var1];
    }

    public static void renderBiomePreviewMap(WorldServer var0, ItemStack var1) {
        int var8;
        int var7;
        WorldMap var2 = ItemWorldMap.getSavedData(var1, (World)var0);
        if (var2 == null) {
            return;
        }
        if (var0.dimension() != var2.dimension) {
            return;
        }
        int var3 = 1 << var2.scale;
        int var4 = var2.x;
        int var5 = var2.z;
        boolean[] var6 = new boolean[128 * var3 * 128 * var3];
        for (var7 = 0; var7 < 128 * var3; ++var7) {
            for (var8 = 0; var8 < 128 * var3; ++var8) {
                BiomeBase.Geography var9 = var0.getBiome(new BlockPosition((var4 / var3 - 64) * var3 + var8, 0, (var5 / var3 - 64) * var3 + var7)).getBiomeCategory();
                var6[var7 * 128 * var3 + var8] = var9 == BiomeBase.Geography.OCEAN || var9 == BiomeBase.Geography.RIVER || var9 == BiomeBase.Geography.SWAMP;
            }
        }
        for (var7 = 0; var7 < 128; ++var7) {
            for (var8 = 0; var8 < 128; ++var8) {
                if (var7 <= 0 || var8 <= 0 || var7 >= 127 || var8 >= 127) continue;
                int var9 = 8;
                if (!ItemWorldMap.isBiomeWatery(var6, var3, var7 - 1, var8 - 1)) {
                    --var9;
                }
                if (!ItemWorldMap.isBiomeWatery(var6, var3, var7 - 1, var8 + 1)) {
                    --var9;
                }
                if (!ItemWorldMap.isBiomeWatery(var6, var3, var7 - 1, var8)) {
                    --var9;
                }
                if (!ItemWorldMap.isBiomeWatery(var6, var3, var7 + 1, var8 - 1)) {
                    --var9;
                }
                if (!ItemWorldMap.isBiomeWatery(var6, var3, var7 + 1, var8 + 1)) {
                    --var9;
                }
                if (!ItemWorldMap.isBiomeWatery(var6, var3, var7 + 1, var8)) {
                    --var9;
                }
                if (!ItemWorldMap.isBiomeWatery(var6, var3, var7, var8 - 1)) {
                    --var9;
                }
                if (!ItemWorldMap.isBiomeWatery(var6, var3, var7, var8 + 1)) {
                    --var9;
                }
                MaterialMapColor.a var10 = MaterialMapColor.a.LOWEST;
                MaterialMapColor var11 = MaterialMapColor.NONE;
                if (ItemWorldMap.isBiomeWatery(var6, var3, var7, var8)) {
                    var11 = MaterialMapColor.COLOR_ORANGE;
                    if (var9 > 7 && var8 % 2 == 0) {
                        switch ((var7 + (int)(MathHelper.sin((float)var8 + 0.0f) * 7.0f)) / 8 % 5) {
                            case 0: 
                            case 4: {
                                var10 = MaterialMapColor.a.LOW;
                                break;
                            }
                            case 1: 
                            case 3: {
                                var10 = MaterialMapColor.a.NORMAL;
                                break;
                            }
                            case 2: {
                                var10 = MaterialMapColor.a.HIGH;
                            }
                        }
                    } else if (var9 > 7) {
                        var11 = MaterialMapColor.NONE;
                    } else if (var9 > 5) {
                        var10 = MaterialMapColor.a.NORMAL;
                    } else if (var9 > 3) {
                        var10 = MaterialMapColor.a.LOW;
                    } else if (var9 > 1) {
                        var10 = MaterialMapColor.a.LOW;
                    }
                } else if (var9 > 0) {
                    var11 = MaterialMapColor.COLOR_BROWN;
                    var10 = var9 > 3 ? MaterialMapColor.a.NORMAL : MaterialMapColor.a.LOWEST;
                }
                if (var11 == MaterialMapColor.NONE) continue;
                var2.setColor(var7, var8, var11.getPackedId(var10));
            }
        }
    }

    @Override
    public void inventoryTick(ItemStack var0, World var1, Entity var2, int var3, boolean var4) {
        if (var1.isClientSide) {
            return;
        }
        WorldMap var5 = ItemWorldMap.getSavedData(var0, var1);
        if (var5 == null) {
            return;
        }
        if (var2 instanceof EntityHuman) {
            EntityHuman var6 = (EntityHuman)var2;
            var5.tickCarriedBy(var6, var0);
        }
        if (!var5.locked && (var4 || var2 instanceof EntityHuman && ((EntityHuman)var2).getOffhandItem() == var0)) {
            this.update(var1, var2, var5);
        }
    }

    @Override
    @Nullable
    public Packet<?> getUpdatePacket(ItemStack var0, World var1, EntityHuman var2) {
        Integer var3 = ItemWorldMap.getMapId(var0);
        WorldMap var4 = ItemWorldMap.getSavedData(var3, var1);
        if (var4 != null) {
            return var4.getUpdatePacket(var3, var2);
        }
        return null;
    }

    @Override
    public void onCraftedBy(ItemStack var0, World var1, EntityHuman var2) {
        NBTTagCompound var3 = var0.getTag();
        if (var3 != null && var3.contains("map_scale_direction", 99)) {
            ItemWorldMap.scaleMap(var0, var1, var3.getInt("map_scale_direction"));
            var3.remove("map_scale_direction");
        } else if (var3 != null && var3.contains("map_to_lock", 1) && var3.getBoolean("map_to_lock")) {
            ItemWorldMap.lockMap(var1, var0);
            var3.remove("map_to_lock");
        }
    }

    private static void scaleMap(ItemStack var0, World var1, int var2) {
        WorldMap var3 = ItemWorldMap.getSavedData(var0, var1);
        if (var3 != null) {
            int var4 = var1.getFreeMapId();
            var1.setMapData(ItemWorldMap.makeKey(var4), var3.scaled(var2));
            ItemWorldMap.storeMapData(var0, var4);
        }
    }

    public static void lockMap(World var0, ItemStack var1) {
        WorldMap var2 = ItemWorldMap.getSavedData(var1, var0);
        if (var2 != null) {
            int var3 = var0.getFreeMapId();
            String var4 = ItemWorldMap.makeKey(var3);
            WorldMap var5 = var2.locked();
            var0.setMapData(var4, var5);
            ItemWorldMap.storeMapData(var1, var3);
        }
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        WorldMap var5;
        Integer var4 = ItemWorldMap.getMapId(var0);
        WorldMap worldMap = var5 = var1 == null ? null : ItemWorldMap.getSavedData(var4, var1);
        if (var5 != null && var5.locked) {
            var2.add(new ChatMessage("filled_map.locked", var4).withStyle(EnumChatFormat.GRAY));
        }
        if (var3.isAdvanced()) {
            if (var5 != null) {
                var2.add(new ChatMessage("filled_map.id", var4).withStyle(EnumChatFormat.GRAY));
                var2.add(new ChatMessage("filled_map.scale", 1 << var5.scale).withStyle(EnumChatFormat.GRAY));
                var2.add(new ChatMessage("filled_map.level", var5.scale, 4).withStyle(EnumChatFormat.GRAY));
            } else {
                var2.add(new ChatMessage("filled_map.unknown").withStyle(EnumChatFormat.GRAY));
            }
        }
    }

    public static int getColor(ItemStack var0) {
        NBTTagCompound var1 = var0.getTagElement("display");
        if (var1 != null && var1.contains("MapColor", 99)) {
            int var2 = var1.getInt("MapColor");
            return 0xFF000000 | var2 & 0xFFFFFF;
        }
        return -12173266;
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        IBlockData var1 = var0.getLevel().getBlockState(var0.getClickedPos());
        if (var1.is(TagsBlock.BANNERS)) {
            WorldMap var2;
            if (!var0.getLevel().isClientSide && (var2 = ItemWorldMap.getSavedData(var0.getItemInHand(), var0.getLevel())) != null && !var2.toggleBanner(var0.getLevel(), var0.getClickedPos())) {
                return EnumInteractionResult.FAIL;
            }
            return EnumInteractionResult.sidedSuccess(var0.getLevel().isClientSide);
        }
        return super.useOn(var0);
    }
}

