/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class ItemMonsterEgg
extends Item {
    private static final Map<EntityTypes<? extends EntityInsentient>, ItemMonsterEgg> BY_ID = Maps.newIdentityHashMap();
    private final int backgroundColor;
    private final int highlightColor;
    private final EntityTypes<?> defaultType;

    public ItemMonsterEgg(EntityTypes<? extends EntityInsentient> var0, int var1, int var2, Item.Info var3) {
        super(var3);
        this.defaultType = var0;
        this.backgroundColor = var1;
        this.highlightColor = var2;
        BY_ID.put(var0, this);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        Object var6;
        World var1 = var0.getLevel();
        if (!(var1 instanceof WorldServer)) {
            return EnumInteractionResult.SUCCESS;
        }
        ItemStack var2 = var0.getItemInHand();
        BlockPosition var3 = var0.getClickedPos();
        EnumDirection var4 = var0.getClickedFace();
        IBlockData var5 = var1.getBlockState(var3);
        if (var5.is(Blocks.SPAWNER) && (var6 = var1.getBlockEntity(var3)) instanceof TileEntityMobSpawner) {
            MobSpawnerAbstract var7 = ((TileEntityMobSpawner)var6).getSpawner();
            EntityTypes<?> var8 = this.getType(var2.getTag());
            var7.setEntityId(var8);
            ((TileEntity)var6).setChanged();
            var1.sendBlockUpdated(var3, var5, var5, 3);
            var2.shrink(1);
            return EnumInteractionResult.CONSUME;
        }
        var6 = var5.getCollisionShape(var1, var3).isEmpty() ? var3 : var3.relative(var4);
        EntityTypes<?> var7 = this.getType(var2.getTag());
        if (var7.spawn((WorldServer)var1, var2, var0.getPlayer(), (BlockPosition)var6, EnumMobSpawn.SPAWN_EGG, true, !Objects.equals(var3, var6) && var4 == EnumDirection.UP) != null) {
            var2.shrink(1);
            var1.gameEvent((Entity)var0.getPlayer(), GameEvent.ENTITY_PLACE, var3);
        }
        return EnumInteractionResult.CONSUME;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        MovingObjectPositionBlock var4 = ItemMonsterEgg.getPlayerPOVHitResult(var0, var1, RayTrace.FluidCollisionOption.SOURCE_ONLY);
        if (((MovingObjectPosition)var4).getType() != MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            return InteractionResultWrapper.pass(var3);
        }
        if (!(var0 instanceof WorldServer)) {
            return InteractionResultWrapper.success(var3);
        }
        MovingObjectPositionBlock var5 = var4;
        BlockPosition var6 = var5.getBlockPos();
        if (!(var0.getBlockState(var6).getBlock() instanceof BlockFluids)) {
            return InteractionResultWrapper.pass(var3);
        }
        if (!var0.mayInteract(var1, var6) || !var1.mayUseItemAt(var6, var5.getDirection(), var3)) {
            return InteractionResultWrapper.fail(var3);
        }
        EntityTypes<?> var7 = this.getType(var3.getTag());
        if (var7.spawn((WorldServer)var0, var3, var1, var6, EnumMobSpawn.SPAWN_EGG, false, false) == null) {
            return InteractionResultWrapper.pass(var3);
        }
        if (!var1.getAbilities().instabuild) {
            var3.shrink(1);
        }
        var1.awardStat(StatisticList.ITEM_USED.get(this));
        var0.gameEvent(GameEvent.ENTITY_PLACE, var1);
        return InteractionResultWrapper.consume(var3);
    }

    public boolean spawnsEntity(@Nullable NBTTagCompound var0, EntityTypes<?> var1) {
        return Objects.equals(this.getType(var0), var1);
    }

    public int getColor(int var0) {
        return var0 == 0 ? this.backgroundColor : this.highlightColor;
    }

    @Nullable
    public static ItemMonsterEgg byId(@Nullable EntityTypes<?> var0) {
        return BY_ID.get(var0);
    }

    public static Iterable<ItemMonsterEgg> eggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }

    public EntityTypes<?> getType(@Nullable NBTTagCompound var0) {
        NBTTagCompound var1;
        if (var0 != null && var0.contains("EntityTag", 10) && (var1 = var0.getCompound("EntityTag")).contains("id", 8)) {
            return EntityTypes.byString(var1.getString("id")).orElse(this.defaultType);
        }
        return this.defaultType;
    }

    public Optional<EntityInsentient> spawnOffspringFromSpawnEgg(EntityHuman var0, EntityInsentient var1, EntityTypes<? extends EntityInsentient> var2, WorldServer var3, Vec3D var4, ItemStack var5) {
        if (!this.spawnsEntity(var5.getTag(), var2)) {
            return Optional.empty();
        }
        EntityInsentient var6 = var1 instanceof EntityAgeable ? ((EntityAgeable)var1).getBreedOffspring(var3, (EntityAgeable)var1) : var2.create(var3);
        if (var6 == null) {
            return Optional.empty();
        }
        var6.setBaby(true);
        if (!var6.isBaby()) {
            return Optional.empty();
        }
        var6.moveTo(var4.x(), var4.y(), var4.z(), 0.0f, 0.0f);
        var3.addFreshEntityWithPassengers(var6);
        if (var5.hasCustomHoverName()) {
            var6.setCustomName(var5.getHoverName());
        }
        if (!var0.getAbilities().instabuild) {
            var5.shrink(1);
        }
        return Optional.of(var6);
    }
}

