/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.ISourceBlock;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemMinecart
extends Item {
    private static final IDispenseBehavior DISPENSE_ITEM_BEHAVIOR = new DispenseBehaviorItem(){
        private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();

        @Override
        public ItemStack execute(ISourceBlock var0, ItemStack var1) {
            Object var15;
            double var13;
            BlockPropertyTrackPosition var12;
            EnumDirection var2 = var0.getBlockState().getValue(BlockDispenser.FACING);
            WorldServer var3 = var0.getLevel();
            double var4 = var0.x() + (double)var2.getStepX() * 1.125;
            double var6 = Math.floor(var0.y()) + (double)var2.getStepY();
            double var8 = var0.z() + (double)var2.getStepZ() * 1.125;
            BlockPosition var10 = var0.getPos().relative(var2);
            IBlockData var11 = var3.getBlockState(var10);
            BlockPropertyTrackPosition blockPropertyTrackPosition = var12 = var11.getBlock() instanceof BlockMinecartTrackAbstract ? var11.getValue(((BlockMinecartTrackAbstract)var11.getBlock()).getShapeProperty()) : BlockPropertyTrackPosition.NORTH_SOUTH;
            if (var11.is(TagsBlock.RAILS)) {
                var13 = var12.isAscending() ? 0.6 : 0.1;
            } else if (var11.isAir() && var3.getBlockState(var10.below()).is(TagsBlock.RAILS)) {
                BlockPropertyTrackPosition var16;
                var15 = var3.getBlockState(var10.below());
                BlockPropertyTrackPosition blockPropertyTrackPosition2 = var16 = ((BlockBase.BlockData)var15).getBlock() instanceof BlockMinecartTrackAbstract ? ((IBlockDataHolder)var15).getValue(((BlockMinecartTrackAbstract)((BlockBase.BlockData)var15).getBlock()).getShapeProperty()) : BlockPropertyTrackPosition.NORTH_SOUTH;
                var13 = var2 == EnumDirection.DOWN || !var16.isAscending() ? -0.9 : -0.4;
            } else {
                return this.defaultDispenseItemBehavior.dispense(var0, var1);
            }
            var15 = EntityMinecartAbstract.createMinecart(var3, var4, var6 + var13, var8, ((ItemMinecart)var1.getItem()).type);
            if (var1.hasCustomHoverName()) {
                ((Entity)var15).setCustomName(var1.getHoverName());
            }
            var3.addFreshEntity((Entity)var15);
            var1.shrink(1);
            return var1;
        }

        @Override
        protected void playSound(ISourceBlock var0) {
            var0.getLevel().levelEvent(1000, var0.getPos(), 0);
        }
    };
    final EntityMinecartAbstract.EnumMinecartType type;

    public ItemMinecart(EntityMinecartAbstract.EnumMinecartType var0, Item.Info var1) {
        super(var1);
        this.type = var0;
        BlockDispenser.registerBehavior(this, DISPENSE_ITEM_BEHAVIOR);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var2;
        World var1 = var0.getLevel();
        IBlockData var3 = var1.getBlockState(var2 = var0.getClickedPos());
        if (!var3.is(TagsBlock.RAILS)) {
            return EnumInteractionResult.FAIL;
        }
        ItemStack var4 = var0.getItemInHand();
        if (!var1.isClientSide) {
            BlockPropertyTrackPosition var5 = var3.getBlock() instanceof BlockMinecartTrackAbstract ? var3.getValue(((BlockMinecartTrackAbstract)var3.getBlock()).getShapeProperty()) : BlockPropertyTrackPosition.NORTH_SOUTH;
            double var6 = 0.0;
            if (var5.isAscending()) {
                var6 = 0.5;
            }
            EntityMinecartAbstract var8 = EntityMinecartAbstract.createMinecart(var1, (double)var2.getX() + 0.5, (double)var2.getY() + 0.0625 + var6, (double)var2.getZ() + 0.5, this.type);
            if (var4.hasCustomHoverName()) {
                var8.setCustomName(var4.getHoverName());
            }
            var1.addFreshEntity(var8);
            var1.gameEvent((Entity)var0.getPlayer(), GameEvent.ENTITY_PLACE, var2);
        }
        var4.shrink(1);
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    }
}

