/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWearable;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;

public class ItemElytra
extends Item
implements ItemWearable {
    public ItemElytra(Item.Info var0) {
        super(var0);
        BlockDispenser.registerBehavior(this, ItemArmor.DISPENSE_ITEM_BEHAVIOR);
    }

    public static boolean isFlyEnabled(ItemStack var0) {
        return var0.getDamageValue() < var0.getMaxDamage() - 1;
    }

    @Override
    public boolean isValidRepairItem(ItemStack var0, ItemStack var1) {
        return var1.is(Items.PHANTOM_MEMBRANE);
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        EnumItemSlot var4 = EntityInsentient.getEquipmentSlotForItem(var3);
        ItemStack var5 = var1.getItemBySlot(var4);
        if (var5.isEmpty()) {
            var1.setItemSlot(var4, var3.copy());
            if (!var0.isClientSide()) {
                var1.awardStat(StatisticList.ITEM_USED.get(this));
            }
            var3.setCount(0);
            return InteractionResultWrapper.sidedSuccess(var3, var0.isClientSide());
        }
        return InteractionResultWrapper.fail(var3);
    }

    @Override
    @Nullable
    public SoundEffect getEquipSound() {
        return SoundEffects.ARMOR_EQUIP_ELYTRA;
    }
}

