/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import javax.annotation.Nullable;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonControllerManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EntityEnderDragon dragon;
    private final IDragonController[] phases = new IDragonController[DragonControllerPhase.getCount()];
    @Nullable
    private IDragonController currentPhase;

    public DragonControllerManager(EntityEnderDragon var0) {
        this.dragon = var0;
        this.setPhase(DragonControllerPhase.HOVERING);
    }

    public void setPhase(DragonControllerPhase<?> var0) {
        if (this.currentPhase != null && var0 == this.currentPhase.getPhase()) {
            return;
        }
        if (this.currentPhase != null) {
            this.currentPhase.end();
        }
        this.currentPhase = this.getPhase(var0);
        if (!this.dragon.level.isClientSide) {
            this.dragon.getEntityData().set(EntityEnderDragon.DATA_PHASE, var0.getId());
        }
        LOGGER.debug("Dragon is now in phase {} on the {}", var0, (Object)(this.dragon.level.isClientSide ? "client" : "server"));
        this.currentPhase.begin();
    }

    public IDragonController getCurrentPhase() {
        return this.currentPhase;
    }

    public <T extends IDragonController> T getPhase(DragonControllerPhase<T> var0) {
        int var1 = var0.getId();
        if (this.phases[var1] == null) {
            this.phases[var1] = var0.createInstance(this.dragon);
        }
        return (T)this.phases[var1];
    }
}

