/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyBedPart;

public class VillagePlaceType {
    private static final Supplier<Set<VillagePlaceType>> ALL_JOB_POI_TYPES = Suppliers.memoize(() -> IRegistry.VILLAGER_PROFESSION.stream().map(VillagerProfession::getJobPoiType).collect(Collectors.toSet()));
    public static final Predicate<VillagePlaceType> ALL_JOBS = var0 -> ALL_JOB_POI_TYPES.get().contains(var0);
    public static final Predicate<VillagePlaceType> ALL = var0 -> true;
    private static final Set<IBlockData> BEDS = (Set)ImmutableList.of((Object)Blocks.RED_BED, (Object)Blocks.BLACK_BED, (Object)Blocks.BLUE_BED, (Object)Blocks.BROWN_BED, (Object)Blocks.CYAN_BED, (Object)Blocks.GRAY_BED, (Object)Blocks.GREEN_BED, (Object)Blocks.LIGHT_BLUE_BED, (Object)Blocks.LIGHT_GRAY_BED, (Object)Blocks.LIME_BED, (Object)Blocks.MAGENTA_BED, (Object)Blocks.ORANGE_BED, (Object[])new Block[]{Blocks.PINK_BED, Blocks.PURPLE_BED, Blocks.WHITE_BED, Blocks.YELLOW_BED}).stream().flatMap(var0 -> var0.getStateDefinition().getPossibleStates().stream()).filter(var0 -> var0.getValue(BlockBed.PART) == BlockPropertyBedPart.HEAD).collect(ImmutableSet.toImmutableSet());
    private static final Set<IBlockData> CAULDRONS = (Set)ImmutableList.of((Object)Blocks.CAULDRON, (Object)Blocks.LAVA_CAULDRON, (Object)Blocks.WATER_CAULDRON, (Object)Blocks.POWDER_SNOW_CAULDRON).stream().flatMap(var0 -> var0.getStateDefinition().getPossibleStates().stream()).collect(ImmutableSet.toImmutableSet());
    private static final Map<IBlockData, VillagePlaceType> TYPE_BY_STATE = Maps.newHashMap();
    public static final VillagePlaceType UNEMPLOYED = VillagePlaceType.register("unemployed", (Set<IBlockData>)ImmutableSet.of(), 1, ALL_JOBS, 1);
    public static final VillagePlaceType ARMORER = VillagePlaceType.register("armorer", VillagePlaceType.getBlockStates(Blocks.BLAST_FURNACE), 1, 1);
    public static final VillagePlaceType BUTCHER = VillagePlaceType.register("butcher", VillagePlaceType.getBlockStates(Blocks.SMOKER), 1, 1);
    public static final VillagePlaceType CARTOGRAPHER = VillagePlaceType.register("cartographer", VillagePlaceType.getBlockStates(Blocks.CARTOGRAPHY_TABLE), 1, 1);
    public static final VillagePlaceType CLERIC = VillagePlaceType.register("cleric", VillagePlaceType.getBlockStates(Blocks.BREWING_STAND), 1, 1);
    public static final VillagePlaceType FARMER = VillagePlaceType.register("farmer", VillagePlaceType.getBlockStates(Blocks.COMPOSTER), 1, 1);
    public static final VillagePlaceType FISHERMAN = VillagePlaceType.register("fisherman", VillagePlaceType.getBlockStates(Blocks.BARREL), 1, 1);
    public static final VillagePlaceType FLETCHER = VillagePlaceType.register("fletcher", VillagePlaceType.getBlockStates(Blocks.FLETCHING_TABLE), 1, 1);
    public static final VillagePlaceType LEATHERWORKER = VillagePlaceType.register("leatherworker", CAULDRONS, 1, 1);
    public static final VillagePlaceType LIBRARIAN = VillagePlaceType.register("librarian", VillagePlaceType.getBlockStates(Blocks.LECTERN), 1, 1);
    public static final VillagePlaceType MASON = VillagePlaceType.register("mason", VillagePlaceType.getBlockStates(Blocks.STONECUTTER), 1, 1);
    public static final VillagePlaceType NITWIT = VillagePlaceType.register("nitwit", (Set<IBlockData>)ImmutableSet.of(), 1, 1);
    public static final VillagePlaceType SHEPHERD = VillagePlaceType.register("shepherd", VillagePlaceType.getBlockStates(Blocks.LOOM), 1, 1);
    public static final VillagePlaceType TOOLSMITH = VillagePlaceType.register("toolsmith", VillagePlaceType.getBlockStates(Blocks.SMITHING_TABLE), 1, 1);
    public static final VillagePlaceType WEAPONSMITH = VillagePlaceType.register("weaponsmith", VillagePlaceType.getBlockStates(Blocks.GRINDSTONE), 1, 1);
    public static final VillagePlaceType HOME = VillagePlaceType.register("home", BEDS, 1, 1);
    public static final VillagePlaceType MEETING = VillagePlaceType.register("meeting", VillagePlaceType.getBlockStates(Blocks.BELL), 32, 6);
    public static final VillagePlaceType BEEHIVE = VillagePlaceType.register("beehive", VillagePlaceType.getBlockStates(Blocks.BEEHIVE), 0, 1);
    public static final VillagePlaceType BEE_NEST = VillagePlaceType.register("bee_nest", VillagePlaceType.getBlockStates(Blocks.BEE_NEST), 0, 1);
    public static final VillagePlaceType NETHER_PORTAL = VillagePlaceType.register("nether_portal", VillagePlaceType.getBlockStates(Blocks.NETHER_PORTAL), 0, 1);
    public static final VillagePlaceType LODESTONE = VillagePlaceType.register("lodestone", VillagePlaceType.getBlockStates(Blocks.LODESTONE), 0, 1);
    public static final VillagePlaceType LIGHTNING_ROD = VillagePlaceType.register("lightning_rod", VillagePlaceType.getBlockStates(Blocks.LIGHTNING_ROD), 0, 1);
    protected static final Set<IBlockData> ALL_STATES = new ObjectOpenHashSet(TYPE_BY_STATE.keySet());
    private final String name;
    private final Set<IBlockData> matchingStates;
    private final int maxTickets;
    private final Predicate<VillagePlaceType> predicate;
    private final int validRange;

    private static Set<IBlockData> getBlockStates(Block var0) {
        return ImmutableSet.copyOf(var0.getStateDefinition().getPossibleStates());
    }

    private VillagePlaceType(String var0, Set<IBlockData> var1, int var2, Predicate<VillagePlaceType> var3, int var4) {
        this.name = var0;
        this.matchingStates = ImmutableSet.copyOf(var1);
        this.maxTickets = var2;
        this.predicate = var3;
        this.validRange = var4;
    }

    private VillagePlaceType(String var02, Set<IBlockData> var1, int var2, int var3) {
        this.name = var02;
        this.matchingStates = ImmutableSet.copyOf(var1);
        this.maxTickets = var2;
        this.predicate = var0 -> var0 == this;
        this.validRange = var3;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxTickets() {
        return this.maxTickets;
    }

    public Predicate<VillagePlaceType> getPredicate() {
        return this.predicate;
    }

    public boolean is(IBlockData var0) {
        return this.matchingStates.contains(var0);
    }

    public int getValidRange() {
        return this.validRange;
    }

    public String toString() {
        return this.name;
    }

    private static VillagePlaceType register(String var0, Set<IBlockData> var1, int var2, int var3) {
        return VillagePlaceType.registerBlockStates(IRegistry.register(IRegistry.POINT_OF_INTEREST_TYPE, new MinecraftKey(var0), new VillagePlaceType(var0, var1, var2, var3)));
    }

    private static VillagePlaceType register(String var0, Set<IBlockData> var1, int var2, Predicate<VillagePlaceType> var3, int var4) {
        return VillagePlaceType.registerBlockStates(IRegistry.register(IRegistry.POINT_OF_INTEREST_TYPE, new MinecraftKey(var0), new VillagePlaceType(var0, var1, var2, var3, var4)));
    }

    private static VillagePlaceType registerBlockStates(VillagePlaceType var0) {
        var0.matchingStates.forEach(var1 -> {
            VillagePlaceType var2 = TYPE_BY_STATE.put((IBlockData)var1, var0);
            if (var2 != null) {
                throw SystemUtils.pauseInIde(new IllegalStateException(String.format("%s is defined in too many tags", var1)));
            }
        });
        return var0;
    }

    public static Optional<VillagePlaceType> forState(IBlockData var0) {
        return Optional.ofNullable(TYPE_BY_STATE.get(var0));
    }
}

