/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;

public class VillagePlaceRecord {
    private final BlockPosition pos;
    private final VillagePlaceType poiType;
    private int freeTickets;
    private final Runnable setDirty;

    public static Codec<VillagePlaceRecord> codec(Runnable var0) {
        return RecordCodecBuilder.create(var1 -> var1.group((App)BlockPosition.CODEC.fieldOf("pos").forGetter(var0 -> var0.pos), (App)IRegistry.POINT_OF_INTEREST_TYPE.byNameCodec().fieldOf("type").forGetter(var0 -> var0.poiType), (App)Codec.INT.fieldOf("free_tickets").orElse((Object)0).forGetter(var0 -> var0.freeTickets), (App)RecordCodecBuilder.point((Object)var0)).apply((Applicative)var1, VillagePlaceRecord::new));
    }

    private VillagePlaceRecord(BlockPosition var0, VillagePlaceType var1, int var2, Runnable var3) {
        this.pos = var0.immutable();
        this.poiType = var1;
        this.freeTickets = var2;
        this.setDirty = var3;
    }

    public VillagePlaceRecord(BlockPosition var0, VillagePlaceType var1, Runnable var2) {
        this(var0, var1, var1.getMaxTickets(), var2);
    }

    @Deprecated
    @VisibleForDebug
    public int getFreeTickets() {
        return this.freeTickets;
    }

    protected boolean acquireTicket() {
        if (this.freeTickets <= 0) {
            return false;
        }
        --this.freeTickets;
        this.setDirty.run();
        return true;
    }

    protected boolean releaseTicket() {
        if (this.freeTickets >= this.poiType.getMaxTickets()) {
            return false;
        }
        ++this.freeTickets;
        this.setDirty.run();
        return true;
    }

    public boolean hasSpace() {
        return this.freeTickets > 0;
    }

    public boolean isOccupied() {
        return this.freeTickets != this.poiType.getMaxTickets();
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public VillagePlaceType getPoiType() {
        return this.poiType;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        return Objects.equals(this.pos, ((VillagePlaceRecord)var0).pos);
    }

    public int hashCode() {
        return this.pos.hashCode();
    }
}

