/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBoat;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalFollowBoat
extends PathfinderGoal {
    private int timeToRecalcPath;
    private final EntityCreature mob;
    @Nullable
    private EntityHuman following;
    private PathfinderGoalBoat currentGoal;

    public PathfinderGoalFollowBoat(EntityCreature var0) {
        this.mob = var0;
    }

    @Override
    public boolean canUse() {
        List<EntityBoat> var0 = this.mob.level.getEntitiesOfClass(EntityBoat.class, this.mob.getBoundingBox().inflate(5.0));
        boolean var1 = false;
        for (EntityBoat var3 : var0) {
            Entity var4 = var3.getControllingPassenger();
            if (!(var4 instanceof EntityHuman) || !(MathHelper.abs(((EntityHuman)var4).xxa) > 0.0f) && !(MathHelper.abs(((EntityHuman)var4).zza) > 0.0f)) continue;
            var1 = true;
            break;
        }
        return this.following != null && (MathHelper.abs(this.following.xxa) > 0.0f || MathHelper.abs(this.following.zza) > 0.0f) || var1;
    }

    @Override
    public boolean isInterruptable() {
        return true;
    }

    @Override
    public boolean canContinueToUse() {
        return this.following != null && this.following.isPassenger() && (MathHelper.abs(this.following.xxa) > 0.0f || MathHelper.abs(this.following.zza) > 0.0f);
    }

    @Override
    public void start() {
        List<EntityBoat> var0 = this.mob.level.getEntitiesOfClass(EntityBoat.class, this.mob.getBoundingBox().inflate(5.0));
        for (EntityBoat var2 : var0) {
            if (var2.getControllingPassenger() == null || !(var2.getControllingPassenger() instanceof EntityHuman)) continue;
            this.following = (EntityHuman)var2.getControllingPassenger();
            break;
        }
        this.timeToRecalcPath = 0;
        this.currentGoal = PathfinderGoalBoat.GO_TO_BOAT;
    }

    @Override
    public void stop() {
        this.following = null;
    }

    @Override
    public void tick() {
        boolean var0;
        boolean bl = var0 = MathHelper.abs(this.following.xxa) > 0.0f || MathHelper.abs(this.following.zza) > 0.0f;
        float var1 = this.currentGoal == PathfinderGoalBoat.GO_IN_BOAT_DIRECTION ? (var0 ? 0.01f : 0.0f) : 0.015f;
        this.mob.moveRelative(var1, new Vec3D(this.mob.xxa, this.mob.yya, this.mob.zza));
        this.mob.move(EnumMoveType.SELF, this.mob.getDeltaMovement());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.adjustedTickDelay(10);
        if (this.currentGoal == PathfinderGoalBoat.GO_TO_BOAT) {
            BlockPosition var2 = this.following.blockPosition().relative(this.following.getDirection().getOpposite());
            var2 = var2.offset(0, -1, 0);
            this.mob.getNavigation().moveTo(var2.getX(), var2.getY(), var2.getZ(), 1.0);
            if (this.mob.distanceTo(this.following) < 4.0f) {
                this.timeToRecalcPath = 0;
                this.currentGoal = PathfinderGoalBoat.GO_IN_BOAT_DIRECTION;
            }
        } else if (this.currentGoal == PathfinderGoalBoat.GO_IN_BOAT_DIRECTION) {
            EnumDirection var2 = this.following.getMotionDirection();
            BlockPosition var3 = this.following.blockPosition().relative(var2, 10);
            this.mob.getNavigation().moveTo(var3.getX(), var3.getY() - 1, var3.getZ(), 1.0);
            if (this.mob.distanceTo(this.following) > 12.0f) {
                this.timeToRecalcPath = 0;
                this.currentGoal = PathfinderGoalBoat.GO_TO_BOAT;
            }
        }
    }
}

