/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.control;

import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;

public class SmoothSwimmingMoveControl
extends ControllerMove {
    private final int maxTurnX;
    private final int maxTurnY;
    private final float inWaterSpeedModifier;
    private final float outsideWaterSpeedModifier;
    private final boolean applyGravity;

    public SmoothSwimmingMoveControl(EntityInsentient var0, int var1, int var2, float var3, float var4, boolean var5) {
        super(var0);
        this.maxTurnX = var1;
        this.maxTurnY = var2;
        this.inWaterSpeedModifier = var3;
        this.outsideWaterSpeedModifier = var4;
        this.applyGravity = var5;
    }

    @Override
    public void tick() {
        double var4;
        double var2;
        if (this.applyGravity && this.mob.isInWater()) {
            this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.005, 0.0));
        }
        if (this.operation != ControllerMove.Operation.MOVE_TO || this.mob.getNavigation().isDone()) {
            this.mob.setSpeed(0.0f);
            this.mob.setXxa(0.0f);
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
            return;
        }
        double var0 = this.wantedX - this.mob.getX();
        double var6 = var0 * var0 + (var2 = this.wantedY - this.mob.getY()) * var2 + (var4 = this.wantedZ - this.mob.getZ()) * var4;
        if (var6 < 2.500000277905201E-7) {
            this.mob.setZza(0.0f);
            return;
        }
        float var8 = (float)(MathHelper.atan2(var4, var0) * 57.2957763671875) - 90.0f;
        this.mob.setYRot(this.rotlerp(this.mob.getYRot(), var8, this.maxTurnY));
        this.mob.yBodyRot = this.mob.getYRot();
        this.mob.yHeadRot = this.mob.getYRot();
        float var9 = (float)(this.speedModifier * this.mob.getAttributeValue(GenericAttributes.MOVEMENT_SPEED));
        if (this.mob.isInWater()) {
            float var12;
            this.mob.setSpeed(var9 * this.inWaterSpeedModifier);
            double var10 = Math.sqrt(var0 * var0 + var4 * var4);
            if (Math.abs(var2) > (double)1.0E-5f || Math.abs(var10) > (double)1.0E-5f) {
                var12 = -((float)(MathHelper.atan2(var2, var10) * 57.2957763671875));
                var12 = MathHelper.clamp(MathHelper.wrapDegrees(var12), (float)(-this.maxTurnX), (float)this.maxTurnX);
                this.mob.setXRot(this.rotlerp(this.mob.getXRot(), var12, 5.0f));
            }
            var12 = MathHelper.cos(this.mob.getXRot() * ((float)Math.PI / 180));
            float var13 = MathHelper.sin(this.mob.getXRot() * ((float)Math.PI / 180));
            this.mob.zza = var12 * var9;
            this.mob.yya = -var13 * var9;
        } else {
            this.mob.setSpeed(var9 * this.outsideWaterSpeedModifier);
        }
    }
}

