/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class TryFindWater
extends Behavior<EntityCreature> {
    private final int range;
    private final float speedModifier;
    private long nextOkStartTime;

    public TryFindWater(int var0, float var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED)));
        this.range = var0;
        this.speedModifier = var1;
    }

    @Override
    protected void stop(WorldServer var0, EntityCreature var1, long var2) {
        this.nextOkStartTime = var2 + 20L + 2L;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        return !var1.level.getFluidState(var1.blockPosition()).is(TagsFluid.WATER);
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var1, long var2) {
        if (var2 < this.nextOkStartTime) {
            return;
        }
        BlockPosition var4 = null;
        BlockPosition var5 = null;
        BlockPosition var6 = var1.blockPosition();
        Iterable<BlockPosition> var7 = BlockPosition.withinManhattan(var6, this.range, this.range, this.range);
        for (BlockPosition var9 : var7) {
            if (var9.getX() == var6.getX() && var9.getZ() == var6.getZ()) continue;
            IBlockData var10 = var1.level.getBlockState(var9.above());
            IBlockData var11 = var1.level.getBlockState(var9);
            if (!var11.is(Blocks.WATER)) continue;
            if (var10.isAir()) {
                var4 = var9.immutable();
                break;
            }
            if (var5 != null || var9.closerThan(var1.position(), 1.5)) continue;
            var5 = var9.immutable();
        }
        if (var4 == null) {
            var4 = var5;
        }
        if (var4 != null) {
            this.nextOkStartTime = var2 + 40L;
            BehaviorUtil.setWalkAndLookTargetMemories((EntityLiving)var1, var4, this.speedModifier, 0);
        }
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityCreature)entityLiving, l2);
    }
}

