/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom2;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class LongJumpToRandomPos<E extends EntityInsentient>
extends Behavior<E> {
    private static final int FIND_JUMP_TRIES = 20;
    private static final int PREPARE_JUMP_DURATION = 40;
    private static final int MIN_PATHFIND_DISTANCE_TO_VALID_JUMP = 8;
    public static final int TIME_OUT_DURATION = 200;
    private final UniformInt timeBetweenLongJumps;
    private final int maxLongJumpHeight;
    private final int maxLongJumpWidth;
    private final float maxJumpVelocity;
    private final List<a> jumpCandidates = new ArrayList<a>();
    private Optional<Vec3D> initialPosition = Optional.empty();
    private Optional<a> chosenJump = Optional.empty();
    private int findJumpTries;
    private long prepareJumpStart;
    private Function<E, SoundEffect> getJumpSound;

    public LongJumpToRandomPos(UniformInt var0, int var1, int var2, float var3, Function<E, SoundEffect> var4) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LONG_JUMP_MID_JUMP, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 200);
        this.timeBetweenLongJumps = var0;
        this.maxLongJumpHeight = var1;
        this.maxLongJumpWidth = var2;
        this.maxJumpVelocity = var3;
        this.getJumpSound = var4;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityInsentient var1) {
        return var1.isOnGround() && !var0.getBlockState(var1.blockPosition()).is(Blocks.HONEY_BLOCK);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityInsentient var1, long var2) {
        boolean var4;
        boolean bl = var4 = this.initialPosition.isPresent() && this.initialPosition.get().equals(var1.position()) && this.findJumpTries > 0 && (this.chosenJump.isPresent() || !this.jumpCandidates.isEmpty());
        if (!var4 && !var1.getBrain().getMemory(MemoryModuleType.LONG_JUMP_MID_JUMP).isPresent()) {
            var1.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, this.timeBetweenLongJumps.sample(var0.random) / 2);
        }
        return var4;
    }

    @Override
    protected void start(WorldServer var0, EntityInsentient var1, long var2) {
        this.chosenJump = Optional.empty();
        this.findJumpTries = 20;
        this.jumpCandidates.clear();
        this.initialPosition = Optional.of(var1.position());
        BlockPosition var4 = var1.blockPosition();
        int var5 = var4.getX();
        int var6 = var4.getY();
        int var7 = var4.getZ();
        Iterable<BlockPosition> var8 = BlockPosition.betweenClosed(var5 - this.maxLongJumpWidth, var6 - this.maxLongJumpHeight, var7 - this.maxLongJumpWidth, var5 + this.maxLongJumpWidth, var6 + this.maxLongJumpHeight, var7 + this.maxLongJumpWidth);
        NavigationAbstract var9 = var1.getNavigation();
        for (BlockPosition var11 : var8) {
            double var12 = var11.distSqr(var4);
            if (var5 == var11.getX() && var7 == var11.getZ() || !var9.isStableDestination(var11) || var1.getPathfindingMalus(PathfinderNormal.getBlockPathTypeStatic(var1.level, var11.mutable())) != 0.0f) continue;
            Optional<Vec3D> var14 = this.calculateOptimalJumpVector(var1, Vec3D.atCenterOf(var11));
            var14.ifPresent(var3 -> this.jumpCandidates.add(new a(new BlockPosition(var11), (Vec3D)var3, MathHelper.ceil(var12))));
        }
    }

    @Override
    protected void tick(WorldServer var0, E var1, long var2) {
        if (this.chosenJump.isPresent()) {
            if (var2 - this.prepareJumpStart >= 40L) {
                ((Entity)var1).setYRot(((EntityInsentient)var1).yBodyRot);
                ((EntityLiving)var1).setDiscardFriction(true);
                Vec3D var4 = this.chosenJump.get().getJumpVector();
                double var5 = var4.length();
                double var7 = var5 + ((EntityLiving)var1).getJumpBoostPower();
                ((Entity)var1).setDeltaMovement(var4.scale(var7 / var5));
                ((EntityLiving)var1).getBrain().setMemory(MemoryModuleType.LONG_JUMP_MID_JUMP, true);
                var0.playSound(null, (Entity)var1, this.getJumpSound.apply(var1), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        } else {
            --this.findJumpTries;
            Optional<a> var4 = WeightedRandom2.getRandomItem(var0.random, this.jumpCandidates);
            if (var4.isPresent()) {
                this.jumpCandidates.remove(var4.get());
                ((EntityLiving)var1).getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorTarget(var4.get().getJumpTarget()));
                NavigationAbstract var5 = ((EntityInsentient)var1).getNavigation();
                PathEntity var6 = var5.createPath(var4.get().getJumpTarget(), 0, 8);
                if (var6 == null || !var6.canReach()) {
                    this.chosenJump = var4;
                    this.prepareJumpStart = var2;
                }
            }
        }
    }

    private Optional<Vec3D> calculateOptimalJumpVector(EntityInsentient var0, Vec3D var1) {
        Optional<Vec3D> var2 = Optional.empty();
        for (int var3 = 65; var3 < 85; var3 += 5) {
            Optional<Vec3D> var4 = this.calculateJumpVectorForAngle(var0, var1, var3);
            if (var2.isPresent() && (!var4.isPresent() || !(var4.get().lengthSqr() < var2.get().lengthSqr()))) continue;
            var2 = var4;
        }
        return var2;
    }

    private Optional<Vec3D> calculateJumpVectorForAngle(EntityInsentient var0, Vec3D var1, int var2) {
        Vec3D var3 = var0.position();
        Vec3D var4 = new Vec3D(var1.x - var3.x, 0.0, var1.z - var3.z).normalize().scale(0.5);
        var1 = var1.subtract(var4);
        Vec3D var5 = var1.subtract(var3);
        float var6 = (float)var2 * (float)Math.PI / 180.0f;
        double var7 = Math.atan2(var5.z, var5.x);
        double var9 = var5.subtract(0.0, var5.y, 0.0).lengthSqr();
        double var11 = Math.sqrt(var9);
        double var13 = var5.y;
        double var15 = Math.sin(2.0f * var6);
        double var17 = 0.08;
        double var19 = Math.pow(Math.cos(var6), 2.0);
        double var21 = Math.sin(var6);
        double var23 = Math.cos(var6);
        double var25 = Math.sin(var7);
        double var27 = Math.cos(var7);
        double var29 = var9 * 0.08 / (var11 * var15 - 2.0 * var13 * var19);
        if (var29 < 0.0) {
            return Optional.empty();
        }
        double var31 = Math.sqrt(var29);
        if (var31 > (double)this.maxJumpVelocity) {
            return Optional.empty();
        }
        double var33 = var31 * var23;
        double var35 = var31 * var21;
        int var37 = MathHelper.ceil(var11 / var33) * 2;
        double var38 = 0.0;
        Vec3D var40 = null;
        for (int var41 = 0; var41 < var37 - 1; ++var41) {
            double var42 = var21 / var23 * (var38 += var11 / (double)var37) - Math.pow(var38, 2.0) * 0.08 / (2.0 * var29 * Math.pow(var23, 2.0));
            double var44 = var38 * var27;
            double var46 = var38 * var25;
            Vec3D var48 = new Vec3D(var3.x + var44, var3.y + var42, var3.z + var46);
            if (var40 != null && !this.isClearTransition(var0, var40, var48)) {
                return Optional.empty();
            }
            var40 = var48;
        }
        return Optional.of(new Vec3D(var33 * var27, var35, var33 * var25).scale(0.95f));
    }

    private boolean isClearTransition(EntityInsentient var0, Vec3D var1, Vec3D var2) {
        EntitySize var3 = var0.getDimensions(EntityPose.LONG_JUMPING);
        Vec3D var4 = var2.subtract(var1);
        double var5 = Math.min(var3.width, var3.height);
        int var7 = MathHelper.ceil(var4.length() / var5);
        Vec3D var8 = var4.normalize();
        Vec3D var9 = var1;
        for (int var10 = 0; var10 < var7; ++var10) {
            var9 = var10 == var7 - 1 ? var2 : var9.add(var8.scale(var5 * (double)0.9f));
            AxisAlignedBB var11 = var3.makeBoundingBox(var9);
            if (var0.level.noCollision(var0, var11)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityInsentient)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (E)((EntityInsentient)entityLiving), l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityInsentient)entityLiving, l2);
    }

    public static class a
    extends WeightedEntry.a {
        private final BlockPosition jumpTarget;
        private final Vec3D jumpVector;

        public a(BlockPosition var0, Vec3D var1, int var2) {
            super(var2);
            this.jumpTarget = var0;
            this.jumpVector = var1;
        }

        public BlockPosition getJumpTarget() {
            return this.jumpTarget;
        }

        public Vec3D getJumpVector() {
            return this.jumpVector;
        }
    }
}

