/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class LongJumpMidJump
extends Behavior<EntityInsentient> {
    public static final int TIME_OUT_DURATION = 100;
    private final UniformInt timeBetweenLongJumps;
    private SoundEffect landingSound;

    public LongJumpMidJump(UniformInt var0, SoundEffect var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LONG_JUMP_MID_JUMP, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 100);
        this.timeBetweenLongJumps = var0;
        this.landingSound = var1;
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityInsentient var1, long var2) {
        return !var1.isOnGround();
    }

    @Override
    protected void start(WorldServer var0, EntityInsentient var1, long var2) {
        var1.setDiscardFriction(true);
        var1.setPose(EntityPose.LONG_JUMPING);
    }

    @Override
    protected void stop(WorldServer var0, EntityInsentient var1, long var2) {
        if (var1.isOnGround()) {
            var1.setDeltaMovement(var1.getDeltaMovement().scale(0.1f));
            var0.playSound(null, var1, this.landingSound, SoundCategory.NEUTRAL, 2.0f, 1.0f);
        }
        var1.setDiscardFriction(false);
        var1.setPose(EntityPose.STANDING);
        var1.getBrain().eraseMemory(MemoryModuleType.LONG_JUMP_MID_JUMP);
        var1.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, this.timeBetweenLongJumps.sample(var0.random));
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityInsentient)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityInsentient)entityLiving, l2);
    }
}

