/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.EntityVillager;

public class BehaviorWork
extends Behavior<EntityVillager> {
    private static final int CHECK_COOLDOWN = 300;
    private static final double DISTANCE = 1.73;
    private long lastCheck;

    public BehaviorWork() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED)));
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityVillager var1) {
        if (var0.getGameTime() - this.lastCheck < 300L) {
            return false;
        }
        if (var0.random.nextInt(2) != 0) {
            return false;
        }
        this.lastCheck = var0.getGameTime();
        GlobalPos var2 = var1.getBrain().getMemory(MemoryModuleType.JOB_SITE).get();
        return var2.dimension() == var0.dimension() && var2.pos().closerThan(var1.position(), 1.73);
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var12, long var2) {
        BehaviorController<EntityVillager> var4 = var12.getBrain();
        var4.setMemory(MemoryModuleType.LAST_WORKED_AT_POI, var2);
        var4.getMemory(MemoryModuleType.JOB_SITE).ifPresent(var1 -> var4.setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorTarget(var1.pos())));
        var12.playWorkSound();
        this.useWorkstation(var0, var12);
        if (var12.shouldRestock()) {
            var12.restock();
        }
    }

    protected void useWorkstation(WorldServer var0, EntityVillager var1) {
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityVillager var1, long var2) {
        Optional<GlobalPos> var4 = var1.getBrain().getMemory(MemoryModuleType.JOB_SITE);
        if (!var4.isPresent()) {
            return false;
        }
        GlobalPos var5 = var4.get();
        return var5.dimension() == var0.dimension() && var5.pos().closerThan(var1.position(), 1.73);
    }

    @Override
    protected /* synthetic */ boolean checkExtraStartConditions(WorldServer worldServer, EntityLiving entityLiving) {
        return this.checkExtraStartConditions(worldServer, (EntityVillager)entityLiving);
    }
}

