/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BehaviorRunIf<E extends EntityLiving>
extends Behavior<E> {
    private final Predicate<E> predicate;
    private final Behavior<? super E> wrappedBehavior;
    private final boolean checkWhileRunningAlso;

    public BehaviorRunIf(Map<MemoryModuleType<?>, MemoryStatus> var0, Predicate<E> var1, Behavior<? super E> var2, boolean var3) {
        super(BehaviorRunIf.mergeMaps(var0, var2.entryCondition));
        this.predicate = var1;
        this.wrappedBehavior = var2;
        this.checkWhileRunningAlso = var3;
    }

    private static Map<MemoryModuleType<?>, MemoryStatus> mergeMaps(Map<MemoryModuleType<?>, MemoryStatus> var0, Map<MemoryModuleType<?>, MemoryStatus> var1) {
        HashMap var2 = Maps.newHashMap();
        var2.putAll(var0);
        var2.putAll(var1);
        return var2;
    }

    public BehaviorRunIf(Predicate<E> var0, Behavior<? super E> var1, boolean var2) {
        this((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(), (Predicate<? super E>)var0, var1, var2);
    }

    public BehaviorRunIf(Predicate<E> var0, Behavior<? super E> var1) {
        this((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(), (Predicate<? super E>)var0, var1, false);
    }

    public BehaviorRunIf(Map<MemoryModuleType<?>, MemoryStatus> var02, Behavior<? super E> var1) {
        this(var02, var0 -> true, var1, false);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        return this.predicate.test(var1) && this.wrappedBehavior.checkExtraStartConditions(var0, var1);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, E var1, long var2) {
        return this.checkWhileRunningAlso && this.predicate.test(var1) && this.wrappedBehavior.canStillUse(var0, var1, var2);
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        this.wrappedBehavior.start(var0, var1, var2);
    }

    @Override
    protected void tick(WorldServer var0, E var1, long var2) {
        this.wrappedBehavior.tick(var0, var1, var2);
    }

    @Override
    protected void stop(WorldServer var0, E var1, long var2) {
        this.wrappedBehavior.stop(var0, var1, var2);
    }

    @Override
    public String toString() {
        return "RunIf: " + this.wrappedBehavior;
    }
}

