/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPosition;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;

public class BehaviorLookWalk
extends Behavior<EntityLiving> {
    private final Function<EntityLiving, Float> speedModifier;
    private final int closeEnoughDistance;
    private final Predicate<EntityLiving> canSetWalkTargetPredicate;

    public BehaviorLookWalk(float var02, int var12) {
        this((EntityLiving var0) -> true, var1 -> Float.valueOf(var02), var12);
    }

    public BehaviorLookWalk(Predicate<EntityLiving> var0, Function<EntityLiving, Float> var1, int var2) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.speedModifier = var1;
        this.closeEnoughDistance = var2;
        this.canSetWalkTargetPredicate = var0;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityLiving var1) {
        return this.canSetWalkTargetPredicate.test(var1);
    }

    @Override
    protected void start(WorldServer var0, EntityLiving var1, long var2) {
        BehaviorController<?> var4 = var1.getBrain();
        BehaviorPosition var5 = var4.getMemory(MemoryModuleType.LOOK_TARGET).get();
        var4.setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var5, this.speedModifier.apply(var1).floatValue(), this.closeEnoughDistance));
    }
}

