/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.EntityItem;

public class BehaviorFindAdmirableItem<E extends EntityLiving>
extends Behavior<E> {
    private final Predicate<E> predicate;
    private final int maxDistToWalk;
    private final float speedModifier;

    public BehaviorFindAdmirableItem(float var02, boolean var1, int var2) {
        this(var0 -> true, var02, var1, var2);
    }

    public BehaviorFindAdmirableItem(Predicate<E> var0, float var1, boolean var2, int var3) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.WALK_TARGET, (Object)((Object)(var2 ? MemoryStatus.REGISTERED : MemoryStatus.VALUE_ABSENT)), MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.predicate = var0;
        this.maxDistToWalk = var3;
        this.speedModifier = var1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        return this.predicate.test(var1) && this.getClosestLovedItem(var1).closerThan((Entity)var1, this.maxDistToWalk);
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        BehaviorUtil.setWalkAndLookTargetMemories(var1, this.getClosestLovedItem(var1), this.speedModifier, 0);
    }

    private EntityItem getClosestLovedItem(E var0) {
        return ((EntityLiving)var0).getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM).get();
    }
}

