/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BehaviorAttackTargetSet<E extends EntityInsentient>
extends Behavior<E> {
    private final Predicate<E> canAttackPredicate;
    private final Function<E, Optional<? extends EntityLiving>> targetFinderFunction;

    public BehaviorAttackTargetSet(Predicate<E> var0, Function<E, Optional<? extends EntityLiving>> var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)((Object)MemoryStatus.REGISTERED)));
        this.canAttackPredicate = var0;
        this.targetFinderFunction = var1;
    }

    public BehaviorAttackTargetSet(Function<E, Optional<? extends EntityLiving>> var02) {
        this((E var0) -> true, var02);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        if (!this.canAttackPredicate.test(var1)) {
            return false;
        }
        Optional<? extends EntityLiving> var2 = this.targetFinderFunction.apply(var1);
        if (var2.isPresent()) {
            return ((EntityLiving)var1).canAttack(var2.get());
        }
        return false;
    }

    @Override
    protected void start(WorldServer var0, E var12, long var2) {
        this.targetFinderFunction.apply(var12).ifPresent(var1 -> this.setAttackTarget(var12, (EntityLiving)var1));
    }

    private void setAttackTarget(E var0, EntityLiving var1) {
        ((EntityLiving)var0).getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, var1);
        ((EntityLiving)var0).getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
    }
}

