/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.EnchantmentProtection;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListenerRegistrar;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Entity
implements INamableTileEntity,
EntityAccess,
ICommandListener {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final String ID_TAG = "id";
    public static final String PASSENGERS_TAG = "Passengers";
    private static final AtomicInteger ENTITY_COUNTER = new AtomicInteger();
    private static final List<ItemStack> EMPTY_LIST = Collections.emptyList();
    public static final int BOARDING_COOLDOWN = 60;
    public static final int TOTAL_AIR_SUPPLY = 300;
    public static final int MAX_ENTITY_TAG_COUNT = 1024;
    public static final double DELTA_AFFECTED_BY_BLOCKS_BELOW = 0.5000001;
    public static final float BREATHING_DISTANCE_BELOW_EYES = 0.11111111f;
    public static final int BASE_TICKS_REQUIRED_TO_FREEZE = 140;
    public static final int FREEZE_HURT_FREQUENCY = 40;
    private static final AxisAlignedBB INITIAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double WATER_FLOW_SCALE = 0.014;
    private static final double LAVA_FAST_FLOW_SCALE = 0.007;
    private static final double LAVA_SLOW_FLOW_SCALE = 0.0023333333333333335;
    public static final String UUID_TAG = "UUID";
    private static double viewScale = 1.0;
    private final EntityTypes<?> type;
    private int id = ENTITY_COUNTER.incrementAndGet();
    public boolean blocksBuilding;
    public ImmutableList<Entity> passengers = ImmutableList.of();
    protected int boardingCooldown;
    @Nullable
    private Entity vehicle;
    public World level;
    public double xo;
    public double yo;
    public double zo;
    private Vec3D position;
    private BlockPosition blockPosition;
    private ChunkCoordIntPair chunkPosition;
    private Vec3D deltaMovement = Vec3D.ZERO;
    private float yRot;
    private float xRot;
    public float yRotO;
    public float xRotO;
    private AxisAlignedBB bb = INITIAL_AABB;
    protected boolean onGround;
    public boolean horizontalCollision;
    public boolean verticalCollision;
    public boolean minorHorizontalCollision;
    public boolean hurtMarked;
    protected Vec3D stuckSpeedMultiplier = Vec3D.ZERO;
    @Nullable
    private RemovalReason removalReason;
    public static final float DEFAULT_BB_WIDTH = 0.6f;
    public static final float DEFAULT_BB_HEIGHT = 1.8f;
    public float walkDistO;
    public float walkDist;
    public float moveDist;
    public float flyDist;
    public float fallDistance;
    private float nextStep = 1.0f;
    public double xOld;
    public double yOld;
    public double zOld;
    public float maxUpStep;
    public boolean noPhysics;
    protected final Random random = new Random();
    public int tickCount;
    public int remainingFireTicks = -this.getFireImmuneTicks();
    public boolean wasTouchingWater;
    protected Object2DoubleMap<Tag<FluidType>> fluidHeight = new Object2DoubleArrayMap(2);
    protected boolean wasEyeInWater;
    @Nullable
    protected Tag<FluidType> fluidOnEyes;
    public int invulnerableTime;
    protected boolean firstTick = true;
    protected final DataWatcher entityData;
    protected static final DataWatcherObject<Byte> DATA_SHARED_FLAGS_ID = DataWatcher.defineId(Entity.class, DataWatcherRegistry.BYTE);
    protected static final int FLAG_ONFIRE = 0;
    private static final int FLAG_SHIFT_KEY_DOWN = 1;
    private static final int FLAG_SPRINTING = 3;
    private static final int FLAG_SWIMMING = 4;
    private static final int FLAG_INVISIBLE = 5;
    protected static final int FLAG_GLOWING = 6;
    protected static final int FLAG_FALL_FLYING = 7;
    private static final DataWatcherObject<Integer> DATA_AIR_SUPPLY_ID = DataWatcher.defineId(Entity.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> DATA_CUSTOM_NAME = DataWatcher.defineId(Entity.class, DataWatcherRegistry.OPTIONAL_COMPONENT);
    private static final DataWatcherObject<Boolean> DATA_CUSTOM_NAME_VISIBLE = DataWatcher.defineId(Entity.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_SILENT = DataWatcher.defineId(Entity.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_NO_GRAVITY = DataWatcher.defineId(Entity.class, DataWatcherRegistry.BOOLEAN);
    protected static final DataWatcherObject<EntityPose> DATA_POSE = DataWatcher.defineId(Entity.class, DataWatcherRegistry.POSE);
    private static final DataWatcherObject<Integer> DATA_TICKS_FROZEN = DataWatcher.defineId(Entity.class, DataWatcherRegistry.INT);
    private EntityInLevelCallback levelCallback = EntityInLevelCallback.NULL;
    private Vec3D packetCoordinates;
    public boolean noCulling;
    public boolean hasImpulse;
    public int portalCooldown;
    protected boolean isInsidePortal;
    protected int portalTime;
    protected BlockPosition portalEntrancePos;
    private boolean invulnerable;
    protected UUID uuid = MathHelper.createInsecureUUID(this.random);
    protected String stringUUID = this.uuid.toString();
    private boolean hasGlowingTag;
    private final Set<String> tags = Sets.newHashSet();
    private final double[] pistonDeltas = new double[]{0.0, 0.0, 0.0};
    private long pistonDeltasGameTime;
    private EntitySize dimensions;
    private float eyeHeight;
    public boolean isInPowderSnow;
    public boolean wasInPowderSnow;
    public boolean wasOnFire;
    private float crystalSoundIntensity;
    private int lastCrystalSoundPlayTick;
    public boolean hasVisualFire;
    @Nullable
    private IBlockData feetBlockState = null;

    public Entity(EntityTypes<?> var0, World var1) {
        this.type = var0;
        this.level = var1;
        this.dimensions = var0.getDimensions();
        this.position = Vec3D.ZERO;
        this.blockPosition = BlockPosition.ZERO;
        this.chunkPosition = ChunkCoordIntPair.ZERO;
        this.packetCoordinates = Vec3D.ZERO;
        this.entityData = new DataWatcher(this);
        this.entityData.define(DATA_SHARED_FLAGS_ID, (byte)0);
        this.entityData.define(DATA_AIR_SUPPLY_ID, this.getMaxAirSupply());
        this.entityData.define(DATA_CUSTOM_NAME_VISIBLE, false);
        this.entityData.define(DATA_CUSTOM_NAME, Optional.empty());
        this.entityData.define(DATA_SILENT, false);
        this.entityData.define(DATA_NO_GRAVITY, false);
        this.entityData.define(DATA_POSE, EntityPose.STANDING);
        this.entityData.define(DATA_TICKS_FROZEN, 0);
        this.defineSynchedData();
        this.setPos(0.0, 0.0, 0.0);
        this.eyeHeight = this.getEyeHeight(EntityPose.STANDING, this.dimensions);
    }

    public boolean isColliding(BlockPosition var0, IBlockData var1) {
        VoxelShape var2 = var1.getCollisionShape(this.level, var0, VoxelShapeCollision.of(this));
        VoxelShape var3 = var2.move(var0.getX(), var0.getY(), var0.getZ());
        return VoxelShapes.joinIsNotEmpty(var3, VoxelShapes.create(this.getBoundingBox()), OperatorBoolean.AND);
    }

    public int getTeamColor() {
        ScoreboardTeamBase var0 = this.getTeam();
        if (var0 != null && var0.getColor().getColor() != null) {
            return var0.getColor().getColor();
        }
        return 0xFFFFFF;
    }

    public boolean isSpectator() {
        return false;
    }

    public final void unRide() {
        if (this.isVehicle()) {
            this.ejectPassengers();
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
    }

    public void setPacketCoordinates(double var0, double var2, double var4) {
        this.setPacketCoordinates(new Vec3D(var0, var2, var4));
    }

    public void setPacketCoordinates(Vec3D var0) {
        this.packetCoordinates = var0;
    }

    public Vec3D getPacketCoordinates() {
        return this.packetCoordinates;
    }

    public EntityTypes<?> getType() {
        return this.type;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int var0) {
        this.id = var0;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean addTag(String var0) {
        if (this.tags.size() >= 1024) {
            return false;
        }
        return this.tags.add(var0);
    }

    public boolean removeTag(String var0) {
        return this.tags.remove(var0);
    }

    public void kill() {
        this.remove(RemovalReason.KILLED);
    }

    public final void discard() {
        this.remove(RemovalReason.DISCARDED);
    }

    protected abstract void defineSynchedData();

    public DataWatcher getEntityData() {
        return this.entityData;
    }

    public boolean equals(Object var0) {
        if (var0 instanceof Entity) {
            return ((Entity)var0).id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public void remove(RemovalReason var0) {
        this.setRemoved(var0);
        if (var0 == RemovalReason.KILLED) {
            this.gameEvent(GameEvent.ENTITY_KILLED);
        }
    }

    public void onClientRemoval() {
    }

    public void setPose(EntityPose var0) {
        this.entityData.set(DATA_POSE, var0);
    }

    public EntityPose getPose() {
        return this.entityData.get(DATA_POSE);
    }

    public boolean closerThan(Entity var0, double var1) {
        double var3 = var0.position.x - this.position.x;
        double var5 = var0.position.y - this.position.y;
        double var7 = var0.position.z - this.position.z;
        return var3 * var3 + var5 * var5 + var7 * var7 < var1 * var1;
    }

    protected void setRot(float var0, float var1) {
        this.setYRot(var0 % 360.0f);
        this.setXRot(var1 % 360.0f);
    }

    public final void setPos(Vec3D var0) {
        this.setPos(var0.x(), var0.y(), var0.z());
    }

    public void setPos(double var0, double var2, double var4) {
        this.setPosRaw(var0, var2, var4);
        this.setBoundingBox(this.makeBoundingBox());
    }

    protected AxisAlignedBB makeBoundingBox() {
        return this.dimensions.makeBoundingBox(this.position);
    }

    protected void reapplyPosition() {
        this.setPos(this.position.x, this.position.y, this.position.z);
    }

    public void turn(double var0, double var2) {
        float var4 = (float)var2 * 0.15f;
        float var5 = (float)var0 * 0.15f;
        this.setXRot(this.getXRot() + var4);
        this.setYRot(this.getYRot() + var5);
        this.setXRot(MathHelper.clamp(this.getXRot(), -90.0f, 90.0f));
        this.xRotO += var4;
        this.yRotO += var5;
        this.xRotO = MathHelper.clamp(this.xRotO, -90.0f, 90.0f);
        if (this.vehicle != null) {
            this.vehicle.onPassengerTurned(this);
        }
    }

    public void tick() {
        this.baseTick();
    }

    public void baseTick() {
        this.level.getProfiler().push("entityBaseTick");
        this.feetBlockState = null;
        if (this.isPassenger() && this.getVehicle().isRemoved()) {
            this.stopRiding();
        }
        if (this.boardingCooldown > 0) {
            --this.boardingCooldown;
        }
        this.walkDistO = this.walkDist;
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.handleNetherPortal();
        if (this.canSpawnSprintParticle()) {
            this.spawnSprintParticle();
        }
        this.wasInPowderSnow = this.isInPowderSnow;
        this.isInPowderSnow = false;
        this.updateInWaterStateAndDoFluidPushing();
        this.updateFluidOnEyes();
        this.updateSwimming();
        if (this.level.isClientSide) {
            this.clearFire();
        } else if (this.remainingFireTicks > 0) {
            if (this.fireImmune()) {
                this.setRemainingFireTicks(this.remainingFireTicks - 4);
                if (this.remainingFireTicks < 0) {
                    this.clearFire();
                }
            } else {
                if (this.remainingFireTicks % 20 == 0 && !this.isInLava()) {
                    this.hurt(DamageSource.ON_FIRE, 1.0f);
                }
                this.setRemainingFireTicks(this.remainingFireTicks - 1);
            }
            if (this.getTicksFrozen() > 0) {
                this.setTicksFrozen(0);
                this.level.levelEvent(null, 1009, this.blockPosition, 1);
            }
        }
        if (this.isInLava()) {
            this.lavaHurt();
            this.fallDistance *= 0.5f;
        }
        this.checkOutOfWorld();
        if (!this.level.isClientSide) {
            this.setSharedFlagOnFire(this.remainingFireTicks > 0);
        }
        this.firstTick = false;
        this.level.getProfiler().pop();
    }

    public void setSharedFlagOnFire(boolean var0) {
        this.setSharedFlag(0, var0 || this.hasVisualFire);
    }

    public void checkOutOfWorld() {
        if (this.getY() < (double)(this.level.getMinBuildHeight() - 64)) {
            this.outOfWorld();
        }
    }

    public void setPortalCooldown() {
        this.portalCooldown = this.getDimensionChangingDelay();
    }

    public boolean isOnPortalCooldown() {
        return this.portalCooldown > 0;
    }

    protected void processPortalCooldown() {
        if (this.isOnPortalCooldown()) {
            --this.portalCooldown;
        }
    }

    public int getPortalWaitTime() {
        return 0;
    }

    public void lavaHurt() {
        if (this.fireImmune()) {
            return;
        }
        this.setSecondsOnFire(15);
        if (this.hurt(DamageSource.LAVA, 4.0f)) {
            this.playSound(SoundEffects.GENERIC_BURN, 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
    }

    public void setSecondsOnFire(int var0) {
        int var1 = var0 * 20;
        if (this instanceof EntityLiving) {
            var1 = EnchantmentProtection.getFireAfterDampener((EntityLiving)this, var1);
        }
        if (this.remainingFireTicks < var1) {
            this.setRemainingFireTicks(var1);
        }
    }

    public void setRemainingFireTicks(int var0) {
        this.remainingFireTicks = var0;
    }

    public int getRemainingFireTicks() {
        return this.remainingFireTicks;
    }

    public void clearFire() {
        this.setRemainingFireTicks(0);
    }

    protected void outOfWorld() {
        this.discard();
    }

    public boolean isFree(double var0, double var2, double var4) {
        return this.isFree(this.getBoundingBox().move(var0, var2, var4));
    }

    private boolean isFree(AxisAlignedBB var0) {
        return this.level.noCollision(this, var0) && !this.level.containsAnyLiquid(var0);
    }

    public void setOnGround(boolean var0) {
        this.onGround = var0;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void move(EnumMoveType var02, Vec3D var1) {
        MovementEmission var7;
        Vec3D var2;
        if (this.noPhysics) {
            this.setPos(this.getX() + var1.x, this.getY() + var1.y, this.getZ() + var1.z);
            return;
        }
        this.wasOnFire = this.isOnFire();
        if (var02 == EnumMoveType.PISTON && (var1 = this.limitPistonMovement(var1)).equals(Vec3D.ZERO)) {
            return;
        }
        this.level.getProfiler().push("move");
        if (this.stuckSpeedMultiplier.lengthSqr() > 1.0E-7) {
            var1 = var1.multiply(this.stuckSpeedMultiplier);
            this.stuckSpeedMultiplier = Vec3D.ZERO;
            this.setDeltaMovement(Vec3D.ZERO);
        }
        if ((var2 = this.collide(var1 = this.maybeBackOffFromEdge(var1, var02))).lengthSqr() > 1.0E-7) {
            this.setPos(this.getX() + var2.x, this.getY() + var2.y, this.getZ() + var2.z);
        }
        this.level.getProfiler().pop();
        this.level.getProfiler().push("rest");
        this.horizontalCollision = !MathHelper.equal(var1.x, var2.x) || !MathHelper.equal(var1.z, var2.z);
        this.verticalCollision = var1.y != var2.y;
        this.minorHorizontalCollision = this.horizontalCollision ? this.isHorizontalCollisionMinor(var2) : false;
        this.onGround = this.verticalCollision && var1.y < 0.0;
        BlockPosition var3 = this.getOnPos();
        IBlockData var4 = this.level.getBlockState(var3);
        this.checkFallDamage(var2.y, this.onGround, var4, var3);
        if (this.isRemoved()) {
            this.level.getProfiler().pop();
            return;
        }
        Vec3D var5 = this.getDeltaMovement();
        if (var1.x != var2.x) {
            this.setDeltaMovement(0.0, var5.y, var5.z);
        }
        if (var1.z != var2.z) {
            this.setDeltaMovement(var5.x, var5.y, 0.0);
        }
        Block var6 = var4.getBlock();
        if (var1.y != var2.y) {
            var6.updateEntityAfterFallOn(this.level, this);
        }
        if (this.onGround && !this.isSteppingCarefully()) {
            var6.stepOn(this.level, var3, var4, this);
        }
        if ((var7 = this.getMovementEmission()).emitsAnything() && !this.isPassenger()) {
            double var8 = var2.x;
            double var10 = var2.y;
            double var12 = var2.z;
            this.flyDist = (float)((double)this.flyDist + var2.length() * 0.6);
            if (!var4.is(TagsBlock.CLIMBABLE) && !var4.is(Blocks.POWDER_SNOW)) {
                var10 = 0.0;
            }
            this.walkDist += (float)var2.horizontalDistance() * 0.6f;
            this.moveDist += (float)Math.sqrt(var8 * var8 + var10 * var10 + var12 * var12) * 0.6f;
            if (this.moveDist > this.nextStep && !var4.isAir()) {
                this.nextStep = this.nextStep();
                if (this.isInWater()) {
                    if (var7.emitsSounds()) {
                        Entity var14 = this.isVehicle() && this.getControllingPassenger() != null ? this.getControllingPassenger() : this;
                        float var15 = var14 == this ? 0.35f : 0.4f;
                        Vec3D var16 = var14.getDeltaMovement();
                        float var17 = Math.min(1.0f, (float)Math.sqrt(var16.x * var16.x * (double)0.2f + var16.y * var16.y + var16.z * var16.z * (double)0.2f) * var15);
                        this.playSwimSound(var17);
                    }
                    if (var7.emitsEvents()) {
                        this.gameEvent(GameEvent.SWIM);
                    }
                } else {
                    if (var7.emitsSounds()) {
                        this.playAmethystStepSound(var4);
                        this.playStepSound(var3, var4);
                    }
                    if (var7.emitsEvents() && !var4.is(TagsBlock.OCCLUDES_VIBRATION_SIGNALS)) {
                        this.gameEvent(GameEvent.STEP);
                    }
                }
            } else if (var4.isAir()) {
                this.processFlappingMovement();
            }
        }
        this.tryCheckInsideBlocks();
        float var8 = this.getBlockSpeedFactor();
        this.setDeltaMovement(this.getDeltaMovement().multiply(var8, 1.0, var8));
        if (this.level.getBlockStatesIfLoaded(this.getBoundingBox().deflate(1.0E-6)).noneMatch(var0 -> var0.is(TagsBlock.FIRE) || var0.is(Blocks.LAVA))) {
            if (this.remainingFireTicks <= 0) {
                this.setRemainingFireTicks(-this.getFireImmuneTicks());
            }
            if (this.wasOnFire && (this.isInPowderSnow || this.isInWaterRainOrBubble())) {
                this.playEntityOnFireExtinguishedSound();
            }
        }
        if (this.isOnFire() && (this.isInPowderSnow || this.isInWaterRainOrBubble())) {
            this.setRemainingFireTicks(-this.getFireImmuneTicks());
        }
        this.level.getProfiler().pop();
    }

    protected boolean isHorizontalCollisionMinor(Vec3D var0) {
        return false;
    }

    protected void tryCheckInsideBlocks() {
        try {
            this.checkInsideBlocks();
        }
        catch (Throwable var0) {
            CrashReport var1 = CrashReport.forThrowable(var0, "Checking entity block collision");
            CrashReportSystemDetails var2 = var1.addCategory("Entity being checked for collision");
            this.fillCrashReportCategory(var2);
            throw new ReportedException(var1);
        }
    }

    protected void playEntityOnFireExtinguishedSound() {
        this.playSound(SoundEffects.GENERIC_EXTINGUISH_FIRE, 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
    }

    protected void processFlappingMovement() {
        if (this.isFlapping()) {
            this.onFlap();
            if (this.getMovementEmission().emitsEvents()) {
                this.gameEvent(GameEvent.FLAP);
            }
        }
    }

    public BlockPosition getOnPos() {
        BlockPosition var4;
        IBlockData var5;
        int var2;
        int var1;
        int var0 = MathHelper.floor(this.position.x);
        BlockPosition var3 = new BlockPosition(var0, var1 = MathHelper.floor(this.position.y - (double)0.2f), var2 = MathHelper.floor(this.position.z));
        if (this.level.getBlockState(var3).isAir() && ((var5 = this.level.getBlockState(var4 = var3.below())).is(TagsBlock.FENCES) || var5.is(TagsBlock.WALLS) || var5.getBlock() instanceof BlockFenceGate)) {
            return var4;
        }
        return var3;
    }

    protected float getBlockJumpFactor() {
        float var0 = this.level.getBlockState(this.blockPosition()).getBlock().getJumpFactor();
        float var1 = this.level.getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getJumpFactor();
        return (double)var0 == 1.0 ? var1 : var0;
    }

    protected float getBlockSpeedFactor() {
        IBlockData var0 = this.level.getBlockState(this.blockPosition());
        float var1 = var0.getBlock().getSpeedFactor();
        if (var0.is(Blocks.WATER) || var0.is(Blocks.BUBBLE_COLUMN)) {
            return var1;
        }
        return (double)var1 == 1.0 ? this.level.getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getSpeedFactor() : var1;
    }

    protected BlockPosition getBlockPosBelowThatAffectsMyMovement() {
        return new BlockPosition(this.position.x, this.getBoundingBox().minY - 0.5000001, this.position.z);
    }

    protected Vec3D maybeBackOffFromEdge(Vec3D var0, EnumMoveType var1) {
        return var0;
    }

    protected Vec3D limitPistonMovement(Vec3D var0) {
        if (var0.lengthSqr() <= 1.0E-7) {
            return var0;
        }
        long var1 = this.level.getGameTime();
        if (var1 != this.pistonDeltasGameTime) {
            Arrays.fill(this.pistonDeltas, 0.0);
            this.pistonDeltasGameTime = var1;
        }
        if (var0.x != 0.0) {
            double var3 = this.applyPistonMovementRestriction(EnumDirection.EnumAxis.X, var0.x);
            return Math.abs(var3) <= (double)1.0E-5f ? Vec3D.ZERO : new Vec3D(var3, 0.0, 0.0);
        }
        if (var0.y != 0.0) {
            double var3 = this.applyPistonMovementRestriction(EnumDirection.EnumAxis.Y, var0.y);
            return Math.abs(var3) <= (double)1.0E-5f ? Vec3D.ZERO : new Vec3D(0.0, var3, 0.0);
        }
        if (var0.z != 0.0) {
            double var3 = this.applyPistonMovementRestriction(EnumDirection.EnumAxis.Z, var0.z);
            return Math.abs(var3) <= (double)1.0E-5f ? Vec3D.ZERO : new Vec3D(0.0, 0.0, var3);
        }
        return Vec3D.ZERO;
    }

    private double applyPistonMovementRestriction(EnumDirection.EnumAxis var0, double var1) {
        int var3 = var0.ordinal();
        double var4 = MathHelper.clamp(var1 + this.pistonDeltas[var3], -0.51, 0.51);
        var1 = var4 - this.pistonDeltas[var3];
        this.pistonDeltas[var3] = var4;
        return var1;
    }

    private Vec3D collide(Vec3D var0) {
        boolean var7;
        AxisAlignedBB var1 = this.getBoundingBox();
        List<VoxelShape> var2 = this.level.getEntityCollisions(this, var1.expandTowards(var0));
        Vec3D var3 = var0.lengthSqr() == 0.0 ? var0 : Entity.collideBoundingBox(this, var0, var1, this.level, var2);
        boolean var4 = var0.x != var3.x;
        boolean var5 = var0.y != var3.y;
        boolean var6 = var0.z != var3.z;
        boolean bl = var7 = this.onGround || var5 && var0.y < 0.0;
        if (this.maxUpStep > 0.0f && var7 && (var4 || var6)) {
            Vec3D var10;
            Vec3D var8 = Entity.collideBoundingBox(this, new Vec3D(var0.x, this.maxUpStep, var0.z), var1, this.level, var2);
            Vec3D var9 = Entity.collideBoundingBox(this, new Vec3D(0.0, this.maxUpStep, 0.0), var1.expandTowards(var0.x, 0.0, var0.z), this.level, var2);
            if (var9.y < (double)this.maxUpStep && (var10 = Entity.collideBoundingBox(this, new Vec3D(var0.x, 0.0, var0.z), var1.move(var9), this.level, var2).add(var9)).horizontalDistanceSqr() > var8.horizontalDistanceSqr()) {
                var8 = var10;
            }
            if (var8.horizontalDistanceSqr() > var3.horizontalDistanceSqr()) {
                return var8.add(Entity.collideBoundingBox(this, new Vec3D(0.0, -var8.y + var0.y, 0.0), var1.move(var8), this.level, var2));
            }
        }
        return var3;
    }

    public static Vec3D collideBoundingBox(@Nullable Entity var0, Vec3D var1, AxisAlignedBB var2, World var3, List<VoxelShape> var4) {
        boolean var7;
        ImmutableList.Builder var5 = ImmutableList.builderWithExpectedSize((int)(var4.size() + 1));
        if (!var4.isEmpty()) {
            var5.addAll(var4);
        }
        WorldBorder var6 = var3.getWorldBorder();
        boolean bl = var7 = var0 != null && var6.isInsideCloseToBorder(var0, var2.expandTowards(var1));
        if (var7) {
            var5.add((Object)var6.getCollisionShape());
        }
        var5.addAll(var3.getBlockCollisions(var0, var2.expandTowards(var1)));
        return Entity.collideWithShapes(var1, var2, (List<VoxelShape>)var5.build());
    }

    private static Vec3D collideWithShapes(Vec3D var0, AxisAlignedBB var1, List<VoxelShape> var2) {
        boolean var9;
        if (var2.isEmpty()) {
            return var0;
        }
        double var3 = var0.x;
        double var5 = var0.y;
        double var7 = var0.z;
        if (var5 != 0.0 && (var5 = VoxelShapes.collide(EnumDirection.EnumAxis.Y, var1, var2, var5)) != 0.0) {
            var1 = var1.move(0.0, var5, 0.0);
        }
        boolean bl = var9 = Math.abs(var3) < Math.abs(var7);
        if (var9 && var7 != 0.0 && (var7 = VoxelShapes.collide(EnumDirection.EnumAxis.Z, var1, var2, var7)) != 0.0) {
            var1 = var1.move(0.0, 0.0, var7);
        }
        if (var3 != 0.0) {
            var3 = VoxelShapes.collide(EnumDirection.EnumAxis.X, var1, var2, var3);
            if (!var9 && var3 != 0.0) {
                var1 = var1.move(var3, 0.0, 0.0);
            }
        }
        if (!var9 && var7 != 0.0) {
            var7 = VoxelShapes.collide(EnumDirection.EnumAxis.Z, var1, var2, var7);
        }
        return new Vec3D(var3, var5, var7);
    }

    protected float nextStep() {
        return (int)this.moveDist + 1;
    }

    protected SoundEffect getSwimSound() {
        return SoundEffects.GENERIC_SWIM;
    }

    protected SoundEffect getSwimSplashSound() {
        return SoundEffects.GENERIC_SPLASH;
    }

    protected SoundEffect getSwimHighSpeedSplashSound() {
        return SoundEffects.GENERIC_SPLASH;
    }

    protected void checkInsideBlocks() {
        AxisAlignedBB var0 = this.getBoundingBox();
        BlockPosition var1 = new BlockPosition(var0.minX + 0.001, var0.minY + 0.001, var0.minZ + 0.001);
        BlockPosition var2 = new BlockPosition(var0.maxX - 0.001, var0.maxY - 0.001, var0.maxZ - 0.001);
        if (this.level.hasChunksAt(var1, var2)) {
            BlockPosition.MutableBlockPosition var3 = new BlockPosition.MutableBlockPosition();
            for (int var4 = var1.getX(); var4 <= var2.getX(); ++var4) {
                for (int var5 = var1.getY(); var5 <= var2.getY(); ++var5) {
                    for (int var6 = var1.getZ(); var6 <= var2.getZ(); ++var6) {
                        var3.set(var4, var5, var6);
                        IBlockData var7 = this.level.getBlockState(var3);
                        try {
                            var7.entityInside(this.level, var3, this);
                            this.onInsideBlock(var7);
                            continue;
                        }
                        catch (Throwable var8) {
                            CrashReport var9 = CrashReport.forThrowable(var8, "Colliding entity with block");
                            CrashReportSystemDetails var10 = var9.addCategory("Block being collided with");
                            CrashReportSystemDetails.populateBlockDetails(var10, this.level, var3, var7);
                            throw new ReportedException(var9);
                        }
                    }
                }
            }
        }
    }

    protected void onInsideBlock(IBlockData var0) {
    }

    public void gameEvent(GameEvent var0, @Nullable Entity var1, BlockPosition var2) {
        this.level.gameEvent(var1, var0, var2);
    }

    public void gameEvent(GameEvent var0, @Nullable Entity var1) {
        this.gameEvent(var0, var1, this.blockPosition);
    }

    public void gameEvent(GameEvent var0, BlockPosition var1) {
        this.gameEvent(var0, this, var1);
    }

    public void gameEvent(GameEvent var0) {
        this.gameEvent(var0, this.blockPosition);
    }

    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        if (var1.getMaterial().isLiquid()) {
            return;
        }
        IBlockData var2 = this.level.getBlockState(var0.above());
        SoundEffectType var3 = var2.is(TagsBlock.INSIDE_STEP_SOUND_BLOCKS) ? var2.getSoundType() : var1.getSoundType();
        this.playSound(var3.getStepSound(), var3.getVolume() * 0.15f, var3.getPitch());
    }

    private void playAmethystStepSound(IBlockData var0) {
        if (var0.is(TagsBlock.CRYSTAL_SOUND_BLOCKS) && this.tickCount >= this.lastCrystalSoundPlayTick + 20) {
            this.crystalSoundIntensity = (float)((double)this.crystalSoundIntensity * Math.pow(0.997f, this.tickCount - this.lastCrystalSoundPlayTick));
            this.crystalSoundIntensity = Math.min(1.0f, this.crystalSoundIntensity + 0.07f);
            float var1 = 0.5f + this.crystalSoundIntensity * this.random.nextFloat() * 1.2f;
            float var2 = 0.1f + this.crystalSoundIntensity * 1.2f;
            this.playSound(SoundEffects.AMETHYST_BLOCK_CHIME, var2, var1);
            this.lastCrystalSoundPlayTick = this.tickCount;
        }
    }

    protected void playSwimSound(float var0) {
        this.playSound(this.getSwimSound(), var0, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
    }

    protected void onFlap() {
    }

    protected boolean isFlapping() {
        return false;
    }

    public void playSound(SoundEffect var0, float var1, float var2) {
        if (!this.isSilent()) {
            this.level.playSound(null, this.getX(), this.getY(), this.getZ(), var0, this.getSoundSource(), var1, var2);
        }
    }

    public boolean isSilent() {
        return this.entityData.get(DATA_SILENT);
    }

    public void setSilent(boolean var0) {
        this.entityData.set(DATA_SILENT, var0);
    }

    public boolean isNoGravity() {
        return this.entityData.get(DATA_NO_GRAVITY);
    }

    public void setNoGravity(boolean var0) {
        this.entityData.set(DATA_NO_GRAVITY, var0);
    }

    protected MovementEmission getMovementEmission() {
        return MovementEmission.ALL;
    }

    public boolean occludesVibrations() {
        return false;
    }

    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
        if (var2) {
            if (this.fallDistance > 0.0f) {
                var3.getBlock().fallOn(this.level, var3, var4, this, this.fallDistance);
                if (!var3.is(TagsBlock.OCCLUDES_VIBRATION_SIGNALS)) {
                    this.gameEvent(GameEvent.HIT_GROUND);
                }
            }
            this.resetFallDistance();
        } else if (var0 < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - var0);
        }
    }

    public boolean fireImmune() {
        return this.getType().fireImmune();
    }

    public boolean causeFallDamage(float var0, float var1, DamageSource var2) {
        if (this.isVehicle()) {
            for (Entity var4 : this.getPassengers()) {
                var4.causeFallDamage(var0, var1, var2);
            }
        }
        return false;
    }

    public boolean isInWater() {
        return this.wasTouchingWater;
    }

    private boolean isInRain() {
        BlockPosition var0 = this.blockPosition();
        return this.level.isRainingAt(var0) || this.level.isRainingAt(new BlockPosition((double)var0.getX(), this.getBoundingBox().maxY, (double)var0.getZ()));
    }

    private boolean isInBubbleColumn() {
        return this.level.getBlockState(this.blockPosition()).is(Blocks.BUBBLE_COLUMN);
    }

    public boolean isInWaterOrRain() {
        return this.isInWater() || this.isInRain();
    }

    public boolean isInWaterRainOrBubble() {
        return this.isInWater() || this.isInRain() || this.isInBubbleColumn();
    }

    public boolean isInWaterOrBubble() {
        return this.isInWater() || this.isInBubbleColumn();
    }

    public boolean isUnderWater() {
        return this.wasEyeInWater && this.isInWater();
    }

    public void updateSwimming() {
        if (this.isSwimming()) {
            this.setSwimming(this.isSprinting() && this.isInWater() && !this.isPassenger());
        } else {
            this.setSwimming(this.isSprinting() && this.isUnderWater() && !this.isPassenger() && this.level.getFluidState(this.blockPosition).is(TagsFluid.WATER));
        }
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        this.fluidHeight.clear();
        this.updateInWaterStateAndDoWaterCurrentPushing();
        double var0 = this.level.dimensionType().ultraWarm() ? 0.007 : 0.0023333333333333335;
        boolean var2 = this.updateFluidHeightAndDoFluidPushing(TagsFluid.LAVA, var0);
        return this.isInWater() || var2;
    }

    void updateInWaterStateAndDoWaterCurrentPushing() {
        if (this.getVehicle() instanceof EntityBoat) {
            this.wasTouchingWater = false;
        } else if (this.updateFluidHeightAndDoFluidPushing(TagsFluid.WATER, 0.014)) {
            if (!this.wasTouchingWater && !this.firstTick) {
                this.doWaterSplashEffect();
            }
            this.resetFallDistance();
            this.wasTouchingWater = true;
            this.clearFire();
        } else {
            this.wasTouchingWater = false;
        }
    }

    private void updateFluidOnEyes() {
        Object var3;
        this.wasEyeInWater = this.isEyeInFluid(TagsFluid.WATER);
        this.fluidOnEyes = null;
        double var0 = this.getEyeY() - 0.1111111119389534;
        Entity var2 = this.getVehicle();
        if (var2 instanceof EntityBoat && !((EntityBoat)(var3 = (EntityBoat)var2)).isUnderWater() && ((Entity)var3).getBoundingBox().maxY >= var0 && ((Entity)var3).getBoundingBox().minY <= var0) {
            return;
        }
        var3 = new BlockPosition(this.getX(), var0, this.getZ());
        Fluid var4 = this.level.getFluidState((BlockPosition)var3);
        for (Tag<FluidType> var6 : TagsFluid.getStaticTags()) {
            if (!var4.is(var6)) continue;
            double var7 = (float)((BaseBlockPosition)var3).getY() + var4.getHeight(this.level, (BlockPosition)var3);
            if (var7 > var0) {
                this.fluidOnEyes = var6;
            }
            return;
        }
    }

    protected void doWaterSplashEffect() {
        double var8;
        double var6;
        Entity var0 = this.isVehicle() && this.getControllingPassenger() != null ? this.getControllingPassenger() : this;
        float var1 = var0 == this ? 0.2f : 0.9f;
        Vec3D var2 = var0.getDeltaMovement();
        float var3 = Math.min(1.0f, (float)Math.sqrt(var2.x * var2.x * (double)0.2f + var2.y * var2.y + var2.z * var2.z * (double)0.2f) * var1);
        if (var3 < 0.25f) {
            this.playSound(this.getSwimSplashSound(), var3, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        } else {
            this.playSound(this.getSwimHighSpeedSplashSound(), var3, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        }
        float var4 = MathHelper.floor(this.getY());
        int var5 = 0;
        while ((float)var5 < 1.0f + this.dimensions.width * 20.0f) {
            var6 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width;
            var8 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width;
            this.level.addParticle(Particles.BUBBLE, this.getX() + var6, var4 + 1.0f, this.getZ() + var8, var2.x, var2.y - this.random.nextDouble() * (double)0.2f, var2.z);
            ++var5;
        }
        var5 = 0;
        while ((float)var5 < 1.0f + this.dimensions.width * 20.0f) {
            var6 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width;
            var8 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width;
            this.level.addParticle(Particles.SPLASH, this.getX() + var6, var4 + 1.0f, this.getZ() + var8, var2.x, var2.y, var2.z);
            ++var5;
        }
        this.gameEvent(GameEvent.SPLASH);
    }

    protected IBlockData getBlockStateOn() {
        return this.level.getBlockState(this.getOnPos());
    }

    public boolean canSpawnSprintParticle() {
        return this.isSprinting() && !this.isInWater() && !this.isSpectator() && !this.isCrouching() && !this.isInLava() && this.isAlive();
    }

    protected void spawnSprintParticle() {
        int var2;
        int var1;
        int var0 = MathHelper.floor(this.getX());
        BlockPosition var3 = new BlockPosition(var0, var1 = MathHelper.floor(this.getY() - (double)0.2f), var2 = MathHelper.floor(this.getZ()));
        IBlockData var4 = this.level.getBlockState(var3);
        if (var4.getRenderShape() != EnumRenderType.INVISIBLE) {
            Vec3D var5 = this.getDeltaMovement();
            this.level.addParticle(new ParticleParamBlock(Particles.BLOCK, var4), this.getX() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width, this.getY() + 0.1, this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width, var5.x * -4.0, 1.5, var5.z * -4.0);
        }
    }

    public boolean isEyeInFluid(Tag<FluidType> var0) {
        return this.fluidOnEyes == var0;
    }

    public boolean isInLava() {
        return !this.firstTick && this.fluidHeight.getDouble(TagsFluid.LAVA) > 0.0;
    }

    public void moveRelative(float var0, Vec3D var1) {
        Vec3D var2 = Entity.getInputVector(var1, var0, this.getYRot());
        this.setDeltaMovement(this.getDeltaMovement().add(var2));
    }

    private static Vec3D getInputVector(Vec3D var0, float var1, float var2) {
        double var3 = var0.lengthSqr();
        if (var3 < 1.0E-7) {
            return Vec3D.ZERO;
        }
        Vec3D var5 = (var3 > 1.0 ? var0.normalize() : var0).scale(var1);
        float var6 = MathHelper.sin(var2 * ((float)Math.PI / 180));
        float var7 = MathHelper.cos(var2 * ((float)Math.PI / 180));
        return new Vec3D(var5.x * (double)var7 - var5.z * (double)var6, var5.y, var5.z * (double)var7 + var5.x * (double)var6);
    }

    public float getBrightness() {
        if (this.level.hasChunkAt(this.getBlockX(), this.getBlockZ())) {
            return this.level.getBrightness(new BlockPosition(this.getX(), this.getEyeY(), this.getZ()));
        }
        return 0.0f;
    }

    public void absMoveTo(double var0, double var2, double var4, float var6, float var7) {
        this.absMoveTo(var0, var2, var4);
        this.setYRot(var6 % 360.0f);
        this.setXRot(MathHelper.clamp(var7, -90.0f, 90.0f) % 360.0f);
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void absMoveTo(double var0, double var2, double var4) {
        double var6 = MathHelper.clamp(var0, -3.0E7, 3.0E7);
        double var8 = MathHelper.clamp(var4, -3.0E7, 3.0E7);
        this.xo = var6;
        this.yo = var2;
        this.zo = var8;
        this.setPos(var6, var2, var8);
    }

    public void moveTo(Vec3D var0) {
        this.moveTo(var0.x, var0.y, var0.z);
    }

    public void moveTo(double var0, double var2, double var4) {
        this.moveTo(var0, var2, var4, this.getYRot(), this.getXRot());
    }

    public void moveTo(BlockPosition var0, float var1, float var2) {
        this.moveTo((double)var0.getX() + 0.5, var0.getY(), (double)var0.getZ() + 0.5, var1, var2);
    }

    public void moveTo(double var0, double var2, double var4, float var6, float var7) {
        this.setPosRaw(var0, var2, var4);
        this.setYRot(var6);
        this.setXRot(var7);
        this.setOldPosAndRot();
        this.reapplyPosition();
    }

    public final void setOldPosAndRot() {
        double var0 = this.getX();
        double var2 = this.getY();
        double var4 = this.getZ();
        this.xo = var0;
        this.yo = var2;
        this.zo = var4;
        this.xOld = var0;
        this.yOld = var2;
        this.zOld = var4;
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public float distanceTo(Entity var0) {
        float var1 = (float)(this.getX() - var0.getX());
        float var2 = (float)(this.getY() - var0.getY());
        float var3 = (float)(this.getZ() - var0.getZ());
        return MathHelper.sqrt(var1 * var1 + var2 * var2 + var3 * var3);
    }

    public double distanceToSqr(double var0, double var2, double var4) {
        double var6 = this.getX() - var0;
        double var8 = this.getY() - var2;
        double var10 = this.getZ() - var4;
        return var6 * var6 + var8 * var8 + var10 * var10;
    }

    public double distanceToSqr(Entity var0) {
        return this.distanceToSqr(var0.position());
    }

    public double distanceToSqr(Vec3D var0) {
        double var1 = this.getX() - var0.x;
        double var3 = this.getY() - var0.y;
        double var5 = this.getZ() - var0.z;
        return var1 * var1 + var3 * var3 + var5 * var5;
    }

    public void playerTouch(EntityHuman var0) {
    }

    public void push(Entity var0) {
        double var3;
        if (this.isPassengerOfSameVehicle(var0)) {
            return;
        }
        if (var0.noPhysics || this.noPhysics) {
            return;
        }
        double var1 = var0.getX() - this.getX();
        double var5 = MathHelper.absMax(var1, var3 = var0.getZ() - this.getZ());
        if (var5 >= (double)0.01f) {
            var5 = Math.sqrt(var5);
            var1 /= var5;
            var3 /= var5;
            double var7 = 1.0 / var5;
            if (var7 > 1.0) {
                var7 = 1.0;
            }
            var1 *= var7;
            var3 *= var7;
            var1 *= (double)0.05f;
            var3 *= (double)0.05f;
            if (!this.isVehicle()) {
                this.push(-var1, 0.0, -var3);
            }
            if (!var0.isVehicle()) {
                var0.push(var1, 0.0, var3);
            }
        }
    }

    public void push(double var0, double var2, double var4) {
        this.setDeltaMovement(this.getDeltaMovement().add(var0, var2, var4));
        this.hasImpulse = true;
    }

    protected void markHurt() {
        this.hurtMarked = true;
    }

    public boolean hurt(DamageSource var0, float var1) {
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        this.markHurt();
        return false;
    }

    public final Vec3D getViewVector(float var0) {
        return this.calculateViewVector(this.getViewXRot(var0), this.getViewYRot(var0));
    }

    public float getViewXRot(float var0) {
        if (var0 == 1.0f) {
            return this.getXRot();
        }
        return MathHelper.lerp(var0, this.xRotO, this.getXRot());
    }

    public float getViewYRot(float var0) {
        if (var0 == 1.0f) {
            return this.getYRot();
        }
        return MathHelper.lerp(var0, this.yRotO, this.getYRot());
    }

    protected final Vec3D calculateViewVector(float var0, float var1) {
        float var2 = var0 * ((float)Math.PI / 180);
        float var3 = -var1 * ((float)Math.PI / 180);
        float var4 = MathHelper.cos(var3);
        float var5 = MathHelper.sin(var3);
        float var6 = MathHelper.cos(var2);
        float var7 = MathHelper.sin(var2);
        return new Vec3D(var5 * var6, -var7, var4 * var6);
    }

    public final Vec3D getUpVector(float var0) {
        return this.calculateUpVector(this.getViewXRot(var0), this.getViewYRot(var0));
    }

    protected final Vec3D calculateUpVector(float var0, float var1) {
        return this.calculateViewVector(var0 - 90.0f, var1);
    }

    public final Vec3D getEyePosition() {
        return new Vec3D(this.getX(), this.getEyeY(), this.getZ());
    }

    public final Vec3D getEyePosition(float var0) {
        double var1 = MathHelper.lerp((double)var0, this.xo, this.getX());
        double var3 = MathHelper.lerp((double)var0, this.yo, this.getY()) + (double)this.getEyeHeight();
        double var5 = MathHelper.lerp((double)var0, this.zo, this.getZ());
        return new Vec3D(var1, var3, var5);
    }

    public Vec3D getLightProbePosition(float var0) {
        return this.getEyePosition(var0);
    }

    public final Vec3D getPosition(float var0) {
        double var1 = MathHelper.lerp((double)var0, this.xo, this.getX());
        double var3 = MathHelper.lerp((double)var0, this.yo, this.getY());
        double var5 = MathHelper.lerp((double)var0, this.zo, this.getZ());
        return new Vec3D(var1, var3, var5);
    }

    public MovingObjectPosition pick(double var0, float var2, boolean var3) {
        Vec3D var4 = this.getEyePosition(var2);
        Vec3D var5 = this.getViewVector(var2);
        Vec3D var6 = var4.add(var5.x * var0, var5.y * var0, var5.z * var0);
        return this.level.clip(new RayTrace(var4, var6, RayTrace.BlockCollisionOption.OUTLINE, var3 ? RayTrace.FluidCollisionOption.ANY : RayTrace.FluidCollisionOption.NONE, this));
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public void awardKillScore(Entity var0, int var1, DamageSource var2) {
        if (var0 instanceof EntityPlayer) {
            CriterionTriggers.ENTITY_KILLED_PLAYER.trigger((EntityPlayer)var0, this, var2);
        }
    }

    public boolean shouldRender(double var0, double var2, double var4) {
        double var6 = this.getX() - var0;
        double var8 = this.getY() - var2;
        double var10 = this.getZ() - var4;
        double var12 = var6 * var6 + var8 * var8 + var10 * var10;
        return this.shouldRenderAtSqrDistance(var12);
    }

    public boolean shouldRenderAtSqrDistance(double var0) {
        double var2 = this.getBoundingBox().getSize();
        if (Double.isNaN(var2)) {
            var2 = 1.0;
        }
        return var0 < (var2 *= 64.0 * viewScale) * var2;
    }

    public boolean saveAsPassenger(NBTTagCompound var0) {
        if (this.removalReason != null && !this.removalReason.shouldSave()) {
            return false;
        }
        String var1 = this.getEncodeId();
        if (var1 == null) {
            return false;
        }
        var0.putString(ID_TAG, var1);
        this.saveWithoutId(var0);
        return true;
    }

    public boolean save(NBTTagCompound var0) {
        if (this.isPassenger()) {
            return false;
        }
        return this.saveAsPassenger(var0);
    }

    public NBTTagCompound saveWithoutId(NBTTagCompound var0) {
        try {
            NBTTagList var4;
            int var3;
            if (this.vehicle != null) {
                var0.put("Pos", this.newDoubleList(this.vehicle.getX(), this.getY(), this.vehicle.getZ()));
            } else {
                var0.put("Pos", this.newDoubleList(this.getX(), this.getY(), this.getZ()));
            }
            Vec3D var1 = this.getDeltaMovement();
            var0.put("Motion", this.newDoubleList(var1.x, var1.y, var1.z));
            var0.put("Rotation", this.newFloatList(this.getYRot(), this.getXRot()));
            var0.putFloat("FallDistance", this.fallDistance);
            var0.putShort("Fire", (short)this.remainingFireTicks);
            var0.putShort("Air", (short)this.getAirSupply());
            var0.putBoolean("OnGround", this.onGround);
            var0.putBoolean("Invulnerable", this.invulnerable);
            var0.putInt("PortalCooldown", this.portalCooldown);
            var0.putUUID(UUID_TAG, this.getUUID());
            IChatBaseComponent var2 = this.getCustomName();
            if (var2 != null) {
                var0.putString("CustomName", IChatBaseComponent.ChatSerializer.toJson(var2));
            }
            if (this.isCustomNameVisible()) {
                var0.putBoolean("CustomNameVisible", this.isCustomNameVisible());
            }
            if (this.isSilent()) {
                var0.putBoolean("Silent", this.isSilent());
            }
            if (this.isNoGravity()) {
                var0.putBoolean("NoGravity", this.isNoGravity());
            }
            if (this.hasGlowingTag) {
                var0.putBoolean("Glowing", true);
            }
            if ((var3 = this.getTicksFrozen()) > 0) {
                var0.putInt("TicksFrozen", this.getTicksFrozen());
            }
            if (this.hasVisualFire) {
                var0.putBoolean("HasVisualFire", this.hasVisualFire);
            }
            if (!this.tags.isEmpty()) {
                var4 = new NBTTagList();
                for (String string : this.tags) {
                    var4.add(NBTTagString.valueOf(string));
                }
                var0.put("Tags", var4);
            }
            this.addAdditionalSaveData(var0);
            if (this.isVehicle()) {
                var4 = new NBTTagList();
                for (Entity entity : this.getPassengers()) {
                    NBTTagCompound var7;
                    if (!entity.saveAsPassenger(var7 = new NBTTagCompound())) continue;
                    var4.add(var7);
                }
                if (!var4.isEmpty()) {
                    var0.put(PASSENGERS_TAG, var4);
                }
            }
        }
        catch (Throwable var1) {
            CrashReport var2 = CrashReport.forThrowable(var1, "Saving entity NBT");
            CrashReportSystemDetails var3 = var2.addCategory("Entity being saved");
            this.fillCrashReportCategory(var3);
            throw new ReportedException(var2);
        }
        return var0;
    }

    public void load(NBTTagCompound var0) {
        try {
            Object var10;
            NBTTagList var1 = var0.getList("Pos", 6);
            NBTTagList var2 = var0.getList("Motion", 6);
            NBTTagList var3 = var0.getList("Rotation", 5);
            double var4 = var2.getDouble(0);
            double var6 = var2.getDouble(1);
            double var8 = var2.getDouble(2);
            this.setDeltaMovement(Math.abs(var4) > 10.0 ? 0.0 : var4, Math.abs(var6) > 10.0 ? 0.0 : var6, Math.abs(var8) > 10.0 ? 0.0 : var8);
            this.setPosRaw(var1.getDouble(0), MathHelper.clamp(var1.getDouble(1), -2.0E7, 2.0E7), var1.getDouble(2));
            this.setYRot(var3.getFloat(0));
            this.setXRot(var3.getFloat(1));
            this.setOldPosAndRot();
            this.setYHeadRot(this.getYRot());
            this.setYBodyRot(this.getYRot());
            this.fallDistance = var0.getFloat("FallDistance");
            this.remainingFireTicks = var0.getShort("Fire");
            if (var0.contains("Air")) {
                this.setAirSupply(var0.getShort("Air"));
            }
            this.onGround = var0.getBoolean("OnGround");
            this.invulnerable = var0.getBoolean("Invulnerable");
            this.portalCooldown = var0.getInt("PortalCooldown");
            if (var0.hasUUID(UUID_TAG)) {
                this.uuid = var0.getUUID(UUID_TAG);
                this.stringUUID = this.uuid.toString();
            }
            if (!(Double.isFinite(this.getX()) && Double.isFinite(this.getY()) && Double.isFinite(this.getZ()))) {
                throw new IllegalStateException("Entity has invalid position");
            }
            if (!Double.isFinite(this.getYRot()) || !Double.isFinite(this.getXRot())) {
                throw new IllegalStateException("Entity has invalid rotation");
            }
            this.reapplyPosition();
            this.setRot(this.getYRot(), this.getXRot());
            if (var0.contains("CustomName", 8)) {
                var10 = var0.getString("CustomName");
                try {
                    this.setCustomName(IChatBaseComponent.ChatSerializer.fromJson((String)var10));
                }
                catch (Exception var11) {
                    LOGGER.warn("Failed to parse entity custom name {}", var10, (Object)var11);
                }
            }
            this.setCustomNameVisible(var0.getBoolean("CustomNameVisible"));
            this.setSilent(var0.getBoolean("Silent"));
            this.setNoGravity(var0.getBoolean("NoGravity"));
            this.setGlowingTag(var0.getBoolean("Glowing"));
            this.setTicksFrozen(var0.getInt("TicksFrozen"));
            this.hasVisualFire = var0.getBoolean("HasVisualFire");
            if (var0.contains("Tags", 9)) {
                this.tags.clear();
                var10 = var0.getList("Tags", 8);
                int var11 = Math.min(((NBTTagList)var10).size(), 1024);
                for (int var12 = 0; var12 < var11; ++var12) {
                    this.tags.add(((NBTTagList)var10).getString(var12));
                }
            }
            this.readAdditionalSaveData(var0);
            if (this.repositionEntityAfterLoad()) {
                this.reapplyPosition();
            }
        }
        catch (Throwable var1) {
            CrashReport var2 = CrashReport.forThrowable(var1, "Loading entity NBT");
            CrashReportSystemDetails var3 = var2.addCategory("Entity being loaded");
            this.fillCrashReportCategory(var3);
            throw new ReportedException(var2);
        }
    }

    protected boolean repositionEntityAfterLoad() {
        return true;
    }

    @Nullable
    public final String getEncodeId() {
        EntityTypes<?> var0 = this.getType();
        MinecraftKey var1 = EntityTypes.getKey(var0);
        return !var0.canSerialize() || var1 == null ? null : var1.toString();
    }

    protected abstract void readAdditionalSaveData(NBTTagCompound var1);

    protected abstract void addAdditionalSaveData(NBTTagCompound var1);

    protected NBTTagList newDoubleList(double ... var0) {
        NBTTagList var1 = new NBTTagList();
        for (double var5 : var0) {
            var1.add(NBTTagDouble.valueOf(var5));
        }
        return var1;
    }

    protected NBTTagList newFloatList(float ... var0) {
        NBTTagList var1 = new NBTTagList();
        for (float var5 : var0) {
            var1.add(NBTTagFloat.valueOf(var5));
        }
        return var1;
    }

    @Nullable
    public EntityItem spawnAtLocation(IMaterial var0) {
        return this.spawnAtLocation(var0, 0);
    }

    @Nullable
    public EntityItem spawnAtLocation(IMaterial var0, int var1) {
        return this.spawnAtLocation(new ItemStack(var0), (float)var1);
    }

    @Nullable
    public EntityItem spawnAtLocation(ItemStack var0) {
        return this.spawnAtLocation(var0, 0.0f);
    }

    @Nullable
    public EntityItem spawnAtLocation(ItemStack var0, float var1) {
        if (var0.isEmpty()) {
            return null;
        }
        if (this.level.isClientSide) {
            return null;
        }
        EntityItem var2 = new EntityItem(this.level, this.getX(), this.getY() + (double)var1, this.getZ(), var0);
        var2.setDefaultPickUpDelay();
        this.level.addFreshEntity(var2);
        return var2;
    }

    public boolean isAlive() {
        return !this.isRemoved();
    }

    public boolean isInWall() {
        if (this.noPhysics) {
            return false;
        }
        Vec3D var0 = this.getEyePosition();
        float var1 = this.dimensions.width * 0.8f;
        AxisAlignedBB var22 = AxisAlignedBB.ofSize(var0, var1, 1.0E-6, var1);
        return this.level.getBlockStates(var22).filter(Predicate.not(BlockBase.BlockData::isAir)).anyMatch(var2 -> {
            BlockPosition var3 = new BlockPosition(var0);
            return var2.isSuffocating(this.level, var3) && VoxelShapes.joinIsNotEmpty(var2.getCollisionShape(this.level, var3).move(var0.x, var0.y, var0.z), VoxelShapes.create(var22), OperatorBoolean.AND);
        });
    }

    public EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        return EnumInteractionResult.PASS;
    }

    public boolean canCollideWith(Entity var0) {
        return var0.canBeCollidedWith() && !this.isPassengerOfSameVehicle(var0);
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public void rideTick() {
        this.setDeltaMovement(Vec3D.ZERO);
        this.tick();
        if (!this.isPassenger()) {
            return;
        }
        this.getVehicle().positionRider(this);
    }

    public void positionRider(Entity var0) {
        this.positionRider(var0, Entity::setPos);
    }

    private void positionRider(Entity var0, MoveFunction var1) {
        if (!this.hasPassenger(var0)) {
            return;
        }
        double var2 = this.getY() + this.getPassengersRidingOffset() + var0.getMyRidingOffset();
        var1.accept(var0, this.getX(), var2, this.getZ());
    }

    public void onPassengerTurned(Entity var0) {
    }

    public double getMyRidingOffset() {
        return 0.0;
    }

    public double getPassengersRidingOffset() {
        return (double)this.dimensions.height * 0.75;
    }

    public boolean startRiding(Entity var0) {
        return this.startRiding(var0, false);
    }

    public boolean showVehicleHealth() {
        return this instanceof EntityLiving;
    }

    public boolean startRiding(Entity var02, boolean var1) {
        if (var02 == this.vehicle) {
            return false;
        }
        Entity var2 = var02;
        while (var2.vehicle != null) {
            if (var2.vehicle == this) {
                return false;
            }
            var2 = var2.vehicle;
        }
        if (!(var1 || this.canRide(var02) && var02.canAddPassenger(this))) {
            return false;
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
        this.setPose(EntityPose.STANDING);
        this.vehicle = var02;
        this.vehicle.addPassenger(this);
        var02.getIndirectPassengersStream().filter(var0 -> var0 instanceof EntityPlayer).forEach(var0 -> CriterionTriggers.START_RIDING_TRIGGER.trigger((EntityPlayer)var0));
        return true;
    }

    protected boolean canRide(Entity var0) {
        return !this.isShiftKeyDown() && this.boardingCooldown <= 0;
    }

    protected boolean canEnterPose(EntityPose var0) {
        return this.level.noCollision(this, this.getBoundingBoxForPose(var0).deflate(1.0E-7));
    }

    public void ejectPassengers() {
        for (int var0 = this.passengers.size() - 1; var0 >= 0; --var0) {
            ((Entity)this.passengers.get(var0)).stopRiding();
        }
    }

    public void removeVehicle() {
        if (this.vehicle != null) {
            Entity var0 = this.vehicle;
            this.vehicle = null;
            var0.removePassenger(this);
        }
    }

    public void stopRiding() {
        this.removeVehicle();
    }

    protected void addPassenger(Entity var0) {
        if (var0.getVehicle() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.passengers.isEmpty()) {
            this.passengers = ImmutableList.of((Object)var0);
        } else {
            ArrayList var1 = Lists.newArrayList(this.passengers);
            if (!this.level.isClientSide && var0 instanceof EntityHuman && !(this.getControllingPassenger() instanceof EntityHuman)) {
                var1.add(0, var0);
            } else {
                var1.add(var0);
            }
            this.passengers = ImmutableList.copyOf((Collection)var1);
        }
    }

    protected void removePassenger(Entity var0) {
        if (var0.getVehicle() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        this.passengers = this.passengers.size() == 1 && this.passengers.get(0) == var0 ? ImmutableList.of() : (ImmutableList)this.passengers.stream().filter(var1 -> var1 != var0).collect(ImmutableList.toImmutableList());
        var0.boardingCooldown = 60;
    }

    protected boolean canAddPassenger(Entity var0) {
        return this.passengers.isEmpty();
    }

    public void lerpTo(double var0, double var2, double var4, float var6, float var7, int var8, boolean var9) {
        this.setPos(var0, var2, var4);
        this.setRot(var6, var7);
    }

    public void lerpHeadTo(float var0, int var1) {
        this.setYHeadRot(var0);
    }

    public float getPickRadius() {
        return 0.0f;
    }

    public Vec3D getLookAngle() {
        return this.calculateViewVector(this.getXRot(), this.getYRot());
    }

    public Vec2F getRotationVector() {
        return new Vec2F(this.getXRot(), this.getYRot());
    }

    public Vec3D getForward() {
        return Vec3D.directionFromRotation(this.getRotationVector());
    }

    public void handleInsidePortal(BlockPosition var0) {
        if (this.isOnPortalCooldown()) {
            this.setPortalCooldown();
            return;
        }
        if (!this.level.isClientSide && !var0.equals(this.portalEntrancePos)) {
            this.portalEntrancePos = var0.immutable();
        }
        this.isInsidePortal = true;
    }

    protected void handleNetherPortal() {
        if (!(this.level instanceof WorldServer)) {
            return;
        }
        int var0 = this.getPortalWaitTime();
        WorldServer var1 = (WorldServer)this.level;
        if (this.isInsidePortal) {
            ResourceKey<World> var3;
            MinecraftServer var2 = var1.getServer();
            WorldServer var4 = var2.getLevel(var3 = this.level.dimension() == World.NETHER ? World.OVERWORLD : World.NETHER);
            if (var4 != null && var2.isNetherEnabled() && !this.isPassenger() && this.portalTime++ >= var0) {
                this.level.getProfiler().push("portal");
                this.portalTime = var0;
                this.setPortalCooldown();
                this.changeDimension(var4);
                this.level.getProfiler().pop();
            }
            this.isInsidePortal = false;
        } else {
            if (this.portalTime > 0) {
                this.portalTime -= 4;
            }
            if (this.portalTime < 0) {
                this.portalTime = 0;
            }
        }
        this.processPortalCooldown();
    }

    public int getDimensionChangingDelay() {
        return 300;
    }

    public void lerpMotion(double var0, double var2, double var4) {
        this.setDeltaMovement(var0, var2, var4);
    }

    public void handleEntityEvent(byte var0) {
        switch (var0) {
            case 53: {
                BlockHoney.showSlideParticles(this);
            }
        }
    }

    public void animateHurt() {
    }

    public Iterable<ItemStack> getHandSlots() {
        return EMPTY_LIST;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return EMPTY_LIST;
    }

    public Iterable<ItemStack> getAllSlots() {
        return Iterables.concat(this.getHandSlots(), this.getArmorSlots());
    }

    public void setItemSlot(EnumItemSlot var0, ItemStack var1) {
    }

    public boolean isOnFire() {
        boolean var0 = this.level != null && this.level.isClientSide;
        return !this.fireImmune() && (this.remainingFireTicks > 0 || var0 && this.getSharedFlag(0));
    }

    public boolean isPassenger() {
        return this.getVehicle() != null;
    }

    public boolean isVehicle() {
        return !this.passengers.isEmpty();
    }

    public boolean rideableUnderWater() {
        return true;
    }

    public void setShiftKeyDown(boolean var0) {
        this.setSharedFlag(1, var0);
    }

    public boolean isShiftKeyDown() {
        return this.getSharedFlag(1);
    }

    public boolean isSteppingCarefully() {
        return this.isShiftKeyDown();
    }

    public boolean isSuppressingBounce() {
        return this.isShiftKeyDown();
    }

    public boolean isDiscrete() {
        return this.isShiftKeyDown();
    }

    public boolean isDescending() {
        return this.isShiftKeyDown();
    }

    public boolean isCrouching() {
        return this.getPose() == EntityPose.CROUCHING;
    }

    public boolean isSprinting() {
        return this.getSharedFlag(3);
    }

    public void setSprinting(boolean var0) {
        this.setSharedFlag(3, var0);
    }

    public boolean isSwimming() {
        return this.getSharedFlag(4);
    }

    public boolean isVisuallySwimming() {
        return this.getPose() == EntityPose.SWIMMING;
    }

    public boolean isVisuallyCrawling() {
        return this.isVisuallySwimming() && !this.isInWater();
    }

    public void setSwimming(boolean var0) {
        this.setSharedFlag(4, var0);
    }

    public final boolean hasGlowingTag() {
        return this.hasGlowingTag;
    }

    public final void setGlowingTag(boolean var0) {
        this.hasGlowingTag = var0;
        this.setSharedFlag(6, this.isCurrentlyGlowing());
    }

    public boolean isCurrentlyGlowing() {
        if (this.level.isClientSide()) {
            return this.getSharedFlag(6);
        }
        return this.hasGlowingTag;
    }

    public boolean isInvisible() {
        return this.getSharedFlag(5);
    }

    public boolean isInvisibleTo(EntityHuman var0) {
        if (var0.isSpectator()) {
            return false;
        }
        ScoreboardTeamBase var1 = this.getTeam();
        if (var1 != null && var0 != null && var0.getTeam() == var1 && var1.canSeeFriendlyInvisibles()) {
            return false;
        }
        return this.isInvisible();
    }

    @Nullable
    public GameEventListenerRegistrar getGameEventListenerRegistrar() {
        return null;
    }

    @Nullable
    public ScoreboardTeamBase getTeam() {
        return this.level.getScoreboard().getPlayersTeam(this.getScoreboardName());
    }

    public boolean isAlliedTo(Entity var0) {
        return this.isAlliedTo(var0.getTeam());
    }

    public boolean isAlliedTo(ScoreboardTeamBase var0) {
        if (this.getTeam() != null) {
            return this.getTeam().isAlliedTo(var0);
        }
        return false;
    }

    public void setInvisible(boolean var0) {
        this.setSharedFlag(5, var0);
    }

    public boolean getSharedFlag(int var0) {
        return (this.entityData.get(DATA_SHARED_FLAGS_ID) & 1 << var0) != 0;
    }

    public void setSharedFlag(int var0, boolean var1) {
        byte var2 = this.entityData.get(DATA_SHARED_FLAGS_ID);
        if (var1) {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)(var2 | 1 << var0));
        } else {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)(var2 & ~(1 << var0)));
        }
    }

    public int getMaxAirSupply() {
        return 300;
    }

    public int getAirSupply() {
        return this.entityData.get(DATA_AIR_SUPPLY_ID);
    }

    public void setAirSupply(int var0) {
        this.entityData.set(DATA_AIR_SUPPLY_ID, var0);
    }

    public int getTicksFrozen() {
        return this.entityData.get(DATA_TICKS_FROZEN);
    }

    public void setTicksFrozen(int var0) {
        this.entityData.set(DATA_TICKS_FROZEN, var0);
    }

    public float getPercentFrozen() {
        int var0 = this.getTicksRequiredToFreeze();
        return (float)Math.min(this.getTicksFrozen(), var0) / (float)var0;
    }

    public boolean isFullyFrozen() {
        return this.getTicksFrozen() >= this.getTicksRequiredToFreeze();
    }

    public int getTicksRequiredToFreeze() {
        return 140;
    }

    public void thunderHit(WorldServer var0, EntityLightning var1) {
        this.setRemainingFireTicks(this.remainingFireTicks + 1);
        if (this.remainingFireTicks == 0) {
            this.setSecondsOnFire(8);
        }
        this.hurt(DamageSource.LIGHTNING_BOLT, 5.0f);
    }

    public void onAboveBubbleCol(boolean var0) {
        Vec3D var1 = this.getDeltaMovement();
        double var2 = var0 ? Math.max(-0.9, var1.y - 0.03) : Math.min(1.8, var1.y + 0.1);
        this.setDeltaMovement(var1.x, var2, var1.z);
    }

    public void onInsideBubbleColumn(boolean var0) {
        Vec3D var1 = this.getDeltaMovement();
        double var2 = var0 ? Math.max(-0.3, var1.y - 0.03) : Math.min(0.7, var1.y + 0.06);
        this.setDeltaMovement(var1.x, var2, var1.z);
        this.resetFallDistance();
    }

    public void killed(WorldServer var0, EntityLiving var1) {
    }

    public void resetFallDistance() {
        this.fallDistance = 0.0f;
    }

    protected void moveTowardsClosestSpace(double var0, double var2, double var4) {
        BlockPosition var6 = new BlockPosition(var0, var2, var4);
        Vec3D var7 = new Vec3D(var0 - (double)var6.getX(), var2 - (double)var6.getY(), var4 - (double)var6.getZ());
        BlockPosition.MutableBlockPosition var8 = new BlockPosition.MutableBlockPosition();
        EnumDirection var9 = EnumDirection.UP;
        double var10 = Double.MAX_VALUE;
        for (EnumDirection var15 : new EnumDirection[]{EnumDirection.NORTH, EnumDirection.SOUTH, EnumDirection.WEST, EnumDirection.EAST, EnumDirection.UP}) {
            double var18;
            var8.setWithOffset((BaseBlockPosition)var6, var15);
            if (this.level.getBlockState(var8).isCollisionShapeFullBlock(this.level, var8)) continue;
            double var16 = var7.get(var15.getAxis());
            double d2 = var18 = var15.getAxisDirection() == EnumDirection.EnumAxisDirection.POSITIVE ? 1.0 - var16 : var16;
            if (!(var18 < var10)) continue;
            var10 = var18;
            var9 = var15;
        }
        float var12 = this.random.nextFloat() * 0.2f + 0.1f;
        float var13 = var9.getAxisDirection().getStep();
        Vec3D var14 = this.getDeltaMovement().scale(0.75);
        if (var9.getAxis() == EnumDirection.EnumAxis.X) {
            this.setDeltaMovement(var13 * var12, var14.y, var14.z);
        } else if (var9.getAxis() == EnumDirection.EnumAxis.Y) {
            this.setDeltaMovement(var14.x, var13 * var12, var14.z);
        } else if (var9.getAxis() == EnumDirection.EnumAxis.Z) {
            this.setDeltaMovement(var14.x, var14.y, var13 * var12);
        }
    }

    public void makeStuckInBlock(IBlockData var0, Vec3D var1) {
        this.resetFallDistance();
        this.stuckSpeedMultiplier = var1;
    }

    private static IChatBaseComponent removeAction(IChatBaseComponent var0) {
        IChatMutableComponent var1 = var0.plainCopy().setStyle(var0.getStyle().withClickEvent(null));
        for (IChatBaseComponent var3 : var0.getSiblings()) {
            var1.append(Entity.removeAction(var3));
        }
        return var1;
    }

    @Override
    public IChatBaseComponent getName() {
        IChatBaseComponent var0 = this.getCustomName();
        if (var0 != null) {
            return Entity.removeAction(var0);
        }
        return this.getTypeName();
    }

    protected IChatBaseComponent getTypeName() {
        return this.type.getDescription();
    }

    public boolean is(Entity var0) {
        return this == var0;
    }

    public float getYHeadRot() {
        return 0.0f;
    }

    public void setYHeadRot(float var0) {
    }

    public void setYBodyRot(float var0) {
    }

    public boolean isAttackable() {
        return true;
    }

    public boolean skipAttackInteraction(Entity var0) {
        return false;
    }

    public String toString() {
        String var0;
        String string = var0 = this.level == null ? "~NULL~" : this.level.toString();
        if (this.removalReason != null) {
            return String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.getName().getString(), this.id, var0, this.getX(), this.getY(), this.getZ(), this.removalReason});
        }
        return String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.getName().getString(), this.id, var0, this.getX(), this.getY(), this.getZ());
    }

    public boolean isInvulnerableTo(DamageSource var0) {
        return this.isRemoved() || this.invulnerable && var0 != DamageSource.OUT_OF_WORLD && !var0.isCreativePlayer();
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public void setInvulnerable(boolean var0) {
        this.invulnerable = var0;
    }

    public void copyPosition(Entity var0) {
        this.moveTo(var0.getX(), var0.getY(), var0.getZ(), var0.getYRot(), var0.getXRot());
    }

    public void restoreFrom(Entity var0) {
        NBTTagCompound var1 = var0.saveWithoutId(new NBTTagCompound());
        var1.remove("Dimension");
        this.load(var1);
        this.portalCooldown = var0.portalCooldown;
        this.portalEntrancePos = var0.portalEntrancePos;
    }

    @Nullable
    public Entity changeDimension(WorldServer var0) {
        if (!(this.level instanceof WorldServer) || this.isRemoved()) {
            return null;
        }
        this.level.getProfiler().push("changeDimension");
        this.unRide();
        this.level.getProfiler().push("reposition");
        ShapeDetectorShape var1 = this.findDimensionEntryPoint(var0);
        if (var1 == null) {
            return null;
        }
        this.level.getProfiler().popPush("reloading");
        Object var2 = this.getType().create(var0);
        if (var2 != null) {
            ((Entity)var2).restoreFrom(this);
            ((Entity)var2).moveTo(var1.pos.x, var1.pos.y, var1.pos.z, var1.yRot, ((Entity)var2).getXRot());
            ((Entity)var2).setDeltaMovement(var1.speed);
            var0.addDuringTeleport((Entity)var2);
            if (var0.dimension() == World.END) {
                WorldServer.makeObsidianPlatform(var0);
            }
        }
        this.removeAfterChangingDimensions();
        this.level.getProfiler().pop();
        ((WorldServer)this.level).resetEmptyTime();
        var0.resetEmptyTime();
        this.level.getProfiler().pop();
        return var2;
    }

    protected void removeAfterChangingDimensions() {
        this.setRemoved(RemovalReason.CHANGED_DIMENSION);
    }

    @Nullable
    protected ShapeDetectorShape findDimensionEntryPoint(WorldServer var0) {
        boolean var3;
        boolean var2;
        boolean var1 = this.level.dimension() == World.END && var0.dimension() == World.OVERWORLD;
        boolean bl = var2 = var0.dimension() == World.END;
        if (var1 || var2) {
            BlockPosition var32 = var2 ? WorldServer.END_SPAWN_POINT : var0.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, var0.getSharedSpawnPos());
            return new ShapeDetectorShape(new Vec3D((double)var32.getX() + 0.5, var32.getY(), (double)var32.getZ() + 0.5), this.getDeltaMovement(), this.getYRot(), this.getXRot());
        }
        boolean bl2 = var3 = var0.dimension() == World.NETHER;
        if (this.level.dimension() != World.NETHER && !var3) {
            return null;
        }
        WorldBorder var4 = var0.getWorldBorder();
        double var5 = DimensionManager.getTeleportationScale(this.level.dimensionType(), var0.dimensionType());
        BlockPosition var7 = var4.clampToBounds(this.getX() * var5, this.getY(), this.getZ() * var5);
        return this.getExitPortal(var0, var7, var3, var4).map(var12 -> {
            Vec3D var3;
            EnumDirection.EnumAxis var2;
            IBlockData var4 = this.level.getBlockState(this.portalEntrancePos);
            if (var4.hasProperty(BlockProperties.HORIZONTAL_AXIS)) {
                var2 = var4.getValue(BlockProperties.HORIZONTAL_AXIS);
                BlockUtil.Rectangle var5 = BlockUtil.getLargestRectangleAround(this.portalEntrancePos, var2, 21, EnumDirection.EnumAxis.Y, 21, var1 -> this.level.getBlockState((BlockPosition)var1) == var4);
                var3 = this.getRelativePortalPosition(var2, var5);
            } else {
                var2 = EnumDirection.EnumAxis.X;
                var3 = new Vec3D(0.5, 0.0, 0.0);
            }
            return BlockPortalShape.createPortalInfo(var0, var12, var2, var3, this.getDimensions(this.getPose()), this.getDeltaMovement(), this.getYRot(), this.getXRot());
        }).orElse(null);
    }

    protected Vec3D getRelativePortalPosition(EnumDirection.EnumAxis var0, BlockUtil.Rectangle var1) {
        return BlockPortalShape.getRelativePosition(var1, var0, this.position(), this.getDimensions(this.getPose()));
    }

    protected Optional<BlockUtil.Rectangle> getExitPortal(WorldServer var0, BlockPosition var1, boolean var2, WorldBorder var3) {
        return var0.getPortalForcer().findPortalAround(var1, var2, var3);
    }

    public boolean canChangeDimensions() {
        return true;
    }

    public float getBlockExplosionResistance(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, Fluid var4, float var5) {
        return var5;
    }

    public boolean shouldBlockExplode(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, float var4) {
        return true;
    }

    public int getMaxFallDistance() {
        return 3;
    }

    public boolean isIgnoringBlockTriggers() {
        return false;
    }

    public void fillCrashReportCategory(CrashReportSystemDetails var0) {
        var0.setDetail("Entity Type", () -> EntityTypes.getKey(this.getType()) + " (" + this.getClass().getCanonicalName() + ")");
        var0.setDetail("Entity ID", this.id);
        var0.setDetail("Entity Name", () -> this.getName().getString());
        var0.setDetail("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.getX(), this.getY(), this.getZ()));
        var0.setDetail("Entity's Block location", CrashReportSystemDetails.formatLocation((LevelHeightAccessor)this.level, MathHelper.floor(this.getX()), MathHelper.floor(this.getY()), MathHelper.floor(this.getZ())));
        Vec3D var1 = this.getDeltaMovement();
        var0.setDetail("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", var1.x, var1.y, var1.z));
        var0.setDetail("Entity's Passengers", () -> this.getPassengers().toString());
        var0.setDetail("Entity's Vehicle", () -> String.valueOf(this.getVehicle()));
    }

    public boolean displayFireAnimation() {
        return this.isOnFire() && !this.isSpectator();
    }

    public void setUUID(UUID var0) {
        this.uuid = var0;
        this.stringUUID = this.uuid.toString();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    public String getStringUUID() {
        return this.stringUUID;
    }

    public String getScoreboardName() {
        return this.stringUUID;
    }

    public boolean isPushedByFluid() {
        return true;
    }

    public static double getViewScale() {
        return viewScale;
    }

    public static void setViewScale(double var0) {
        viewScale = var0;
    }

    @Override
    public IChatBaseComponent getDisplayName() {
        return ScoreboardTeam.formatNameForTeam(this.getTeam(), this.getName()).withStyle(var0 -> var0.withHoverEvent(this.createHoverEvent()).withInsertion(this.getStringUUID()));
    }

    public void setCustomName(@Nullable IChatBaseComponent var0) {
        this.entityData.set(DATA_CUSTOM_NAME, Optional.ofNullable(var0));
    }

    @Override
    @Nullable
    public IChatBaseComponent getCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).orElse(null);
    }

    @Override
    public boolean hasCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).isPresent();
    }

    public void setCustomNameVisible(boolean var0) {
        this.entityData.set(DATA_CUSTOM_NAME_VISIBLE, var0);
    }

    public boolean isCustomNameVisible() {
        return this.entityData.get(DATA_CUSTOM_NAME_VISIBLE);
    }

    public final void teleportToWithTicket(double var0, double var2, double var4) {
        if (!(this.level instanceof WorldServer)) {
            return;
        }
        ChunkCoordIntPair var6 = new ChunkCoordIntPair(new BlockPosition(var0, var2, var4));
        ((WorldServer)this.level).getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, var6, 0, this.getId());
        this.level.getChunk(var6.x, var6.z);
        this.teleportTo(var0, var2, var4);
    }

    public void dismountTo(double var0, double var2, double var4) {
        this.teleportTo(var0, var2, var4);
    }

    public void teleportTo(double var02, double var2, double var4) {
        if (!(this.level instanceof WorldServer)) {
            return;
        }
        this.moveTo(var02, var2, var4, this.getYRot(), this.getXRot());
        this.getSelfAndPassengers().forEach(var0 -> {
            for (Entity var2 : var0.passengers) {
                var0.positionRider(var2, Entity::moveTo);
            }
        });
    }

    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_POSE.equals(var0)) {
            this.refreshDimensions();
        }
    }

    public void refreshDimensions() {
        boolean var3;
        EntitySize var2;
        EntitySize var0 = this.dimensions;
        EntityPose var12 = this.getPose();
        this.dimensions = var2 = this.getDimensions(var12);
        this.eyeHeight = this.getEyeHeight(var12, var2);
        this.reapplyPosition();
        boolean bl = var3 = (double)var2.width <= 4.0 && (double)var2.height <= 4.0;
        if (!(this.level.isClientSide || this.firstTick || this.noPhysics || !var3 || !(var2.width > var0.width) && !(var2.height > var0.height) || this instanceof EntityHuman)) {
            Vec3D var4 = this.position().add(0.0, (double)var0.height / 2.0, 0.0);
            double var5 = (double)Math.max(0.0f, var2.width - var0.width) + 1.0E-6;
            double var7 = (double)Math.max(0.0f, var2.height - var0.height) + 1.0E-6;
            VoxelShape var9 = VoxelShapes.create(AxisAlignedBB.ofSize(var4, var5, var7, var5));
            this.level.findFreePosition(this, var9, var4, var2.width, var2.height, var2.width).ifPresent(var1 -> this.setPos(var1.add(0.0, (double)(-var0.height) / 2.0, 0.0)));
        }
    }

    public EnumDirection getDirection() {
        return EnumDirection.fromYRot(this.getYRot());
    }

    public EnumDirection getMotionDirection() {
        return this.getDirection();
    }

    protected ChatHoverable createHoverEvent() {
        return new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_ENTITY, new ChatHoverable.b(this.getType(), this.getUUID(), this.getName()));
    }

    public boolean broadcastToPlayer(EntityPlayer var0) {
        return true;
    }

    @Override
    public final AxisAlignedBB getBoundingBox() {
        return this.bb;
    }

    public AxisAlignedBB getBoundingBoxForCulling() {
        return this.getBoundingBox();
    }

    protected AxisAlignedBB getBoundingBoxForPose(EntityPose var0) {
        EntitySize var1 = this.getDimensions(var0);
        float var2 = var1.width / 2.0f;
        Vec3D var3 = new Vec3D(this.getX() - (double)var2, this.getY(), this.getZ() - (double)var2);
        Vec3D var4 = new Vec3D(this.getX() + (double)var2, this.getY() + (double)var1.height, this.getZ() + (double)var2);
        return new AxisAlignedBB(var3, var4);
    }

    public final void setBoundingBox(AxisAlignedBB var0) {
        this.bb = var0;
    }

    protected float getEyeHeight(EntityPose var0, EntitySize var1) {
        return var1.height * 0.85f;
    }

    public float getEyeHeight(EntityPose var0) {
        return this.getEyeHeight(var0, this.getDimensions(var0));
    }

    public final float getEyeHeight() {
        return this.eyeHeight;
    }

    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public SlotAccess getSlot(int var0) {
        return SlotAccess.NULL;
    }

    @Override
    public void sendMessage(IChatBaseComponent var0, UUID var1) {
    }

    public World getCommandSenderWorld() {
        return this.level;
    }

    @Nullable
    public MinecraftServer getServer() {
        return this.level.getServer();
    }

    public EnumInteractionResult interactAt(EntityHuman var0, Vec3D var1, EnumHand var2) {
        return EnumInteractionResult.PASS;
    }

    public boolean ignoreExplosion() {
        return false;
    }

    public void doEnchantDamageEffects(EntityLiving var0, Entity var1) {
        if (var1 instanceof EntityLiving) {
            EnchantmentManager.doPostHurtEffects((EntityLiving)var1, var0);
        }
        EnchantmentManager.doPostDamageEffects(var0, var1);
    }

    public void startSeenByPlayer(EntityPlayer var0) {
    }

    public void stopSeenByPlayer(EntityPlayer var0) {
    }

    public float rotate(EnumBlockRotation var0) {
        float var1 = MathHelper.wrapDegrees(this.getYRot());
        switch (var0) {
            case CLOCKWISE_180: {
                return var1 + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return var1 + 270.0f;
            }
            case CLOCKWISE_90: {
                return var1 + 90.0f;
            }
        }
        return var1;
    }

    public float mirror(EnumBlockMirror var0) {
        float var1 = MathHelper.wrapDegrees(this.getYRot());
        switch (var0) {
            case LEFT_RIGHT: {
                return -var1;
            }
            case FRONT_BACK: {
                return 180.0f - var1;
            }
        }
        return var1;
    }

    public boolean onlyOpCanSetNbt() {
        return false;
    }

    @Nullable
    public Entity getControllingPassenger() {
        return null;
    }

    public final List<Entity> getPassengers() {
        return this.passengers;
    }

    @Nullable
    public Entity getFirstPassenger() {
        return this.passengers.isEmpty() ? null : (Entity)this.passengers.get(0);
    }

    public boolean hasPassenger(Entity var0) {
        return this.passengers.contains((Object)var0);
    }

    public boolean hasPassenger(Predicate<Entity> var0) {
        for (Entity var2 : this.passengers) {
            if (!var0.test(var2)) continue;
            return true;
        }
        return false;
    }

    private Stream<Entity> getIndirectPassengersStream() {
        return this.passengers.stream().flatMap(Entity::getSelfAndPassengers);
    }

    public Stream<Entity> getSelfAndPassengers() {
        return Stream.concat(Stream.of(this), this.getIndirectPassengersStream());
    }

    public Stream<Entity> getPassengersAndSelf() {
        return Stream.concat(this.passengers.stream().flatMap(Entity::getPassengersAndSelf), Stream.of(this));
    }

    public Iterable<Entity> getIndirectPassengers() {
        return () -> this.getIndirectPassengersStream().iterator();
    }

    public boolean hasExactlyOnePlayerPassenger() {
        return this.getIndirectPassengersStream().filter(var0 -> var0 instanceof EntityHuman).count() == 1L;
    }

    public Entity getRootVehicle() {
        Entity var0 = this;
        while (var0.isPassenger()) {
            var0 = var0.getVehicle();
        }
        return var0;
    }

    public boolean isPassengerOfSameVehicle(Entity var0) {
        return this.getRootVehicle() == var0.getRootVehicle();
    }

    public boolean hasIndirectPassenger(Entity var0) {
        return this.getIndirectPassengersStream().anyMatch(var1 -> var1 == var0);
    }

    public boolean isControlledByLocalInstance() {
        Entity var0 = this.getControllingPassenger();
        if (var0 instanceof EntityHuman) {
            return ((EntityHuman)var0).isLocalPlayer();
        }
        return !this.level.isClientSide;
    }

    protected static Vec3D getCollisionHorizontalEscapeVector(double var0, double var2, float var4) {
        double var5 = (var0 + var2 + (double)1.0E-5f) / 2.0;
        float var7 = -MathHelper.sin(var4 * ((float)Math.PI / 180));
        float var8 = MathHelper.cos(var4 * ((float)Math.PI / 180));
        float var9 = Math.max(Math.abs(var7), Math.abs(var8));
        return new Vec3D((double)var7 * var5 / (double)var9, 0.0, (double)var8 * var5 / (double)var9);
    }

    public Vec3D getDismountLocationForPassenger(EntityLiving var0) {
        return new Vec3D(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @Nullable
    public Entity getVehicle() {
        return this.vehicle;
    }

    public EnumPistonReaction getPistonPushReaction() {
        return EnumPistonReaction.NORMAL;
    }

    public SoundCategory getSoundSource() {
        return SoundCategory.NEUTRAL;
    }

    public int getFireImmuneTicks() {
        return 1;
    }

    public CommandListenerWrapper createCommandSourceStack() {
        return new CommandListenerWrapper(this, this.position(), this.getRotationVector(), this.level instanceof WorldServer ? (WorldServer)this.level : null, this.getPermissionLevel(), this.getName().getString(), this.getDisplayName(), this.level.getServer(), this);
    }

    protected int getPermissionLevel() {
        return 0;
    }

    public boolean hasPermissions(int var0) {
        return this.getPermissionLevel() >= var0;
    }

    @Override
    public boolean acceptsSuccess() {
        return this.level.getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
    }

    @Override
    public boolean acceptsFailure() {
        return true;
    }

    @Override
    public boolean shouldInformAdmins() {
        return true;
    }

    public void lookAt(ArgumentAnchor.Anchor var0, Vec3D var1) {
        Vec3D var2 = var0.apply(this);
        double var3 = var1.x - var2.x;
        double var5 = var1.y - var2.y;
        double var7 = var1.z - var2.z;
        double var9 = Math.sqrt(var3 * var3 + var7 * var7);
        this.setXRot(MathHelper.wrapDegrees((float)(-(MathHelper.atan2(var5, var9) * 57.2957763671875))));
        this.setYRot(MathHelper.wrapDegrees((float)(MathHelper.atan2(var7, var3) * 57.2957763671875) - 90.0f));
        this.setYHeadRot(this.getYRot());
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
    }

    public boolean updateFluidHeightAndDoFluidPushing(Tag<FluidType> var0, double var1) {
        if (this.touchingUnloadedChunk()) {
            return false;
        }
        AxisAlignedBB var3 = this.getBoundingBox().deflate(0.001);
        int var4 = MathHelper.floor(var3.minX);
        int var5 = MathHelper.ceil(var3.maxX);
        int var6 = MathHelper.floor(var3.minY);
        int var7 = MathHelper.ceil(var3.maxY);
        int var8 = MathHelper.floor(var3.minZ);
        int var9 = MathHelper.ceil(var3.maxZ);
        double var10 = 0.0;
        boolean var12 = this.isPushedByFluid();
        boolean var13 = false;
        Vec3D var14 = Vec3D.ZERO;
        int var15 = 0;
        BlockPosition.MutableBlockPosition var16 = new BlockPosition.MutableBlockPosition();
        for (int var17 = var4; var17 < var5; ++var17) {
            for (int var18 = var6; var18 < var7; ++var18) {
                for (int var19 = var8; var19 < var9; ++var19) {
                    double var21;
                    var16.set(var17, var18, var19);
                    Fluid var20 = this.level.getFluidState(var16);
                    if (!var20.is(var0) || !((var21 = (double)((float)var18 + var20.getHeight(this.level, var16))) >= var3.minY)) continue;
                    var13 = true;
                    var10 = Math.max(var21 - var3.minY, var10);
                    if (!var12) continue;
                    Vec3D var23 = var20.getFlow(this.level, var16);
                    if (var10 < 0.4) {
                        var23 = var23.scale(var10);
                    }
                    var14 = var14.add(var23);
                    ++var15;
                }
            }
        }
        if (var14.length() > 0.0) {
            if (var15 > 0) {
                var14 = var14.scale(1.0 / (double)var15);
            }
            if (!(this instanceof EntityHuman)) {
                var14 = var14.normalize();
            }
            Vec3D var17 = this.getDeltaMovement();
            var14 = var14.scale(var1 * 1.0);
            double var18 = 0.003;
            if (Math.abs(var17.x) < 0.003 && Math.abs(var17.z) < 0.003 && var14.length() < 0.0045000000000000005) {
                var14 = var14.normalize().scale(0.0045000000000000005);
            }
            this.setDeltaMovement(this.getDeltaMovement().add(var14));
        }
        this.fluidHeight.put(var0, var10);
        return var13;
    }

    public boolean touchingUnloadedChunk() {
        int var4;
        AxisAlignedBB var0 = this.getBoundingBox().inflate(1.0);
        int var1 = MathHelper.floor(var0.minX);
        int var2 = MathHelper.ceil(var0.maxX);
        int var3 = MathHelper.floor(var0.minZ);
        return !this.level.hasChunksAt(var1, var3, var2, var4 = MathHelper.ceil(var0.maxZ));
    }

    public double getFluidHeight(Tag<FluidType> var0) {
        return this.fluidHeight.getDouble(var0);
    }

    public double getFluidJumpThreshold() {
        return (double)this.getEyeHeight() < 0.4 ? 0.0 : 0.4;
    }

    public final float getBbWidth() {
        return this.dimensions.width;
    }

    public final float getBbHeight() {
        return this.dimensions.height;
    }

    public abstract Packet<?> getAddEntityPacket();

    public EntitySize getDimensions(EntityPose var0) {
        return this.type.getDimensions();
    }

    public Vec3D position() {
        return this.position;
    }

    @Override
    public BlockPosition blockPosition() {
        return this.blockPosition;
    }

    public IBlockData getFeetBlockState() {
        if (this.feetBlockState == null) {
            this.feetBlockState = this.level.getBlockState(this.blockPosition());
        }
        return this.feetBlockState;
    }

    public BlockPosition eyeBlockPosition() {
        return new BlockPosition(this.getEyePosition(1.0f));
    }

    public ChunkCoordIntPair chunkPosition() {
        return this.chunkPosition;
    }

    public Vec3D getDeltaMovement() {
        return this.deltaMovement;
    }

    public void setDeltaMovement(Vec3D var0) {
        this.deltaMovement = var0;
    }

    public void setDeltaMovement(double var0, double var2, double var4) {
        this.setDeltaMovement(new Vec3D(var0, var2, var4));
    }

    public final int getBlockX() {
        return this.blockPosition.getX();
    }

    public final double getX() {
        return this.position.x;
    }

    public double getX(double var0) {
        return this.position.x + (double)this.getBbWidth() * var0;
    }

    public double getRandomX(double var0) {
        return this.getX((2.0 * this.random.nextDouble() - 1.0) * var0);
    }

    public final int getBlockY() {
        return this.blockPosition.getY();
    }

    public final double getY() {
        return this.position.y;
    }

    public double getY(double var0) {
        return this.position.y + (double)this.getBbHeight() * var0;
    }

    public double getRandomY() {
        return this.getY(this.random.nextDouble());
    }

    public double getEyeY() {
        return this.position.y + (double)this.eyeHeight;
    }

    public final int getBlockZ() {
        return this.blockPosition.getZ();
    }

    public final double getZ() {
        return this.position.z;
    }

    public double getZ(double var0) {
        return this.position.z + (double)this.getBbWidth() * var0;
    }

    public double getRandomZ(double var0) {
        return this.getZ((2.0 * this.random.nextDouble() - 1.0) * var0);
    }

    public final void setPosRaw(double var0, double var2, double var4) {
        if (this.position.x != var0 || this.position.y != var2 || this.position.z != var4) {
            this.position = new Vec3D(var0, var2, var4);
            int var6 = MathHelper.floor(var0);
            int var7 = MathHelper.floor(var2);
            int var8 = MathHelper.floor(var4);
            if (var6 != this.blockPosition.getX() || var7 != this.blockPosition.getY() || var8 != this.blockPosition.getZ()) {
                this.blockPosition = new BlockPosition(var6, var7, var8);
                this.feetBlockState = null;
                if (SectionPosition.blockToSectionCoord(var6) != this.chunkPosition.x || SectionPosition.blockToSectionCoord(var8) != this.chunkPosition.z) {
                    this.chunkPosition = new ChunkCoordIntPair(this.blockPosition);
                }
            }
            this.levelCallback.onMove();
            GameEventListenerRegistrar var9 = this.getGameEventListenerRegistrar();
            if (var9 != null) {
                var9.onListenerMove(this.level);
            }
        }
    }

    public void checkDespawn() {
    }

    public Vec3D getRopeHoldPosition(float var0) {
        return this.getPosition(var0).add(0.0, (double)this.eyeHeight * 0.7, 0.0);
    }

    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        int var1 = var0.getId();
        double var2 = var0.getX();
        double var4 = var0.getY();
        double var6 = var0.getZ();
        this.setPacketCoordinates(var2, var4, var6);
        this.moveTo(var2, var4, var6);
        this.setXRot((float)(var0.getxRot() * 360) / 256.0f);
        this.setYRot((float)(var0.getyRot() * 360) / 256.0f);
        this.setId(var1);
        this.setUUID(var0.getUUID());
    }

    @Nullable
    public ItemStack getPickResult() {
        return null;
    }

    public void setIsInPowderSnow(boolean var0) {
        this.isInPowderSnow = var0;
    }

    public boolean canFreeze() {
        return !TagsEntity.FREEZE_IMMUNE_ENTITY_TYPES.contains(this.getType());
    }

    public float getYRot() {
        return this.yRot;
    }

    public void setYRot(float var0) {
        if (!Float.isFinite(var0)) {
            SystemUtils.logAndPauseIfInIde("Invalid entity rotation: " + var0 + ", discarding.");
            return;
        }
        this.yRot = var0;
    }

    public float getXRot() {
        return this.xRot;
    }

    public void setXRot(float var0) {
        if (!Float.isFinite(var0)) {
            SystemUtils.logAndPauseIfInIde("Invalid entity rotation: " + var0 + ", discarding.");
            return;
        }
        this.xRot = var0;
    }

    public final boolean isRemoved() {
        return this.removalReason != null;
    }

    @Nullable
    public RemovalReason getRemovalReason() {
        return this.removalReason;
    }

    @Override
    public void setRemoved(RemovalReason var0) {
        if (this.removalReason == null) {
            this.removalReason = var0;
        }
        if (this.removalReason.shouldDestroy()) {
            this.stopRiding();
        }
        this.getPassengers().forEach(Entity::stopRiding);
        this.levelCallback.onRemove(var0);
    }

    public void unsetRemoved() {
        this.removalReason = null;
    }

    @Override
    public void setLevelCallback(EntityInLevelCallback var0) {
        this.levelCallback = var0;
    }

    @Override
    public boolean shouldBeSaved() {
        if (this.removalReason != null && !this.removalReason.shouldSave()) {
            return false;
        }
        if (this.isPassenger()) {
            return false;
        }
        return !this.isVehicle() || !this.hasExactlyOnePlayerPassenger();
    }

    @Override
    public boolean isAlwaysTicking() {
        return false;
    }

    public boolean mayInteract(World var0, BlockPosition var1) {
        return true;
    }

    public World getLevel() {
        return this.level;
    }

    public static final class RemovalReason
    extends Enum<RemovalReason> {
        public static final /* enum */ RemovalReason KILLED = new RemovalReason(true, false);
        public static final /* enum */ RemovalReason DISCARDED = new RemovalReason(true, false);
        public static final /* enum */ RemovalReason UNLOADED_TO_CHUNK = new RemovalReason(false, true);
        public static final /* enum */ RemovalReason UNLOADED_WITH_PLAYER = new RemovalReason(false, false);
        public static final /* enum */ RemovalReason CHANGED_DIMENSION = new RemovalReason(false, false);
        private final boolean destroy;
        private final boolean save;
        private static final /* synthetic */ RemovalReason[] h;

        public static RemovalReason[] values() {
            return (RemovalReason[])h.clone();
        }

        public static RemovalReason valueOf(String var0) {
            return Enum.valueOf(RemovalReason.class, var0);
        }

        private RemovalReason(boolean var2, boolean var3) {
            this.destroy = var2;
            this.save = var3;
        }

        public boolean shouldDestroy() {
            return this.destroy;
        }

        public boolean shouldSave() {
            return this.save;
        }

        private static /* synthetic */ RemovalReason[] c() {
            return new RemovalReason[]{KILLED, DISCARDED, UNLOADED_TO_CHUNK, UNLOADED_WITH_PLAYER, CHANGED_DIMENSION};
        }

        static {
            h = RemovalReason.c();
        }
    }

    public static final class MovementEmission
    extends Enum<MovementEmission> {
        public static final /* enum */ MovementEmission NONE = new MovementEmission(false, false);
        public static final /* enum */ MovementEmission SOUNDS = new MovementEmission(true, false);
        public static final /* enum */ MovementEmission EVENTS = new MovementEmission(false, true);
        public static final /* enum */ MovementEmission ALL = new MovementEmission(true, true);
        final boolean sounds;
        final boolean events;
        private static final /* synthetic */ MovementEmission[] g;

        public static MovementEmission[] values() {
            return (MovementEmission[])g.clone();
        }

        public static MovementEmission valueOf(String var0) {
            return Enum.valueOf(MovementEmission.class, var0);
        }

        private MovementEmission(boolean var2, boolean var3) {
            this.sounds = var2;
            this.events = var3;
        }

        public boolean emitsAnything() {
            return this.events || this.sounds;
        }

        public boolean emitsEvents() {
            return this.events;
        }

        public boolean emitsSounds() {
            return this.sounds;
        }

        private static /* synthetic */ MovementEmission[] d() {
            return new MovementEmission[]{NONE, SOUNDS, EVENTS, ALL};
        }

        static {
            g = MovementEmission.d();
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }
}

