/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import net.minecraft.util.MathHelper;
import net.minecraft.util.UtilColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityLiving;

public final class MobEffectUtil {
    public static String formatDuration(MobEffect var0, float var1) {
        if (var0.isNoCounter()) {
            return "**:**";
        }
        int var2 = MathHelper.floor((float)var0.getDuration() * var1);
        return UtilColor.formatTickDuration(var2);
    }

    public static boolean hasDigSpeed(EntityLiving var0) {
        return var0.hasEffect(MobEffects.DIG_SPEED) || var0.hasEffect(MobEffects.CONDUIT_POWER);
    }

    public static int getDigSpeedAmplification(EntityLiving var0) {
        int var1 = 0;
        int var2 = 0;
        if (var0.hasEffect(MobEffects.DIG_SPEED)) {
            var1 = var0.getEffect(MobEffects.DIG_SPEED).getAmplifier();
        }
        if (var0.hasEffect(MobEffects.CONDUIT_POWER)) {
            var2 = var0.getEffect(MobEffects.CONDUIT_POWER).getAmplifier();
        }
        return Math.max(var1, var2);
    }

    public static boolean hasWaterBreathing(EntityLiving var0) {
        return var0.hasEffect(MobEffects.WATER_BREATHING) || var0.hasEffect(MobEffects.CONDUIT_POWER);
    }
}

