/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.MathHelper;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;

public class UniformFloat
extends FloatProvider {
    public static final Codec<UniformFloat> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.FLOAT.fieldOf("min_inclusive").forGetter(var0 -> Float.valueOf(var0.minInclusive)), (App)Codec.FLOAT.fieldOf("max_exclusive").forGetter(var0 -> Float.valueOf(var0.maxExclusive))).apply((Applicative)var02, UniformFloat::new)).comapFlatMap(var0 -> {
        if (var0.maxExclusive <= var0.minInclusive) {
            return DataResult.error((String)("Max must be larger than min, min_inclusive: " + var0.minInclusive + ", max_exclusive: " + var0.maxExclusive));
        }
        return DataResult.success((Object)var0);
    }, Function.identity());
    private final float minInclusive;
    private final float maxExclusive;

    private UniformFloat(float var0, float var1) {
        this.minInclusive = var0;
        this.maxExclusive = var1;
    }

    public static UniformFloat of(float var0, float var1) {
        if (var1 <= var0) {
            throw new IllegalArgumentException("Max must exceed min");
        }
        return new UniformFloat(var0, var1);
    }

    @Override
    public float sample(Random var0) {
        return MathHelper.randomBetween(var0, this.minInclusive, this.maxExclusive);
    }

    @Override
    public float getMinValue() {
        return this.minInclusive;
    }

    @Override
    public float getMaxValue() {
        return this.maxExclusive;
    }

    @Override
    public FloatProviderType<?> getType() {
        return FloatProviderType.UNIFORM;
    }

    public String toString() {
        return "[" + this.minInclusive + "-" + this.maxExclusive + "]";
    }
}

