/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;

public class ConstantFloat
extends FloatProvider {
    public static final ConstantFloat ZERO = new ConstantFloat(0.0f);
    public static final Codec<ConstantFloat> CODEC = Codec.either((Codec)Codec.FLOAT, (Codec)RecordCodecBuilder.create(var02 -> var02.group((App)Codec.FLOAT.fieldOf("value").forGetter(var0 -> Float.valueOf(var0.value))).apply((Applicative)var02, ConstantFloat::new))).xmap(var02 -> (ConstantFloat)var02.map(ConstantFloat::of, var0 -> var0), var0 -> Either.left((Object)Float.valueOf(var0.value)));
    private final float value;

    public static ConstantFloat of(float var0) {
        if (var0 == 0.0f) {
            return ZERO;
        }
        return new ConstantFloat(var0);
    }

    private ConstantFloat(float var0) {
        this.value = var0;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public float sample(Random var0) {
        return this.value;
    }

    @Override
    public float getMinValue() {
        return this.value;
    }

    @Override
    public float getMaxValue() {
        return this.value + 1.0f;
    }

    @Override
    public FloatProviderType<?> getType() {
        return FloatProviderType.CONSTANT;
    }

    public String toString() {
        return Float.toString(this.value);
    }
}

