/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom2;

public class WeightedRandomList<E extends WeightedEntry> {
    private final int totalWeight;
    private final ImmutableList<E> items;

    WeightedRandomList(List<? extends E> var0) {
        this.items = ImmutableList.copyOf(var0);
        this.totalWeight = WeightedRandom2.getTotalWeight(var0);
    }

    public static <E extends WeightedEntry> WeightedRandomList<E> create() {
        return new WeightedRandomList<E>(ImmutableList.of());
    }

    @SafeVarargs
    public static <E extends WeightedEntry> WeightedRandomList<E> create(E ... var0) {
        return new WeightedRandomList<E>(ImmutableList.copyOf((Object[])var0));
    }

    public static <E extends WeightedEntry> WeightedRandomList<E> create(List<E> var0) {
        return new WeightedRandomList<E>(var0);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Optional<E> getRandom(Random var0) {
        if (this.totalWeight == 0) {
            return Optional.empty();
        }
        int var1 = var0.nextInt(this.totalWeight);
        return WeightedRandom2.getWeightedItem(this.items, var1);
    }

    public List<E> unwrap() {
        return this.items;
    }

    public static <E extends WeightedEntry> Codec<WeightedRandomList<E>> codec(Codec<E> var0) {
        return var0.listOf().xmap(WeightedRandomList::create, WeightedRandomList::unwrap);
    }
}

