/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterProtoChunk
extends DataFix {
    private static final int NUM_SECTIONS = 16;

    public DataConverterProtoChunk(Schema var0, boolean var1) {
        super(var0, var1);
    }

    public TypeRewriteRule makeRule() {
        return TypeRewriteRule.seq((TypeRewriteRule)this.writeFixAndRead("ChunkToProtoChunkFix", this.getInputSchema().getType(DataConverterTypes.CHUNK), this.getOutputSchema().getType(DataConverterTypes.CHUNK), var0 -> var0.update("Level", DataConverterProtoChunk::fixChunkData)), (TypeRewriteRule)this.writeAndRead("Structure biome inject", this.getInputSchema().getType(DataConverterTypes.STRUCTURE_FEATURE), this.getOutputSchema().getType(DataConverterTypes.STRUCTURE_FEATURE)));
    }

    private static <T> Dynamic<T> fixChunkData(Dynamic<T> var0) {
        boolean var1 = var0.get("TerrainPopulated").asBoolean(false) && (var0.get("LightPopulated").asNumber().result().isEmpty() || var0.get("LightPopulated").asBoolean(false));
        Dynamic<T> var2 = var1 ? DataConverterProtoChunk.repackTicks(DataConverterProtoChunk.repackBiomes(var0)) : DataConverterProtoChunk.createEmptyChunk(var0);
        return var2.set("Status", var0.createString(var1 ? "mobs_spawned" : "empty")).set("hasLegacyStructureData", var0.createBoolean(true));
    }

    private static <T> Dynamic<T> repackBiomes(Dynamic<T> var0) {
        return var0.update("Biomes", var12 -> (Dynamic)DataFixUtils.orElse(var12.asByteBufferOpt().result().map(var1 -> {
            int[] var2 = new int[256];
            for (int var3 = 0; var3 < var2.length; ++var3) {
                if (var3 >= var1.capacity()) continue;
                var2[var3] = var1.get(var3) & 0xFF;
            }
            return var0.createIntList(Arrays.stream(var2));
        }), (Object)var12));
    }

    private static <T> Dynamic<T> repackTicks(Dynamic<T> var0) {
        return (Dynamic)DataFixUtils.orElse(var0.get("TileTicks").asStreamOpt().result().map(var13 -> {
            List var2 = IntStream.range(0, 16).mapToObj(var0 -> new ShortArrayList()).collect(Collectors.toList());
            var13.forEach(var1 -> {
                int var2 = var1.get("x").asInt(0);
                int var3 = var1.get("y").asInt(0);
                int var4 = var1.get("z").asInt(0);
                short var5 = DataConverterProtoChunk.packOffsetCoordinates(var2, var3, var4);
                ((ShortList)var2.get(var3 >> 4)).add(var5);
            });
            return var0.remove("TileTicks").set("ToBeTicked", var0.createList(var2.stream().map(var12 -> var0.createList(var12.intStream().mapToObj(var1 -> var0.createShort((short)var1))))));
        }), var0);
    }

    private static <T> Dynamic<T> createEmptyChunk(Dynamic<T> var0) {
        ImmutableMap.Builder var1 = ImmutableMap.builder();
        var0.get("xPos").result().ifPresent(var2 -> var1.put((Object)var0.createString("xPos"), var2));
        var0.get("zPos").result().ifPresent(var2 -> var1.put((Object)var0.createString("zPos"), var2));
        return var0.createMap((Map)var1.build());
    }

    private static short packOffsetCoordinates(int var0, int var1, int var2) {
        return (short)(var0 & 0xF | (var1 & 0xF) << 4 | (var2 & 0xF) << 8);
    }
}

