/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.util.MathHelper;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public class ParticleUtils {
    public static void spawnParticlesOnBlockFaces(World var0, BlockPosition var1, ParticleParam var2, UniformInt var3) {
        for (EnumDirection var7 : EnumDirection.values()) {
            int var8 = var3.sample(var0.random);
            for (int var9 = 0; var9 < var8; ++var9) {
                ParticleUtils.spawnParticleOnFace(var0, var1, var7, var2);
            }
        }
    }

    public static void spawnParticlesAlongAxis(EnumDirection.EnumAxis var0, World var1, BlockPosition var2, double var3, ParticleParam var5, UniformInt var6) {
        Vec3D var7 = Vec3D.atCenterOf(var2);
        boolean var8 = var0 == EnumDirection.EnumAxis.X;
        boolean var9 = var0 == EnumDirection.EnumAxis.Y;
        boolean var10 = var0 == EnumDirection.EnumAxis.Z;
        int var11 = var6.sample(var1.random);
        for (int var12 = 0; var12 < var11; ++var12) {
            double var13 = var7.x + MathHelper.nextDouble(var1.random, -1.0, 1.0) * (var8 ? 0.5 : var3);
            double var15 = var7.y + MathHelper.nextDouble(var1.random, -1.0, 1.0) * (var9 ? 0.5 : var3);
            double var17 = var7.z + MathHelper.nextDouble(var1.random, -1.0, 1.0) * (var10 ? 0.5 : var3);
            double var19 = var8 ? MathHelper.nextDouble(var1.random, -1.0, 1.0) : 0.0;
            double var21 = var9 ? MathHelper.nextDouble(var1.random, -1.0, 1.0) : 0.0;
            double var23 = var10 ? MathHelper.nextDouble(var1.random, -1.0, 1.0) : 0.0;
            var1.addParticle(var5, var13, var15, var17, var19, var21, var23);
        }
    }

    public static void spawnParticleOnFace(World var0, BlockPosition var1, EnumDirection var2, ParticleParam var3) {
        Vec3D var4 = Vec3D.atCenterOf(var1);
        int var5 = var2.getStepX();
        int var6 = var2.getStepY();
        int var7 = var2.getStepZ();
        double var8 = var4.x + (var5 == 0 ? MathHelper.nextDouble(var0.random, -0.5, 0.5) : (double)var5 * 0.55);
        double var10 = var4.y + (var6 == 0 ? MathHelper.nextDouble(var0.random, -0.5, 0.5) : (double)var6 * 0.55);
        double var12 = var4.z + (var7 == 0 ? MathHelper.nextDouble(var0.random, -0.5, 0.5) : (double)var7 * 0.55);
        double var14 = var5 == 0 ? MathHelper.nextDouble(var0.random, -1.0, 1.0) : 0.0;
        double var16 = var6 == 0 ? MathHelper.nextDouble(var0.random, -1.0, 1.0) : 0.0;
        double var18 = var7 == 0 ? MathHelper.nextDouble(var0.random, -1.0, 1.0) : 0.0;
        var0.addParticle(var3, var8, var10, var12, var14, var16, var18);
    }
}

