/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.util.IProgressUpdate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpUtilities {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ListeningExecutorService DOWNLOAD_EXECUTOR = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).setNameFormat("Downloader %d").build()));

    private HttpUtilities() {
    }

    public static String buildQuery(Map<String, Object> var0) {
        StringBuilder var1 = new StringBuilder();
        for (Map.Entry<String, Object> var3 : var0.entrySet()) {
            if (var1.length() > 0) {
                var1.append('&');
            }
            try {
                var1.append(URLEncoder.encode(var3.getKey(), "UTF-8"));
            }
            catch (UnsupportedEncodingException var4) {
                var4.printStackTrace();
            }
            if (var3.getValue() == null) continue;
            var1.append('=');
            try {
                var1.append(URLEncoder.encode(var3.getValue().toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException var4) {
                var4.printStackTrace();
            }
        }
        return var1.toString();
    }

    public static String performPost(URL var0, Map<String, Object> var1, boolean var2, @Nullable Proxy var3) {
        return HttpUtilities.performPost(var0, HttpUtilities.buildQuery(var1), var2, var3);
    }

    private static String performPost(URL var0, String var1, boolean var2, @Nullable Proxy var3) {
        try {
            String var7;
            if (var3 == null) {
                var3 = Proxy.NO_PROXY;
            }
            HttpURLConnection var4 = (HttpURLConnection)var0.openConnection(var3);
            var4.setRequestMethod("POST");
            var4.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            var4.setRequestProperty("Content-Length", "" + var1.getBytes().length);
            var4.setRequestProperty("Content-Language", "en-US");
            var4.setUseCaches(false);
            var4.setDoInput(true);
            var4.setDoOutput(true);
            DataOutputStream var5 = new DataOutputStream(var4.getOutputStream());
            var5.writeBytes(var1);
            var5.flush();
            var5.close();
            BufferedReader var6 = new BufferedReader(new InputStreamReader(var4.getInputStream()));
            StringBuilder var8 = new StringBuilder();
            while ((var7 = var6.readLine()) != null) {
                var8.append(var7);
                var8.append('\r');
            }
            var6.close();
            return var8.toString();
        }
        catch (Exception var4) {
            if (!var2) {
                LOGGER.error("Could not post to {}", (Object)var0, (Object)var4);
            }
            return "";
        }
    }

    public static CompletableFuture<?> downloadTo(File var0, String var1, Map<String, String> var2, int var3, @Nullable IProgressUpdate var4, Proxy var5) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, (Executor)DOWNLOAD_EXECUTOR);
    }

    public static int getAvailablePort() {
        int n2;
        ServerSocket var0 = new ServerSocket(0);
        try {
            n2 = var0.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    var0.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException var02) {
                return 25564;
            }
        }
        var0.close();
        return n2;
    }
}

