/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.tags.Tag;
import net.minecraft.tags.Tags;
import net.minecraft.util.ChatDeserializer;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TagDataPack<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final String PATH_SUFFIX = ".json";
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private final Function<MinecraftKey, Optional<T>> idToValue;
    private final String directory;

    public TagDataPack(Function<MinecraftKey, Optional<T>> var0, String var1) {
        this.idToValue = var0;
        this.directory = var1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<MinecraftKey, Tag.a> load(IResourceManager var02) {
        HashMap var1 = Maps.newHashMap();
        for (MinecraftKey var3 : var02.listResources(this.directory, var0 -> var0.endsWith(PATH_SUFFIX))) {
            String var4 = var3.getPath();
            MinecraftKey var5 = new MinecraftKey(var3.getNamespace(), var4.substring(this.directory.length() + 1, var4.length() - PATH_SUFFIX_LENGTH));
            try {
                for (IResource var7 : var02.getResources(var3)) {
                    try {
                        InputStream var8 = var7.getInputStream();
                        try (BufferedReader var9 = new BufferedReader(new InputStreamReader(var8, StandardCharsets.UTF_8));){
                            JsonObject var10 = ChatDeserializer.fromJson(GSON, (Reader)var9, JsonObject.class);
                            if (var10 == null) {
                                LOGGER.error("Couldn't load tag list {} from {} in data pack {} as it is empty or null", (Object)var5, (Object)var3, (Object)var7.getSourceName());
                                continue;
                            }
                            var1.computeIfAbsent(var5, var0 -> Tag.a.tag()).addFromJson(var10, var7.getSourceName());
                        }
                        finally {
                            if (var8 == null) continue;
                            var8.close();
                        }
                    }
                    catch (IOException | RuntimeException var8) {
                        LOGGER.error("Couldn't read tag list {} from {} in data pack {}", (Object)var5, (Object)var3, (Object)var7.getSourceName(), (Object)var8);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)var7);
                    }
                }
            }
            catch (IOException var6) {
                LOGGER.error("Couldn't read tag list {} from {}", (Object)var5, (Object)var3, (Object)var6);
            }
        }
        return var1;
    }

    private static void visitDependenciesAndElement(Map<MinecraftKey, Tag.a> var0, Multimap<MinecraftKey, MinecraftKey> var1, Set<MinecraftKey> var2, MinecraftKey var3, BiConsumer<MinecraftKey, Tag.a> var42) {
        if (!var2.add(var3)) {
            return;
        }
        var1.get((Object)var3).forEach(var4 -> TagDataPack.visitDependenciesAndElement(var0, var1, var2, var4, var42));
        Tag.a var5 = var0.get(var3);
        if (var5 != null) {
            var42.accept(var3, var5);
        }
    }

    private static boolean isCyclic(Multimap<MinecraftKey, MinecraftKey> var0, MinecraftKey var1, MinecraftKey var22) {
        Collection var3 = var0.get((Object)var22);
        if (var3.contains(var1)) {
            return true;
        }
        return var3.stream().anyMatch(var2 -> TagDataPack.isCyclic(var0, var1, var2));
    }

    private static void addDependencyIfNotCyclic(Multimap<MinecraftKey, MinecraftKey> var0, MinecraftKey var1, MinecraftKey var2) {
        if (!TagDataPack.isCyclic(var0, var1, var2)) {
            var0.put((Object)var1, (Object)var2);
        }
    }

    public Tags<T> build(Map<MinecraftKey, Tag.a> var02) {
        HashMap var1 = Maps.newHashMap();
        Function<MinecraftKey, Tag> var2 = var1::get;
        Function<MinecraftKey, Object> var3 = var0 -> this.idToValue.apply((MinecraftKey)var0).orElse(null);
        HashMultimap var4 = HashMultimap.create();
        var02.forEach((arg_0, arg_1) -> TagDataPack.b((Multimap)var4, arg_0, arg_1));
        var02.forEach((arg_0, arg_1) -> TagDataPack.a((Multimap)var4, arg_0, arg_1));
        HashSet var5 = Sets.newHashSet();
        var02.keySet().forEach(arg_0 -> TagDataPack.a(var02, (Multimap)var4, var5, var2, var3, var1, arg_0));
        return Tags.of(var1);
    }

    public Tags<T> loadAndBuild(IResourceManager var0) {
        return this.build(this.load(var0));
    }

    private static /* synthetic */ void a(Map var0, Multimap var1, Set var2, Function var32, Function var42, Map var5, MinecraftKey var6) {
        TagDataPack.visitDependenciesAndElement(var0, (Multimap<MinecraftKey, MinecraftKey>)var1, var2, var6, (var3, var4) -> var4.build(var32, var42).ifLeft(var1 -> LOGGER.error("Couldn't load tag {} as it is missing following references: {}", var3, (Object)var1.stream().map(Objects::toString).collect(Collectors.joining(",")))).ifRight(var2 -> var5.put(var3, var2)));
    }

    private static /* synthetic */ void a(Multimap var0, MinecraftKey var1, Tag.a var22) {
        var22.visitOptionalDependencies(var2 -> TagDataPack.addDependencyIfNotCyclic((Multimap<MinecraftKey, MinecraftKey>)var0, var1, var2));
    }

    private static /* synthetic */ void b(Multimap var0, MinecraftKey var1, Tag.a var22) {
        var22.visitRequiredDependencies(var2 -> TagDataPack.addDependencyIfNotCyclic((Multimap<MinecraftKey, MinecraftKey>)var0, var1, var2));
    }
}

