/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IReloadable;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.server.packs.resources.ReloadableProfiled;
import net.minecraft.server.packs.resources.ResourceManagerFallback;
import net.minecraft.util.Unit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class ResourceManager
implements IReloadableResourceManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, ResourceManagerFallback> namespacedPacks = Maps.newHashMap();
    private final List<IReloadListener> listeners = Lists.newArrayList();
    private final Set<String> namespaces = Sets.newLinkedHashSet();
    private final List<IResourcePack> packs = Lists.newArrayList();
    private final EnumResourcePackType type;

    public ResourceManager(EnumResourcePackType var0) {
        this.type = var0;
    }

    public void add(IResourcePack var0) {
        this.packs.add(var0);
        for (String var2 : var0.getNamespaces(this.type)) {
            this.namespaces.add(var2);
            ResourceManagerFallback var3 = this.namespacedPacks.get(var2);
            if (var3 == null) {
                var3 = new ResourceManagerFallback(this.type, var2);
                this.namespacedPacks.put(var2, var3);
            }
            var3.add(var0);
        }
    }

    @Override
    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public IResource getResource(MinecraftKey var0) throws IOException {
        IResourceManager var1 = this.namespacedPacks.get(var0.getNamespace());
        if (var1 != null) {
            return var1.getResource(var0);
        }
        throw new FileNotFoundException(var0.toString());
    }

    @Override
    public boolean hasResource(MinecraftKey var0) {
        IResourceManager var1 = this.namespacedPacks.get(var0.getNamespace());
        if (var1 != null) {
            return var1.hasResource(var0);
        }
        return false;
    }

    @Override
    public List<IResource> getResources(MinecraftKey var0) throws IOException {
        IResourceManager var1 = this.namespacedPacks.get(var0.getNamespace());
        if (var1 != null) {
            return var1.getResources(var0);
        }
        throw new FileNotFoundException(var0.toString());
    }

    @Override
    public Collection<MinecraftKey> listResources(String var0, Predicate<String> var1) {
        HashSet var2 = Sets.newHashSet();
        for (ResourceManagerFallback var4 : this.namespacedPacks.values()) {
            var2.addAll(var4.listResources(var0, var1));
        }
        ArrayList var3 = Lists.newArrayList((Iterable)var2);
        Collections.sort(var3);
        return var3;
    }

    private void clear() {
        this.namespacedPacks.clear();
        this.namespaces.clear();
        this.packs.forEach(IResourcePack::close);
        this.packs.clear();
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void registerReloadListener(IReloadListener var0) {
        this.listeners.add(var0);
    }

    @Override
    public IReloadable createReload(Executor var0, Executor var1, CompletableFuture<Unit> var2, List<IResourcePack> var3) {
        LOGGER.info("Reloading ResourceManager: {}", new Supplier[]{() -> var3.stream().map(IResourcePack::getName).collect(Collectors.joining(", "))});
        this.clear();
        for (IResourcePack var5 : var3) {
            try {
                this.add(var5);
            }
            catch (Exception var6) {
                LOGGER.error("Failed to add resource pack {}", (Object)var5.getName(), (Object)var6);
                return new a(new b(var5, (Throwable)var6));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            return new ReloadableProfiled(this, Lists.newArrayList(this.listeners), var0, var1, var2);
        }
        return Reloadable.of(this, Lists.newArrayList(this.listeners), var0, var1, var2);
    }

    @Override
    public Stream<IResourcePack> listPacks() {
        return this.packs.stream();
    }

    static class a
    implements IReloadable {
        private final b exception;
        private final CompletableFuture<Unit> failedFuture;

        public a(b var0) {
            this.exception = var0;
            this.failedFuture = new CompletableFuture();
            this.failedFuture.completeExceptionally(var0);
        }

        @Override
        public CompletableFuture<Unit> done() {
            return this.failedFuture;
        }

        @Override
        public float getActualProgress() {
            return 0.0f;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public void checkExceptions() {
            throw this.exception;
        }
    }

    public static class b
    extends RuntimeException {
        private final IResourcePack pack;

        public b(IResourcePack var0, Throwable var1) {
            super(var0.getName(), var1);
            this.pack = var0;
        }

        public IResourcePack getPack() {
            return this.pack;
        }
    }
}

